/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.editors.FormatSelector;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AbstractFormatterFactoryEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
PropertyChangeListener,
FormAwareEditor {
    private FormatSelector selector;
    private FormProperty property;
    private static final String PRE_MASK_CODE = "try {";
    private static final String POST_MASK_CODE = "} catch (java.text.ParseException ex) {\nex.printStackTrace();\n}";
    private static final String XML_FORMAT = "Format";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SUBTYPE = "subtype";
    private static final String ATTR_FORMAT = "format";

    public Component getCustomEditor() {
        Object object;
        if (this.selector == null) {
            this.selector = new FormatSelector();
            this.selector.addPropertyChangeListener(this);
        }
        if ((object = this.getValue()) instanceof FormFormatter) {
            FormFormatter formFormatter = (FormFormatter)object;
            this.selector.setFormat(formFormatter.getFormat());
        } else {
            this.selector.setFormat(new FormatSelector.FormatInfo(0, 0, null));
            this.propertyChange(null);
        }
        return this.selector.getSelectorPanel();
    }

    public String getJavaInitializationString() {
        Object object = this.getValue();
        if (!(object instanceof FormFormatter)) {
            return super.getJavaInitializationString();
        }
        FormFormatter formFormatter = (FormFormatter)object;
        FormatSelector.FormatInfo formatInfo = formFormatter.getFormat();
        int n = formatInfo.getType();
        int n2 = formatInfo.getSubtype();
        String string = formatInfo.getFormat();
        if (string != null) {
            string = "\"" + string.replace("\"", "\\\"") + "\"";
        }
        String string2 = null;
        if (n == 5) {
            string2 = "new javax.swing.text.MaskFormatter(" + string + ")";
        } else if (n == 1) {
            switch (n2) {
                case -1: {
                    string2 = "new java.text.SimpleDateFormat(" + string + ")";
                    break;
                }
                case 0: {
                    string2 = "";
                    break;
                }
                case 1: {
                    string2 = "java.text.DateFormat.getDateInstance(java.text.DateFormat.SHORT)";
                    break;
                }
                case 2: {
                    string2 = "java.text.DateFormat.getDateInstance(java.text.DateFormat.MEDIUM)";
                    break;
                }
                case 3: {
                    string2 = "java.text.DateFormat.getDateInstance(java.text.DateFormat.LONG)";
                    break;
                }
                case 4: {
                    string2 = "java.text.DateFormat.getDateInstance(java.text.DateFormat.FULL)";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            string2 = "new javax.swing.text.DateFormatter(" + string2 + ")";
        } else if (n == 2) {
            switch (n2) {
                case -1: {
                    string2 = "new java.text.SimpleDateFormat(" + string + ")";
                    break;
                }
                case 0: {
                    string2 = "java.text.DateFormat.getTimeInstance()";
                    break;
                }
                case 1: {
                    string2 = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.SHORT)";
                    break;
                }
                case 2: {
                    string2 = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.MEDIUM)";
                    break;
                }
                case 3: {
                    string2 = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.LONG)";
                    break;
                }
                case 4: {
                    string2 = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.FULL)";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            string2 = "new javax.swing.text.DateFormatter(" + string2 + ")";
        } else if (n == 0) {
            switch (n2) {
                case -1: {
                    string2 = "new java.text.DecimalFormat(" + string + ")";
                    break;
                }
                case 0: {
                    string2 = "";
                    break;
                }
                case 1: {
                    string2 = "java.text.NumberFormat.getIntegerInstance()";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            string2 = "new javax.swing.text.NumberFormatter(" + string2 + ")";
        } else if (n == 3) {
            string2 = n2 == 0 ? "java.text.NumberFormat.getPercentInstance()" : "new java.text.DecimalFormat(" + string + ")";
            string2 = "new javax.swing.text.NumberFormatter(" + string2 + ")";
        } else if (n == 4) {
            string2 = n2 == 0 ? "java.text.NumberFormat.getCurrencyInstance()" : "new java.text.DecimalFormat(" + string + ")";
            string2 = "new javax.swing.text.NumberFormatter(" + string2 + ")";
        }
        return "new javax.swing.text.DefaultFormatterFactory(" + string2 + ")";
    }

    public String getAsText() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = NbBundle.getMessage(AbstractFormatterFactoryEditor.class, (String)"MSG_AbstractFormatterFactory");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setValue(new FormFormatter(this.selector.getFormat()));
    }

    public void setValue(Object object) {
        this.updatePrePostCode(object, this.getValue());
        super.setValue(object);
    }

    private void updatePrePostCode(Object object, Object object2) {
        if (object instanceof FormFormatter && ((FormFormatter)object).getFormat().getType() == 5) {
            this.property.setPreCode(PRE_MASK_CODE);
            this.property.setPostCode(POST_MASK_CODE);
        } else if (object2 instanceof FormFormatter && ((FormFormatter)object2).getFormat().getType() == 5 || this.property.getPostCode() != null && this.property.getPreCode().trim().equals(PRE_MASK_CODE)) {
            this.property.setPreCode(null);
            this.property.setPostCode(null);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void readFromXML(Node node) throws IOException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue();
        String string2 = namedNodeMap.getNamedItem(ATTR_SUBTYPE).getNodeValue();
        String string3 = null;
        Node node2 = namedNodeMap.getNamedItem(ATTR_FORMAT);
        if (node2 != null) {
            string3 = node2.getNodeValue();
        }
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        this.setValue(new FormFormatter(new FormatSelector.FormatInfo(n, n2, string3)));
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_FORMAT);
        Object object = this.getValue();
        FormFormatter formFormatter = (FormFormatter)object;
        FormatSelector.FormatInfo formatInfo = formFormatter.getFormat();
        element.setAttribute(ATTR_TYPE, "" + formatInfo.getType());
        element.setAttribute(ATTR_SUBTYPE, "" + formatInfo.getSubtype());
        if (formatInfo.isCustomizable()) {
            element.setAttribute(ATTR_FORMAT, formatInfo.getFormat());
        }
        return element;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_AbstractFormatterFactoryEditor_DisplayName");
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.property = formProperty;
        try {
            this.updatePrePostCode(null, formProperty.getValue());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
        }
    }

    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    static class FormFormatter
    extends FormDesignValueAdapter {
        private FormatSelector.FormatInfo format;

        FormFormatter(FormatSelector.FormatInfo formatInfo) {
            this.format = formatInfo;
        }

        public FormatSelector.FormatInfo getFormat() {
            return this.format;
        }

        public Object getDesignValue() {
            DefaultFormatter defaultFormatter = null;
            int n = this.format.getType();
            if (n == 5) {
                try {
                    defaultFormatter = new MaskFormatter(this.format.getFormat());
                }
                catch (ParseException parseException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, parseException.getMessage(), parseException);
                    defaultFormatter = new MaskFormatter();
                }
            } else if (n == 1) {
                DateFormat dateFormat = null;
                switch (this.format.getSubtype()) {
                    case -1: {
                        dateFormat = new SimpleDateFormat(this.format.getFormat());
                        break;
                    }
                    case 0: {
                        dateFormat = DateFormat.getDateInstance();
                        break;
                    }
                    case 1: {
                        dateFormat = DateFormat.getDateInstance(3);
                        break;
                    }
                    case 2: {
                        dateFormat = DateFormat.getDateInstance(2);
                        break;
                    }
                    case 3: {
                        dateFormat = DateFormat.getDateInstance(1);
                        break;
                    }
                    case 4: {
                        dateFormat = DateFormat.getDateInstance(0);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                defaultFormatter = new DateFormatter(dateFormat);
            } else if (n == 2) {
                DateFormat dateFormat = null;
                switch (this.format.getSubtype()) {
                    case -1: {
                        dateFormat = new SimpleDateFormat(this.format.getFormat());
                        break;
                    }
                    case 0: {
                        dateFormat = DateFormat.getTimeInstance();
                        break;
                    }
                    case 1: {
                        dateFormat = DateFormat.getTimeInstance(3);
                        break;
                    }
                    case 2: {
                        dateFormat = DateFormat.getTimeInstance(2);
                        break;
                    }
                    case 3: {
                        dateFormat = DateFormat.getTimeInstance(1);
                        break;
                    }
                    case 4: {
                        dateFormat = DateFormat.getTimeInstance(0);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                defaultFormatter = new DateFormatter(dateFormat);
            } else if (n == 0) {
                NumberFormat numberFormat = null;
                switch (this.format.getSubtype()) {
                    case -1: {
                        numberFormat = new DecimalFormat(this.format.getFormat());
                        break;
                    }
                    case 0: {
                        numberFormat = NumberFormat.getInstance();
                        break;
                    }
                    case 1: {
                        numberFormat = NumberFormat.getIntegerInstance();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                defaultFormatter = new NumberFormatter(numberFormat);
            } else if (n == 3) {
                NumberFormat numberFormat = this.format.getSubtype() == 0 ? NumberFormat.getPercentInstance() : new DecimalFormat(this.format.getFormat());
                defaultFormatter = new NumberFormatter(numberFormat);
            } else if (n == 4) {
                NumberFormat numberFormat = this.format.getSubtype() == 0 ? NumberFormat.getCurrencyInstance() : new DecimalFormat(this.format.getFormat());
                defaultFormatter = new NumberFormatter(numberFormat);
            } else assert (false);
            return new DefaultFormatterFactory(defaultFormatter);
        }
    }
}

