/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.OverlayLayout;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.undo.UndoableEdit;
import org.jdesktop.layout.Baseline;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormToolBar;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.NonVisualTray;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.assistant.AssistantView;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.wizard.ConnectionWizard;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDesigner
extends TopComponent
implements MultiViewElement {
    static final String PROP_DESIGNER_SIZE = "designerSize";
    private JLayeredPane layeredPane;
    private ComponentLayer componentLayer;
    private HandleLayer handleLayer;
    private NonVisualTray nonVisualTray;
    private FormToolBar formToolBar;
    private InPlaceEditLayer textEditLayer;
    private FormProperty editedProperty;
    private InPlaceEditLayer.FinishListener finnishListener;
    private MenuEditLayer menuEditLayer;
    private FormModel formModel;
    private FormModelListener formModelListener;
    private RADVisualComponent topDesignComponent;
    private FormEditor formEditor;
    private List<RADComponent> selectedComponents = new ArrayList<RADComponent>();
    private List<RADComponent> selectedLayoutComponents = new ArrayList<RADComponent>();
    private VisualReplicator replicator;
    private LayoutDesigner layoutDesigner;
    private List<Action> designerActions;
    private List<Action> resizabilityActions;
    private JToggleButton[] resizabilityButtons;
    private int designerMode;
    public static final int MODE_SELECT = 0;
    public static final int MODE_CONNECT = 1;
    public static final int MODE_ADD = 2;
    private boolean initialized = false;
    private RADComponent connectionSource;
    private RADComponent connectionTarget;
    MultiViewElementCallback multiViewObserver;
    private ExplorerManager explorerManager;
    private FormProxyLookup lookup;
    private boolean settingLookup;
    private AssistantView assistantView;
    private PreferenceChangeListener settingsListener;
    private static String iconURL = "org/netbeans/modules/form/resources/formDesigner.gif";
    private boolean hasPropertyChangeListener = false;

    FormDesigner(FormEditor formEditor) {
        this.setIcon(ImageUtilities.loadImage((String)iconURL));
        this.setLayout(new BorderLayout());
        FormLoaderSettings formLoaderSettings = FormLoaderSettings.getInstance();
        Color color = formLoaderSettings.getFormDesignerBackgroundColor();
        Color color2 = formLoaderSettings.getFormDesignerBorderColor();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 12, 12 + (formLoaderSettings.getAssistantShown() ? 40 : 0)));
        jPanel.setBackground(color);
        JLabel jLabel = new JLabel(FormUtils.getBundleString("LBL_FormLoading"));
        jLabel.setOpaque(true);
        jLabel.setPreferredSize(new Dimension(410, 310));
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jLabel);
        jLabel.setBorder(new CompoundBorder(new LineBorder(color2, 5), new EmptyBorder(new Insets(6, 6, 6, 6))));
        this.add(jPanel, "Center");
        this.formEditor = formEditor;
        if (formEditor != null) {
            this.explorerManager = new ExplorerManager();
            ActionMap actionMap = ComponentInspector.getInstance().setupActionMap(this.getActionMap());
            FormDataObject formDataObject = formEditor.getFormDataObject();
            this.lookup = new FormProxyLookup(new Lookup[]{ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap), PaletteUtils.getPaletteLookup(formDataObject.getPrimaryFile()), Lookup.EMPTY});
            this.associateLookup((Lookup)this.lookup);
            this.formToolBar = new FormToolBar(this);
        }
        this.setMinimumSize(new Dimension(10, 10));
    }

    void initialize() {
        this.initialized = true;
        this.removeAll();
        this.formModel = this.formEditor.getFormModel();
        this.componentLayer = new ComponentLayer(this.formModel);
        this.handleLayer = new HandleLayer(this);
        this.nonVisualTray = FormEditor.isNonVisualTrayEnabled() ? new NonVisualTray(this.formModel) : null;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.componentLayer, "Center");
        if (this.nonVisualTray != null) {
            jPanel.add((Component)this.nonVisualTray, "South");
        }
        this.layeredPane = new JLayeredPane(){

            protected void paintChildren(Graphics graphics) {
                FormDesigner.this.handleLayer.maskDraggingComponents();
                super.paintChildren(graphics);
            }
        };
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)jPanel, new Integer(1000));
        this.layeredPane.add((Component)this.handleLayer, new Integer(1001));
        this.updateAssistant();
        this.settingsListener = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("assistantShown".equals(preferenceChangeEvent.getKey())) {
                    FormDesigner.this.updateAssistant();
                }
            }
        };
        FormLoaderSettings.getPreferences().addPreferenceChangeListener(this.settingsListener);
        JScrollPane jScrollPane = new JScrollPane(this.layeredPane);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.add(jScrollPane, "Center");
        this.explorerManager.setRootContext((Node)this.formEditor.getFormRootNode());
        if (!this.hasPropertyChangeListener) {
            this.addPropertyChangeListener("activatedNodes", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    try {
                        if (FormDesigner.this.formEditor == null) {
                            return;
                        }
                        FormDataObject formDataObject = FormDesigner.this.formEditor.getFormDataObject();
                        if (!formDataObject.isValid()) {
                            return;
                        }
                        Node node = formDataObject.getNodeDelegate();
                        Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
                        for (Node node2 : nodeArray) {
                            if (node2 == null || node2 == node) continue;
                            arrayList.add(node2);
                        }
                        FormDesigner.this.switchLookup(arrayList.isEmpty());
                        FormDesigner.this.explorerManager.setSelectedNodes(arrayList.toArray(new Node[arrayList.size()]));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                }
            });
            this.hasPropertyChangeListener = true;
        }
        if (this.formModelListener == null) {
            this.formModelListener = new FormListener();
        }
        this.formModel.addFormModelListener(this.formModelListener);
        this.replicator = new VisualReplicator(true, FormUtils.getViewConverters(), FormEditor.getBindingSupport(this.formModel));
        this.resetTopDesignComponent(false);
        this.handleLayer.setViewOnly(this.formModel.isReadOnly());
        if (this.formModel.getLayoutModel() != null) {
            this.layoutDesigner = new LayoutDesigner(this.formModel.getLayoutModel(), new LayoutMapper());
        }
        this.updateWholeDesigner();
        this.formEditor.reinstallListener();
        if (this.formEditor.getFormDesigner() == null) {
            this.formEditor.setFormDesigner(this);
        }
        this.getMenuEditLayer();
        jPanel.putClientProperty("print.printable", Boolean.TRUE);
        RADComponent rADComponent = this.formModel.getTopRADComponent();
        if (rADComponent == null) {
            ComponentInspector componentInspector = ComponentInspector.getInstance();
            componentInspector.focusForm(this.formEditor);
            try {
                componentInspector.setSelectedNodes(new Node[]{this.formEditor.getFormRootNode()}, this.formEditor);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.setSelectedComponent(rADComponent);
        }
    }

    void reset(FormEditor formEditor) {
        if (this.menuEditLayer != null) {
            this.menuEditLayer.hideMenuLayer();
            this.menuEditLayer = null;
        }
        if (this.initialized) {
            this.clearSelection();
            this.explorerManager.setRootContext((Node)new AbstractNode(Children.LEAF));
        }
        this.initialized = false;
        this.removeAll();
        this.componentLayer = null;
        this.handleLayer = null;
        this.nonVisualTray = null;
        this.layeredPane = null;
        if (this.textEditLayer != null) {
            if (this.textEditLayer.isVisible()) {
                this.textEditLayer.finishEditing(false);
            }
            this.textEditLayer.removeFinishListener(this.getFinnishListener());
            this.textEditLayer = null;
        }
        if (this.formModel != null) {
            if (this.formModelListener != null) {
                this.formModel.removeFormModelListener(this.formModelListener);
            }
            if (this.settingsListener != null) {
                FormLoaderSettings.getPreferences().removePreferenceChangeListener(this.settingsListener);
            }
            this.topDesignComponent = null;
            this.formModel = null;
        }
        this.replicator = null;
        this.layoutDesigner = null;
        this.connectionSource = null;
        this.connectionTarget = null;
        this.formEditor = formEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchLookup(boolean bl) {
        int n;
        boolean bl2;
        if (this.settingLookup) {
            return;
        }
        Lookup[] lookupArray = this.lookup.getSubLookups();
        boolean bl3 = bl2 = lookupArray[n = lookupArray.length - 1] != Lookup.EMPTY;
        if (bl != bl2) {
            lookupArray[n] = bl ? this.formEditor.getFormDataObject().getNodeDelegate().getLookup() : Lookup.EMPTY;
            try {
                this.settingLookup = true;
                this.lookup.setSubLookups(lookupArray);
            }
            finally {
                this.settingLookup = false;
            }
        }
    }

    private void updateAssistant() {
        if (FormLoaderSettings.getInstance().getAssistantShown()) {
            AssistantModel assistantModel = FormEditor.getAssistantModel(this.formModel);
            this.assistantView = new AssistantView(assistantModel);
            assistantModel.setContext("select");
            this.add(this.assistantView, "North");
        } else if (this.assistantView != null) {
            this.remove(this.assistantView);
            this.assistantView = null;
        }
        this.revalidate();
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    public HandleLayer getHandleLayer() {
        return this.handleLayer;
    }

    ComponentLayer getComponentLayer() {
        return this.componentLayer;
    }

    NonVisualTray getNonVisualTray() {
        return this.nonVisualTray;
    }

    FormToolBar getFormToolBar() {
        return this.formToolBar;
    }

    public LayoutDesigner getLayoutDesigner() {
        return this.layoutDesigner;
    }

    public FormEditor getFormEditor() {
        return this.formEditor;
    }

    public Action[] getActions() {
        Action[] actionArray = super.getActions();
        SystemAction systemAction = SystemAction.get(FileSystemAction.class);
        if (!Arrays.asList(actionArray).contains(systemAction)) {
            Action[] actionArray2 = new Action[actionArray.length + 1];
            System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
            actionArray2[actionArray.length] = systemAction;
            actionArray = actionArray2;
        }
        return actionArray;
    }

    public Object getComponent(RADComponent rADComponent) {
        return this.replicator.getClonedComponent(rADComponent.getId());
    }

    public Object getComponent(String string) {
        return this.replicator.getClonedComponent(string);
    }

    public RADComponent getMetaComponent(Object object) {
        String string = this.replicator.getClonedComponentId(object);
        return string != null ? this.formModel.getMetaComponent(string) : null;
    }

    public RADVisualComponent getTopDesignComponent() {
        return this.topDesignComponent;
    }

    boolean isTopRADComponent() {
        RADComponent rADComponent = this.formModel.getTopRADComponent();
        return rADComponent != null && rADComponent == this.topDesignComponent;
    }

    public void setTopDesignComponent(RADVisualComponent rADVisualComponent, boolean bl) {
        this.highlightTopDesignComponentName(false);
        this.topDesignComponent = rADVisualComponent;
        this.highlightTopDesignComponentName(!this.isTopRADComponent());
        FormDataObject formDataObject = this.formEditor.getFormDataObject();
        if (formDataObject != null) {
            formDataObject.getFormEditorSupport().updateMVTCDisplayName();
        }
        if (bl) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    private void highlightTopDesignComponentName(boolean bl) {
        RADComponentNode rADComponentNode;
        if (this.topDesignComponent != null && (rADComponentNode = this.topDesignComponent.getNodeReference()) != null) {
            rADComponentNode.highlightDisplayName(bl);
        }
    }

    public void resetTopDesignComponent(boolean bl) {
        RADComponent rADComponent = this.formModel.getTopRADComponent();
        this.setTopDesignComponent(rADComponent instanceof RADVisualComponent ? (RADVisualComponent)rADComponent : null, bl);
    }

    public boolean isInDesigner(RADVisualComponent rADVisualComponent) {
        Object object = this.replicator.getClonedComponent(rADVisualComponent);
        return object instanceof Component ? this.componentLayer.isAncestorOf((Component)object) : false;
    }

    void updateWholeDesigner() {
        if (this.formModelListener != null) {
            this.formModelListener.formChanged(null);
        }
    }

    private void updateComponentLayer(boolean bl) {
        if (this.formModel == null) {
            return;
        }
        if (this.getLayoutDesigner() == null) {
            return;
        }
        this.componentLayer.revalidate();
        RepaintManager.currentManager(this.componentLayer).validateInvalidComponents();
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        if (this.getLayoutDesigner().updateCurrentState() && bl) {
            this.formModel.fireFormChanged(true);
        }
        layoutModel.endUndoableEdit();
        this.updateResizabilityActions();
        this.componentLayer.repaint();
    }

    void updateContainerLayout(RADVisualContainer rADVisualContainer) {
        this.replicator.updateContainerLayout(rADVisualContainer);
        this.componentLayer.revalidate();
        this.componentLayer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Container createFormView(final RADComponent rADComponent, final FormLAF.PreviewInfo previewInfo) throws Exception {
        Container container = null;
        FormModel formModel = rADComponent.getFormModel();
        FileObject fileObject = FormEditor.getFormDataObject(formModel).getFormFile();
        final ClassLoader classLoader = ClassPathUtils.getProjectClassLoader(fileObject);
        Locale locale = FormDesigner.switchToDesignLocale(formModel);
        try {
            FormLAF.setUsePreviewDefaults(classLoader, previewInfo);
            container = (Container)FormLAF.executeWithLookAndFeel(formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    VisualReplicator visualReplicator = new VisualReplicator(false, FormUtils.getViewConverters(), null);
                    visualReplicator.setTopMetaComponent(rADComponent);
                    Object object = visualReplicator.createClone();
                    if (object instanceof RootPaneContainer) {
                        JRootPane jRootPane = ((RootPaneContainer)object).getRootPane();
                        JLayeredPane jLayeredPane = new JLayeredPane(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void paint(Graphics graphics) {
                                try {
                                    FormLAF.setUsePreviewDefaults(classLoader, previewInfo);
                                    super.paint(graphics);
                                }
                                finally {
                                    FormLAF.setUsePreviewDefaults(null, null);
                                }
                            }
                        };
                        JLayeredPane jLayeredPane2 = jRootPane.getLayeredPane();
                        Component[] componentArray = jLayeredPane2.getComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            jLayeredPane.add(componentArray[i], (Object)jLayeredPane2.getLayer(componentArray[i]));
                        }
                        jRootPane.setLayeredPane(jLayeredPane);
                        jRootPane.getGlassPane().setVisible(true);
                        jRootPane.putClientProperty("designPreview", Boolean.TRUE);
                    }
                    return object;
                }
            });
        }
        finally {
            FormLAF.setUsePreviewDefaults(null, null);
            if (locale != null) {
                Locale.setDefault(locale);
            }
        }
        return container;
    }

    private static Locale switchToDesignLocale(FormModel formModel) {
        Locale locale = null;
        String string = FormEditor.getResourceSupport(formModel).getDesignLocale();
        if (string != null && !string.equals("")) {
            String string2;
            int n;
            locale = Locale.getDefault();
            String[] stringArray = string.split("_");
            if ("".equals(stringArray[n = 0])) {
                ++n;
            }
            String string3 = n < stringArray.length ? stringArray[n++] : null;
            String string4 = n < stringArray.length ? stringArray[n++] : "";
            String string5 = string2 = n < stringArray.length ? stringArray[n] : "";
            if (string3 != null) {
                Locale.setDefault(new Locale(string3, string4, string2));
            }
        }
        return locale;
    }

    Component getTopDesignComponentView() {
        return this.topDesignComponent != null ? (Component)this.replicator.getClonedComponent(this.topDesignComponent) : null;
    }

    Point pointFromComponentToHandleLayer(Point point, Component component) {
        Component component2;
        JLayeredPane jLayeredPane = this.layeredPane;
        for (component2 = component; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x += component2.getX();
            point.y += component2.getY();
        }
        for (component2 = this.handleLayer; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x -= component2.getX();
            point.y -= component2.getY();
        }
        return point;
    }

    Point pointFromHandleToComponentLayer(Point point, Component component) {
        Component component2;
        JLayeredPane jLayeredPane = this.layeredPane;
        for (component2 = this.handleLayer; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x += component2.getX();
            point.y += component2.getY();
        }
        for (component2 = component; component2 != jLayeredPane; component2 = component2.getParent()) {
            point.x -= component2.getX();
            point.y -= component2.getY();
        }
        return point;
    }

    boolean isCoordinatesRoot(Component component) {
        return this.layeredPane == component;
    }

    private Rectangle componentBoundsToTop(Component component) {
        Serializable serializable;
        if (component == null) {
            return null;
        }
        Component component2 = this.getTopDesignComponentView();
        int n = 0;
        int n2 = 0;
        if (component != component2) {
            for (serializable = component.getParent(); serializable != component2 && serializable != null; serializable = ((Component)serializable).getParent()) {
                n += ((Component)serializable).getX();
                n2 += ((Component)serializable).getY();
            }
        } else {
            n = -component2.getX();
            n2 = -component2.getY();
        }
        serializable = component.getBounds();
        ((Rectangle)serializable).x += n;
        ((Rectangle)serializable).y += n2;
        return serializable;
    }

    void setDesignerMode(int n) {
        Object object;
        this.formToolBar.updateDesignerMode(n);
        if (n == this.designerMode || !this.initialized) {
            return;
        }
        if (n == 2 && (object = PaletteUtils.getSelectedItem()) != null && "chooseBean".equals(((PaletteItem)object).getExplicitComponentType()) && ComponentInspector.getInstance().getFocusedForm() == this.formEditor) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(FormUtils.getBundleString("MSG_Choose_Bean"), FormUtils.getBundleString("TITLE_Choose_Bean"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (NotifyDescriptor.OK_OPTION.equals(inputLine.getValue())) {
                ((PaletteItem)object).setClassFromCurrentProject(inputLine.getInputText(), this.formEditor.getFormDataObject().getPrimaryFile());
            } else {
                this.toggleSelectionMode();
                return;
            }
        }
        this.designerMode = n;
        this.resetConnection();
        if (n == 1) {
            this.clearSelection();
        }
        this.handleLayer.endDragging(null);
        object = FormEditor.getAssistantModel(this.formModel);
        switch (n) {
            case 1: {
                ((AssistantModel)object).setContext("connectSource");
                break;
            }
            case 0: {
                ((AssistantModel)object).setContext("select");
            }
        }
    }

    public int getDesignerMode() {
        return this.designerMode;
    }

    public void toggleSelectionMode() {
        this.setDesignerMode(0);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleConnectionMode() {
        this.setDesignerMode(1);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleAddMode() {
        this.setDesignerMode(2);
        PaletteUtils.clearPaletteSelection();
    }

    Dimension getDesignerSize() {
        return this.componentLayer.getDesignerSize();
    }

    void setDesignerSize(Dimension dimension, Dimension dimension2) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSize(dimension);
        } else if (this.topDesignComponent != null) {
            if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
                dimension2 = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
                this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, dimension);
            }
            if (dimension2 == null) {
                dimension2 = this.getDesignerSize();
            }
            this.getFormModel().fireSyntheticPropertyChanged(this.topDesignComponent, PROP_DESIGNER_SIZE, dimension2, dimension);
        }
    }

    public void resetDesignerSize() {
        this.setDesignerSize(null, null);
    }

    void storeDesignerSize(Dimension dimension) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSizeImpl(dimension);
        } else if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
            this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, dimension);
        }
    }

    private void setupDesignerSize() {
        RADVisualFormContainer rADVisualFormContainer;
        Dimension dimension = null;
        RADVisualFormContainer rADVisualFormContainer2 = rADVisualFormContainer = this.topDesignComponent instanceof RADVisualFormContainer ? (RADVisualFormContainer)this.topDesignComponent : null;
        if (rADVisualFormContainer == null || rADVisualFormContainer.hasExplicitSize() || !RADVisualContainer.isFreeDesignContainer(this.topDesignComponent)) {
            if (rADVisualFormContainer != null) {
                dimension = rADVisualFormContainer.getDesignerSize();
            }
            if (dimension == null) {
                dimension = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
            }
            if (!(dimension != null || this.formModel.isFreeDesignDefaultLayout() && this.topDesignComponent != this.formModel.getTopRADComponent())) {
                dimension = new Dimension(400, 300);
            }
        }
        Dimension dimension2 = this.componentLayer.setDesignerSize(dimension);
        this.storeDesignerSize(dimension2);
    }

    private void checkDesignerSize() {
        if (!(!this.formModel.isFreeDesignDefaultLayout() && !RADVisualContainer.isFreeDesignContainer(this.topDesignComponent) || !(this.topDesignComponent instanceof RADVisualComponent) || this.topDesignComponent instanceof RADVisualFormContainer && ((RADVisualFormContainer)this.topDesignComponent).hasExplicitSize())) {
            Component component = this.getTopDesignComponentView();
            Component component2 = null;
            if (this.topDesignComponent instanceof RADVisualContainer) {
                component2 = ((RADVisualContainer)this.topDesignComponent).getContainerDelegate(component);
            }
            if (component2 == null) {
                component2 = component;
            }
            int n = component.getWidth() - component2.getWidth();
            int n2 = component.getHeight() - component2.getHeight();
            Dimension dimension = new Dimension(this.getDesignerSize());
            dimension.width -= n;
            dimension.height -= n2;
            Dimension dimension2 = component2.getMinimumSize();
            boolean bl = false;
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
                bl = true;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
                bl = true;
            }
            if (bl) {
                dimension.width += n;
                dimension.height += n2;
                if (this.formModel.isCompoundEditInProgress()) {
                    FormModelEvent formModelEvent = new FormModelEvent(this.formModel, 11);
                    formModelEvent.setComponentAndContainer(this.topDesignComponent, null);
                    formModelEvent.setProperty(PROP_DESIGNER_SIZE, this.getDesignerSize(), dimension);
                    this.formModel.addUndoableEdit(formModelEvent.getUndoableEdit());
                }
                this.componentLayer.setDesignerSize(dimension);
                this.storeDesignerSize(dimension);
            }
        }
    }

    public List<RADComponent> getSelectedComponents() {
        return this.selectedComponents;
    }

    Node[] getSelectedComponentNodes() {
        ArrayList<RADComponentNode> arrayList = new ArrayList<RADComponentNode>(this.selectedComponents.size());
        for (RADComponent rADComponent : this.selectedComponents) {
            if (rADComponent.getNodeReference() == null) continue;
            arrayList.add(rADComponent.getNodeReference());
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    List<RADComponent> getSelectedLayoutComponents() {
        return this.selectedLayoutComponents;
    }

    boolean isComponentSelected(RADComponent rADComponent) {
        return this.selectedComponents.contains(rADComponent);
    }

    public void setSelectedComponent(RADComponent rADComponent) {
        this.clearSelectionImpl();
        this.addComponentToSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    public void setSelectedComponents(RADComponent[] rADComponentArray) {
        this.clearSelectionImpl();
        for (int i = 0; i < rADComponentArray.length; ++i) {
            this.addComponentToSelectionImpl(rADComponentArray[i]);
        }
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void setSelectedNode(FormNode formNode) {
        if (formNode instanceof RADComponentNode) {
            this.setSelectedComponent(((RADComponentNode)formNode).getRADComponent());
        } else {
            this.clearSelectionImpl();
            this.repaintSelection();
            ComponentInspector componentInspector = ComponentInspector.getInstance();
            if (componentInspector.getFocusedForm() != this.formEditor) {
                return;
            }
            Node[] nodeArray = new Node[]{formNode};
            try {
                componentInspector.setSelectedNodes(nodeArray, this.formEditor);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
    }

    public void addComponentToSelection(RADComponent rADComponent) {
        this.addComponentToSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void addComponentsToSelection(RADComponent[] rADComponentArray) {
        for (int i = 0; i < rADComponentArray.length; ++i) {
            this.addComponentToSelectionImpl(rADComponentArray[i]);
        }
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void removeComponentFromSelection(RADComponent rADComponent) {
        this.removeComponentFromSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    public void clearSelection() {
        this.clearSelectionImpl();
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void addComponentToSelectionImpl(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.selectedComponents.add(rADComponent);
            RADVisualComponent rADVisualComponent = this.componentToLayoutComponent(rADComponent);
            if (rADVisualComponent != null) {
                this.selectedLayoutComponents.add(rADVisualComponent);
                this.ensureComponentIsShown((RADVisualComponent)rADComponent);
                this.selectionChanged();
            }
        }
    }

    RADVisualComponent componentToLayoutComponent(RADComponent rADComponent) {
        RADVisualComponent rADVisualComponent;
        if (rADComponent instanceof RADVisualComponent && !(rADVisualComponent = (RADVisualComponent)rADComponent).isMenuComponent()) {
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer != null && JScrollPane.class.isAssignableFrom(rADVisualContainer.getBeanInstance().getClass()) && this.isInDesigner(rADVisualContainer)) {
                return rADVisualContainer;
            }
            return this.isInDesigner(rADVisualComponent) ? rADVisualComponent : null;
        }
        return null;
    }

    void removeComponentFromSelectionImpl(RADComponent rADComponent) {
        this.selectedComponents.remove(rADComponent);
        this.selectedLayoutComponents.remove(rADComponent);
        this.selectionChanged();
    }

    void clearSelectionImpl() {
        this.selectedComponents.clear();
        this.selectedLayoutComponents.clear();
        this.selectionChanged();
    }

    void selectionChanged() {
        if (this.formModel == null) {
            return;
        }
        this.updateDesignerActions();
        this.updateResizabilityActions();
        this.updateAssistantContext();
    }

    void repaintSelection() {
        if (this.handleLayer != null) {
            this.handleLayer.repaint();
        }
    }

    private void updateDesignerActions() {
        Collection<String> collection = this.selectedLayoutComponentIds();
        boolean bl = this.layoutDesigner == null ? false : this.layoutDesigner.canAlign(collection);
        for (Action action : this.getDesignerActions(true)) {
            action.setEnabled(bl);
        }
    }

    void setResizabilityButtons(JToggleButton[] jToggleButtonArray) {
        this.resizabilityButtons = jToggleButtonArray;
    }

    public JToggleButton[] getResizabilityButtons() {
        return this.resizabilityButtons;
    }

    public void updateResizabilityActions() {
        int n;
        Collection<String> collection = this.componentIds();
        Action[] actionArray = this.getResizabilityActions().toArray(new Action[2]);
        RADVisualComponent rADVisualComponent = this.getTopDesignComponent();
        if (rADVisualComponent == null || collection.contains(rADVisualComponent.getId())) {
            for (Action action : actionArray) {
                action.setEnabled(false);
            }
            return;
        }
        LayoutModel layoutModel = this.getFormModel().getLayoutModel();
        LayoutDesigner layoutDesigner = this.getLayoutDesigner();
        Iterator<String> iterator = collection.iterator();
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        while (iterator.hasNext()) {
            String string = iterator.next();
            LayoutComponent layoutComponent = layoutModel.getLayoutComponent(string);
            for (n = 0; n < 2; ++n) {
                if (layoutDesigner.isComponentResizing(layoutComponent, n == 0 ? 0 : 1)) {
                    blArray[n] = true;
                    continue;
                }
                blArray2[n] = true;
            }
        }
        for (int i = 0; i < 2; ++i) {
            boolean bl = blArray[i];
            n = blArray2[i];
            this.getResizabilityButtons()[i].setSelected(n == 0 && bl);
            actionArray[i].setEnabled(bl || n != 0);
        }
    }

    private void updateAssistantContext() {
        String string = null;
        String string2 = null;
        List<RADComponent> list = this.getSelectedComponents();
        int n = list.size();
        if (n > 0) {
            ArrayList<String> arrayList;
            RADComponent rADComponent = list.get(0);
            if (this.layoutDesigner != null && this.layoutDesigner.isUnplacedComponent(rADComponent.getId())) {
                if (n > 1) {
                    arrayList = new ArrayList<String>(n);
                    for (RADComponent rADComponent2 : list) {
                        arrayList.add(rADComponent2.getId());
                    }
                    if (this.layoutDesigner.getDraggableComponents(arrayList).size() == n) {
                        string = "unplacedComponents1";
                        string2 = "unplacedComponents2";
                    }
                } else {
                    string = "unplacedComponent1";
                    string2 = "unplacedComponent2";
                }
            }
            if (n == 1 && string == null) {
                Object object;
                arrayList = rADComponent.getBeanInstance();
                if (arrayList instanceof JTabbedPane) {
                    object = (JTabbedPane)((Object)arrayList);
                    int n2 = ((JTabbedPane)object).getTabCount();
                    switch (n2) {
                        case 0: {
                            string = "tabbedPaneEmpty";
                            break;
                        }
                        case 1: {
                            string = "tabbedPaneOne";
                            break;
                        }
                        default: {
                            string = "tabbedPane";
                            break;
                        }
                    }
                } else if (arrayList instanceof JRadioButton) {
                    object = rADComponent.getPropertyByName("buttonGroup");
                    try {
                        if (object != null && object.getValue() == null) {
                            string = "buttonGroup";
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (arrayList instanceof JPanel && this.getTopDesignComponent() != rADComponent && Math.random() < 0.2) {
                    string = "designThisContainer";
                } else if (arrayList instanceof JComboBox && Math.random() < 0.4) {
                    string = "comboBoxModel";
                } else if (arrayList instanceof JList && Math.random() < 0.4) {
                    string = "listModel";
                } else if (arrayList instanceof JTable && Math.random() < 0.4) {
                    string = "tableModel";
                } else if (arrayList instanceof JScrollPane) {
                    object = (JScrollPane)((Object)arrayList);
                    if (((JScrollPane)object).getViewport() != null && ((JScrollPane)object).getViewport().getView() == null) {
                        string = "scrollPaneEmpty";
                    } else if (Math.random() < 0.5) {
                        string = "scrollPane";
                    }
                }
            }
        }
        if (string == null) {
            string = "select";
        }
        FormEditor.getAssistantModel(this.formModel).setContext(string, string2);
    }

    RADComponent getNextVisualComponent(boolean bl) {
        RADComponent rADComponent = null;
        int n = this.selectedComponents.size();
        if (n > 0) {
            if (n > 1) {
                return null;
            }
            RADComponent rADComponent2 = this.selectedComponents.get(0);
            if (rADComponent2 instanceof RADVisualComponent) {
                rADComponent = rADComponent2;
            } else {
                return null;
            }
        }
        return this.getNextVisualComponent(rADComponent, bl);
    }

    RADComponent getNextVisualComponent(RADComponent rADComponent, boolean bl) {
        RADComponent[] rADComponentArray;
        if (rADComponent == null) {
            return this.topDesignComponent;
        }
        if (this.getComponent(rADComponent) == null) {
            return null;
        }
        if (bl) {
            RADComponent[] rADComponentArray2 = this.getVisualSubComponents(rADComponent);
            if (rADComponentArray2.length > 0) {
                return rADComponentArray2[0];
            }
            if (rADComponent == this.topDesignComponent) {
                return this.topDesignComponent;
            }
            RADVisualContainer rADVisualContainer = (RADVisualContainer)rADComponent.getParentComponent();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADComponent);
            while (n >= 0) {
                rADComponentArray2 = rADVisualContainer.getSubComponents();
                if (n + 1 < rADComponentArray2.length) {
                    return rADComponentArray2[n + 1];
                }
                if (rADVisualContainer == this.topDesignComponent) break;
                rADComponent = rADVisualContainer;
                if ((rADVisualContainer = (RADVisualContainer)rADComponent.getParentComponent()) == null) {
                    return null;
                }
                n = rADVisualContainer.getIndexOf(rADComponent);
            }
            return this.topDesignComponent;
        }
        if (rADComponent != this.topDesignComponent) {
            RADVisualContainer rADVisualContainer = (RADVisualContainer)rADComponent.getParentComponent();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADComponent);
            if (n >= 0) {
                if (n == 0) {
                    return rADVisualContainer;
                }
                rADComponentArray = rADVisualContainer.getSubComponents();
                rADComponent = rADComponentArray[n - 1];
            } else {
                rADComponent = this.topDesignComponent;
            }
        }
        while ((rADComponentArray = this.getVisualSubComponents(rADComponent)).length > 0) {
            rADComponent = rADComponentArray[rADComponentArray.length - 1];
        }
        return rADComponent;
    }

    private RADComponent[] getVisualSubComponents(RADComponent rADComponent) {
        return rADComponent instanceof RADVisualContainer ? ((RADVisualContainer)rADComponent).getSubComponents() : new RADComponent[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void align(boolean bl, int n, int n2) {
        Object object;
        Object object3 = null;
        for (Action object22 : this.getDesignerActions(true)) {
            if (!(object22 instanceof AlignAction) || ((AlignAction)(object = (AlignAction)object22)).getAlignment() != n2 || ((AlignAction)object).getDimension() != n) continue;
            object3 = object;
            break;
        }
        if (object3 == null || !object3.isEnabled()) {
            return;
        }
        Collection<String> collection = this.selectedLayoutComponentIds();
        object = this.commonParent(collection);
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        Object object2 = layoutModel.getChangeMark();
        UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
        boolean bl2 = true;
        try {
            this.getLayoutDesigner().align(collection, bl, n, n2);
            bl2 = false;
        }
        finally {
            this.formModel.fireContainerLayoutChanged((RADVisualContainer)object, null, null, null);
            if (!object2.equals(layoutModel.getChangeMark())) {
                this.formModel.addUndoableEdit(undoableEdit);
            }
            if (bl2) {
                this.formModel.forceUndoOfCompoundEdit();
            }
        }
    }

    public Collection<Action> getDesignerActions(boolean bl) {
        if (this.designerActions == null) {
            this.designerActions = new LinkedList<Action>();
            this.designerActions.add(new AlignAction(0, 0, true));
            this.designerActions.add(new AlignAction(0, 1, true));
            this.designerActions.add(new AlignAction(0, 2, true));
            this.designerActions.add(new AlignAction(1, 0, true));
            this.designerActions.add(new AlignAction(1, 1, true));
            this.designerActions.add(new AlignAction(1, 2, true));
            this.designerActions.add(new AlignAction(0, 0, false));
            this.designerActions.add(new AlignAction(0, 1, false));
            this.designerActions.add(new AlignAction(1, 0, false));
            this.designerActions.add(new AlignAction(1, 1, false));
        }
        return bl ? this.designerActions.subList(0, 6) : this.designerActions;
    }

    public Collection<Action> getResizabilityActions() {
        if (this.resizabilityActions == null) {
            this.resizabilityActions = new LinkedList<Action>();
            this.resizabilityActions.add(new ResizabilityAction(0));
            this.resizabilityActions.add(new ResizabilityAction(1));
        }
        return this.resizabilityActions;
    }

    Collection<String> selectedLayoutComponentIds() {
        Iterator<RADComponent> iterator = this.getSelectedLayoutComponents().iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            RADComponent rADComponent = iterator.next();
            linkedList.add(rADComponent.getId());
        }
        return linkedList;
    }

    private RADComponent commonParent(Collection collection) {
        RADComponent rADComponent = null;
        Iterator iterator = collection.iterator();
        FormModel formModel = this.getFormModel();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RADComponent rADComponent2 = formModel.getMetaComponent(string);
            RADComponent rADComponent3 = rADComponent2.getParentComponent();
            if (rADComponent == null) {
                rADComponent = rADComponent3;
            }
            if (rADComponent3 != null && rADComponent == rADComponent3) continue;
            return null;
        }
        return rADComponent;
    }

    void updateComponentInspector() {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditor) {
            return;
        }
        Node[] nodeArray = this.getSelectedComponentNodes();
        try {
            this.setActivatedNodes(nodeArray);
            componentInspector.setSelectedNodes(nodeArray, this.formEditor);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    void updateVisualSettings() {
        this.componentLayer.updateVisualSettings();
        if (this.nonVisualTray != null) {
            this.nonVisualTray.updateVisualSettings();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void ensureComponentIsShown(RADVisualComponent rADVisualComponent) {
        Component component = (Component)this.getComponent(rADVisualComponent);
        if (component == null) {
            return;
        }
        if (component.isShowing()) {
            return;
        }
        if (!this.isInDesigner(rADVisualComponent)) {
            return;
        }
        Component component2 = (Component)this.getComponent(this.topDesignComponent);
        if (component2 == null || !component2.isShowing()) {
            return;
        }
        RADVisualComponent rADVisualComponent2 = rADVisualComponent;
        for (RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer(); rADVisualContainer != null; rADVisualContainer = rADVisualContainer.getParentContainer()) {
            Container container = (Container)this.getComponent(rADVisualContainer);
            LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
            if (layoutSupportManager != null) {
                Container container2 = rADVisualContainer.getContainerDelegate(container);
                layoutSupportManager.selectComponent(rADVisualComponent2.getComponentIndex());
                layoutSupportManager.arrangeContainer(container, container2);
            }
            if (rADVisualContainer == this.topDesignComponent || container.isShowing()) break;
            rADVisualComponent2 = rADVisualContainer;
        }
    }

    void connectBean(RADComponent rADComponent, boolean bl) {
        if (this.connectionSource == null) {
            this.connectionSource = rADComponent;
            FormEditor.getAssistantModel(this.formModel).setContext("connectTarget");
            this.handleLayer.repaint();
        } else {
            if (rADComponent == this.connectionSource) {
                if (this.connectionTarget != null) {
                    this.resetConnection();
                    this.toggleSelectionMode();
                }
                return;
            }
            this.connectionTarget = rADComponent;
            this.handleLayer.repaint();
            if (bl) {
                if (this.connectionTarget != null) {
                    FormEditor.getAssistantModel(this.formModel).setContext("connectWizard");
                    this.createConnection(this.connectionSource, this.connectionTarget);
                }
                this.toggleSelectionMode();
            }
        }
    }

    public RADComponent getConnectionSource() {
        return this.connectionSource;
    }

    public RADComponent getConnectionTarget() {
        return this.connectionTarget;
    }

    public void resetConnection() {
        if (this.connectionSource != null || this.connectionTarget != null) {
            this.connectionSource = null;
            this.connectionTarget = null;
            this.handleLayer.repaint();
        }
    }

    private void createConnection(RADComponent rADComponent, RADComponent rADComponent2) {
        ConnectionWizard connectionWizard = new ConnectionWizard(this.formModel, rADComponent, rADComponent2);
        if (connectionWizard.show()) {
            final Event event = connectionWizard.getSelectedEvent();
            final String string = connectionWizard.getEventName();
            String string2 = connectionWizard.getGeneratedCode();
            this.formModel.getFormEvents().attachEvent(event, string, string2);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FormDesigner.this.formModel.getFormEvents().attachEvent(event, string, null);
                }
            });
        }
    }

    public void startInPlaceEditing(RADComponent rADComponent) {
        Object object;
        if (this.formModel.isReadOnly()) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            return;
        }
        if (!this.isEditableInPlace(rADComponent)) {
            return;
        }
        Component component = (Component)this.getComponent(rADComponent);
        if (component == null) {
            this.notifyCannotEditInPlace();
            return;
        }
        FormProperty formProperty = null;
        if (JTabbedPane.class.isAssignableFrom(rADComponent.getBeanClass())) {
            object = (JTabbedPane)component;
            int n = ((JTabbedPane)object).getSelectedIndex();
            RADVisualContainer rADVisualContainer = (RADVisualContainer)rADComponent;
            RADVisualComponent rADVisualComponent = rADVisualContainer.getSubComponent(n);
            Node.Property[] propertyArray = rADVisualComponent.getConstraintsProperties();
            for (int i = 0; i < propertyArray.length; ++i) {
                if (!propertyArray[i].getName().equals("TabConstraints.tabTitle")) continue;
                if (propertyArray[i] instanceof FormProperty) {
                    formProperty = (FormProperty)propertyArray[i];
                    continue;
                }
                return;
            }
            if (formProperty == null) {
                return;
            }
        } else {
            formProperty = rADComponent.getBeanProperty("text");
            if (formProperty == null) {
                return;
            }
        }
        object = null;
        try {
            Object object2 = formProperty.getRealValue();
            if (!(object2 instanceof String)) {
                object2 = "";
            }
            object = (String)object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.editedProperty = formProperty;
        this.getInPlaceEditLayer();
        try {
            this.textEditLayer.setEditedComponent(component, (String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.notifyCannotEditInPlace();
            return;
        }
        this.textEditLayer.setVisible(true);
        this.handleLayer.setVisible(false);
        this.textEditLayer.requestFocus();
    }

    private InPlaceEditLayer.FinishListener getFinnishListener() {
        if (this.finnishListener == null) {
            this.finnishListener = new InPlaceEditLayer.FinishListener(){

                public void editingFinished(boolean bl) {
                    FormDesigner.this.finishInPlaceEditing(FormDesigner.this.textEditLayer.isTextChanged());
                }
            };
        }
        return this.finnishListener;
    }

    private void finishInPlaceEditing(boolean bl) {
        if (bl) {
            try {
                Object object = this.editedProperty.getValue();
                if (object instanceof String) {
                    this.editedProperty.setValue(this.textEditLayer.getEditedText());
                } else {
                    PropertyEditor propertyEditor = this.editedProperty.findDefaultEditor();
                    this.editedProperty.setValue(new FormProperty.ValueWithEditor(this.textEditLayer.getEditedText(), propertyEditor));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.handleLayer != null) {
            this.textEditLayer.setVisible(false);
            this.handleLayer.setVisible(true);
            this.handleLayer.requestFocus();
        }
        this.editedProperty = null;
    }

    public boolean isEditableInPlace(RADComponent rADComponent) {
        if (rADComponent == null) {
            return false;
        }
        Object object = this.getComponent(rADComponent);
        if (!(object instanceof Component)) {
            return false;
        }
        for (RADComponent rADComponent2 = rADComponent.getParentComponent(); rADComponent2 != null; rADComponent2 = rADComponent2.getParentComponent()) {
            if (JComponent.class.isAssignableFrom(rADComponent2.getBeanClass()) || RootPaneContainer.class.isAssignableFrom(rADComponent2.getBeanClass())) continue;
            return false;
        }
        Class<? extends Object> clazz = rADComponent.getBeanClass();
        return InPlaceEditLayer.supportsEditingFor(clazz, false) && (!JTabbedPane.class.isAssignableFrom(clazz) || ((JTabbedPane)object).getTabCount() != 0);
    }

    private void notifyCannotEditInPlace() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_ComponentNotShown"), 2));
    }

    public void openMenu(RADComponent rADComponent) {
        MenuEditLayer menuEditLayer = this.getMenuEditLayer();
        Component component = (Component)this.getComponent(rADComponent);
        menuEditLayer.setVisible(true);
        menuEditLayer.openAndShowMenu(rADComponent, component);
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.formeditor");
    }

    public void componentActivated() {
        if (this.formModel == null) {
            return;
        }
        this.formEditor.setFormDesigner(this);
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditor) {
            componentInspector.focusForm(this.formEditor);
            if (this.getDesignerMode() == 1) {
                this.clearSelection();
            } else {
                this.updateComponentInspector();
            }
        }
        componentInspector.attachActions();
        if (this.textEditLayer == null || !this.textEditLayer.isVisible()) {
            this.handleLayer.requestFocus();
        }
    }

    public void componentDeactivated() {
        if (this.formModel == null) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            this.textEditLayer.finishEditing(false);
        }
        ComponentInspector.getInstance().detachActions();
        this.resetConnection();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager manager = this.formModel != null ? this.formModel.getUndoRedoManager() : null;
        return manager != null ? manager : super.getUndoRedo();
    }

    protected String preferredID() {
        return this.formEditor.getFormDataObject().getName();
    }

    public JComponent getToolbarRepresentation() {
        return this.getFormToolBar();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
        multiViewElementCallback.getTopComponent().putClientProperty((Object)"formDesigner", (Object)this);
        if (this.formEditor != null) {
            FormDataObject formDataObject = this.formEditor.getFormDataObject();
            formDataObject.getFormEditorSupport().setTopComponent(multiViewElementCallback.getTopComponent());
        }
    }

    public void requestVisible() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void componentClosed() {
        super.componentClosed();
        this.reset(null);
    }

    public void componentShowing() {
        super.componentShowing();
        if (!this.formEditor.isFormLoaded()) {
            this.formEditor.loadFormDesigner();
            if (!this.formEditor.isFormLoaded()) {
                this.removeAll();
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (FormDesigner.this.formEditor != null && FormDesigner.this.formEditor.isFormLoaded() && ComponentInspector.exists() && ComponentInspector.getInstance().getFocusedForm() == null) {
                        ComponentInspector.getInstance().focusForm(FormDesigner.this.formEditor);
                    }
                }
            });
        }
        if (!this.initialized) {
            this.initialize();
        }
        FormEditorSupport.checkFormGroupVisibility();
    }

    public void componentHidden() {
        super.componentHidden();
        FormEditorSupport.checkFormGroupVisibility();
    }

    public void componentOpened() {
        super.componentOpened();
        if (this.formEditor == null && this.multiViewObserver != null) {
            this.multiViewObserver.getTopComponent().close();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormEditorSupport.checkFormGroupVisibility();
                }
            });
        }
    }

    public CloseOperationState canCloseElement() {
        if (!FormEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_FORM_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public InPlaceEditLayer getInPlaceEditLayer() {
        if (this.textEditLayer == null) {
            this.textEditLayer = new InPlaceEditLayer();
            this.textEditLayer.setVisible(false);
            this.textEditLayer.addFinishListener(this.getFinnishListener());
            this.layeredPane.add((Component)this.textEditLayer, new Integer(2001));
        }
        return this.textEditLayer;
    }

    MenuEditLayer getMenuEditLayer() {
        if (this.menuEditLayer == null) {
            this.menuEditLayer = new MenuEditLayer(this);
            this.menuEditLayer.setVisible(false);
            this.layeredPane.add((Component)this.menuEditLayer, new Integer(2000));
        }
        return this.menuEditLayer;
    }

    private Collection<String> componentIds() {
        LinkedList<String> linkedList = new LinkedList<String>();
        List<RADComponent> list = this.getSelectedLayoutComponents();
        LayoutModel layoutModel = this.getFormModel().getLayoutModel();
        for (RADVisualComponent rADVisualComponent : list) {
            if (rADVisualComponent.getParentContainer() == null || rADVisualComponent.getParentLayoutSupport() != null || layoutModel.getLayoutComponent(rADVisualComponent.getId()) == null) continue;
            linkedList.add(rADVisualComponent.getId());
        }
        return linkedList;
    }

    static class FormProxyLookup
    extends ProxyLookup {
        FormProxyLookup(Lookup[] lookupArray) {
            super(lookupArray);
        }

        Lookup[] getSubLookups() {
            return this.getLookups();
        }

        void setSubLookups(Lookup[] lookupArray) {
            this.setLookups(lookupArray);
        }
    }

    private class ResizabilityAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/resize_";
        private int dimension;

        ResizabilityAction(int n) {
            this.dimension = n;
            String string = n == 0 ? "h" : "v";
            String string2 = ICON_BASE + string + ".png";
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)string2, (boolean)false));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_ResizeButton_" + string));
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            FormModel formModel = FormDesigner.this.getFormModel();
            LayoutModel layoutModel = formModel.getLayoutModel();
            Object object = layoutModel.getChangeMark();
            UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
            boolean bl = true;
            LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
            Collection collection = FormDesigner.this.componentIds();
            HashSet<RADVisualContainer> hashSet = new HashSet<RADVisualContainer>();
            try {
                for (String string : collection) {
                    LayoutComponent layoutComponent = layoutModel.getLayoutComponent(string);
                    boolean bl2 = FormDesigner.this.getResizabilityButtons()[this.dimension].isSelected();
                    if (layoutDesigner.isComponentResizing(layoutComponent, this.dimension) == bl2) continue;
                    layoutDesigner.setComponentResizing(layoutComponent, this.dimension, bl2);
                    RADVisualComponent rADVisualComponent = (RADVisualComponent)formModel.getMetaComponent(string);
                    hashSet.add(rADVisualComponent.getParentContainer());
                }
                bl = false;
            }
            finally {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    formModel.fireContainerLayoutChanged((RADVisualContainer)iterator.next(), null, null, null);
                }
                if (!object.equals(layoutModel.getChangeMark())) {
                    formModel.addUndoableEdit(undoableEdit);
                }
                if (bl) {
                    formModel.forceUndoOfCompoundEdit();
                }
            }
        }
    }

    private class AlignAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/align_";
        private int dimension;
        private int alignment;
        private boolean closed;

        AlignAction(int n, int n2, boolean bl) {
            boolean bl2;
            this.dimension = n;
            this.alignment = n2;
            this.closed = bl;
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n2 == 0;
            String string = n2 == 2 ? (bl3 ? "ch" : "cv") : (bl3 ? (bl2 ? "l" : "r") : (bl2 ? "u" : "d"));
            String string2 = ICON_BASE + string + ".png";
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)string2, (boolean)false));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_AlignAction_" + string));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FormDesigner.this.align(this.closed, this.dimension, this.alignment);
        }

        public int getDimension() {
            return this.dimension;
        }

        public int getAlignment() {
            return this.alignment;
        }
    }

    private class FormListener
    implements FormModelListener,
    Runnable {
        private FormModelEvent[] events;

        private FormListener() {
        }

        public void formChanged(final FormModelEvent[] formModelEventArray) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FormListener.this.processEvents(formModelEventArray);
                    }
                });
            } else {
                this.processEvents(formModelEventArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvents(FormModelEvent[] formModelEventArray) {
            boolean bl;
            if (formModelEventArray == null) {
                bl = true;
            } else {
                bl = false;
                boolean bl2 = false;
                for (int i = 0; i < formModelEventArray.length; ++i) {
                    FormModelEvent formModelEvent = formModelEventArray[i];
                    if (formModelEvent.isModifying()) {
                        bl2 = true;
                    }
                    if (formModelEvent.getChangeType() != 7 && formModelEvent.getChangeType() != 10 && formModelEvent.getChangeType() != 16) continue;
                    bl = true;
                    break;
                }
                if (!bl2) {
                    return;
                }
                assert (EventQueue.isDispatchThread());
            }
            this.events = formModelEventArray;
            if (bl) {
                Locale locale = FormDesigner.switchToDesignLocale(FormDesigner.this.getFormModel());
                try {
                    FormLAF.executeWithLookAndFeel(FormDesigner.this.formModel, this);
                }
                finally {
                    if (locale != null) {
                        Locale.setDefault(locale);
                    }
                }
            } else {
                this.run();
            }
        }

        public void run() {
            if (this.events == null) {
                Object object = FormDesigner.this.topDesignComponent == null ? null : FormDesigner.this.replicator.getClonedComponent(FormDesigner.this.topDesignComponent);
                Dimension dimension = object instanceof Component ? ((Component)object).getSize() : null;
                FormDesigner.this.replicator.setTopMetaComponent(FormDesigner.this.topDesignComponent);
                Component component = (Component)FormDesigner.this.replicator.createClone();
                if (component != null) {
                    component.setVisible(true);
                    FormDesigner.this.componentLayer.setTopDesignComponent(component);
                    if (dimension != null) {
                        FormDesigner.this.componentLayer.setDesignerSize(dimension);
                        FormDesigner.this.checkDesignerSize();
                    } else {
                        FormDesigner.this.setupDesignerSize();
                    }
                    if (FormDesigner.this.getLayoutDesigner() != null) {
                        FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FormDesigner.this.updateComponentLayer(false);
                        }
                    });
                }
                return;
            }
            FormModelEvent[] formModelEventArray = this.events;
            this.events = null;
            int n = 0;
            ComponentContainer componentContainer = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < formModelEventArray.length; ++i) {
                Object object;
                FormModelEvent formModelEvent = formModelEventArray[i];
                int n2 = formModelEvent.getChangeType();
                ComponentContainer componentContainer2 = formModelEvent.getContainer();
                if (n2 == 4 || n2 == 5 || n2 == 6) {
                    if (n != 4 && n != 5 && n != 6 || componentContainer != componentContainer2) {
                        FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)componentContainer2);
                        bl = true;
                    }
                } else if (n2 == 7) {
                    if ((componentContainer2 instanceof RADVisualContainer || componentContainer2 instanceof RADMenuComponent) && (n != 7 || componentContainer != componentContainer2)) {
                        FormDesigner.this.replicator.updateAddedComponents(componentContainer2);
                        bl = true;
                    }
                } else if (n2 == 8) {
                    object = formModelEvent.getComponent();
                    if (object instanceof RADVisualComponent && (object == FormDesigner.this.topDesignComponent || ((RADComponent)object).isParentComponent(FormDesigner.this.topDesignComponent))) {
                        FormDesigner.this.resetTopDesignComponent(false);
                        FormDesigner.this.updateWholeDesigner();
                        return;
                    }
                    FormDesigner.this.replicator.removeComponent(formModelEvent.getComponent(), formModelEvent.getContainer());
                    bl = true;
                } else if (n2 == 9) {
                    if (n != 9 || componentContainer != componentContainer2) {
                        FormDesigner.this.replicator.reorderComponents(componentContainer2);
                        bl = true;
                    }
                } else if (n2 == 10) {
                    object = formModelEvent.getComponentProperty();
                    RADComponent rADComponent = formModelEvent.getComponent();
                    FormDesigner.this.replicator.updateComponentProperty((RADProperty)((Object)object));
                    this.updateConnectedProperties((RADProperty)((Object)object), rADComponent);
                    bl = true;
                } else if (n2 == 16) {
                    if (formModelEvent.getSubPropertyName() == null) {
                        FormDesigner.this.replicator.updateBinding(formModelEvent.getNewBinding());
                    }
                    bl = true;
                } else if (n2 == 11 && FormDesigner.PROP_DESIGNER_SIZE.equals(formModelEvent.getPropertyName())) {
                    object = (Dimension)formModelEvent.getNewPropertyValue();
                    if (object != null) {
                        FormDesigner.this.componentLayer.setDesignerSize((Dimension)object);
                        bl2 = false;
                        bl = true;
                    } else {
                        bl2 = true;
                        bl = true;
                    }
                }
                n = n2;
                componentContainer = componentContainer2;
            }
            if (bl) {
                if (bl2) {
                    FormDesigner.this.setupDesignerSize();
                } else {
                    FormDesigner.this.checkDesignerSize();
                }
                LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
                if (layoutDesigner != null && FormDesigner.this.formModel.isCompoundEditInProgress()) {
                    FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                }
                FormDesigner.this.updateComponentLayer(true);
            }
        }

        private void updateConnectedProperties(RADProperty rADProperty, RADComponent rADComponent) {
            for (RADComponent rADComponent2 : FormDesigner.this.formModel.getAllComponents()) {
                RADProperty[] rADPropertyArray = rADComponent2.getKnownBeanProperties();
                for (int i = 0; i < rADPropertyArray.length; ++i) {
                    try {
                        RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue;
                        Object object;
                        if (!rADPropertyArray[i].isChanged() || !((object = rADPropertyArray[i].getValue()) instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) || (rADConnectionDesignValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)object).getRADComponent() == null || rADConnectionDesignValue.getProperty() == null || !rADComponent.getName().equals(rADConnectionDesignValue.getRADComponent().getName()) || !rADProperty.getName().equals(rADConnectionDesignValue.getProperty().getName())) continue;
                        FormDesigner.this.replicator.updateComponentProperty(rADPropertyArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
            }
        }
    }

    private class LayoutMapper
    implements VisualMapper {
        private LayoutMapper() {
        }

        public Rectangle getComponentBounds(String string) {
            Component component = this.getVisualComponent(string, true, false);
            Rectangle rectangle = null;
            if (component != null) {
                rectangle = FormDesigner.this.componentBoundsToTop(component);
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compBounds.put(\"" + string + "\", new Rectangle(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + "));");
            }
            return rectangle;
        }

        public Rectangle getContainerInterior(String string) {
            Component component = this.getVisualComponent(string, true, false);
            if (component == null) {
                return null;
            }
            RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getMetaComponent(string);
            Container container = rADVisualContainer.getContainerDelegate(component);
            Rectangle rectangle = FormDesigner.this.componentBoundsToTop(container);
            Insets insets = container.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  contInterior.put(\"" + string + "\", new Rectangle(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + "));");
            }
            return rectangle;
        }

        public Dimension getComponentMinimumSize(String string) {
            Component component = this.getVisualComponent(string, false, false);
            Dimension dimension = null;
            if (component != null) {
                dimension = component.getMinimumSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compMinSize.put(\"" + string + "\", new Dimension(" + new Double(dimension.getWidth()).intValue() + ", " + new Double(dimension.getHeight()).intValue() + "));");
            }
            return dimension;
        }

        public Dimension getComponentPreferredSize(String string) {
            Component component = this.getVisualComponent(string, false, false);
            Dimension dimension = null;
            if (component != null) {
                dimension = component.getPreferredSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compPrefSize.put(\"" + string + "\", new Dimension(" + new Double(dimension.getWidth()).intValue() + ", " + new Double(dimension.getHeight()).intValue() + "));");
            }
            return dimension;
        }

        public boolean hasExplicitPreferredSize(String string) {
            JComponent jComponent = (JComponent)this.getVisualComponent(string, false, true);
            boolean bl = false;
            if (jComponent != null) {
                bl = jComponent.isPreferredSizeSet();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  hasExplicitPrefSize.put(\"" + string + "\", new Boolean(" + bl + "));");
            }
            return bl;
        }

        public int getBaselinePosition(String string, int n, int n2) {
            int n3 = -1;
            JComponent jComponent = (JComponent)this.getVisualComponent(string, true, true);
            if (jComponent != null && (jComponent instanceof JScrollPane || jComponent.getClass().equals(JPanel.class) || jComponent instanceof JTabbedPane || jComponent instanceof AbstractButton && ((AbstractButton)jComponent).getVerticalTextPosition() != 0 || jComponent instanceof JLabel && ((JLabel)jComponent).getVerticalTextPosition() != 0)) {
                n3 = 0;
            }
            if (n3 == -1) {
                n3 = jComponent != null ? Baseline.getBaseline((JComponent)jComponent, (int)n, (int)n2) : 0;
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                String string2 = string + "-" + n + "-" + n2;
                FormDesigner.this.getLayoutDesigner().testCode.add("  baselinePosition.put(\"" + string2 + "\", new Integer(" + n3 + "));");
            }
            return n3;
        }

        public int getPreferredPadding(String string, String string2, int n, int n2, LayoutConstants.PaddingType paddingType) {
            int n3;
            String string3 = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                string3 = string + "-" + string2 + "-" + n + "-" + n2 + "-" + (paddingType != null ? paddingType.ordinal() : 0);
            }
            JComponent jComponent = (JComponent)this.getVisualComponent(string, true, true);
            JComponent jComponent2 = (JComponent)this.getVisualComponent(string2, true, true);
            if (jComponent == null || jComponent2 == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + string3 + "\", new Integer(10)); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
                }
                return 10;
            }
            assert (n == 0 || n == 1);
            assert (n2 == 0 || n2 == 1);
            int n4 = paddingType == LayoutConstants.PaddingType.INDENT ? 3 : (paddingType == LayoutConstants.PaddingType.RELATED ? 0 : 1);
            int n5 = 0;
            n5 = n == 0 ? (paddingType == LayoutConstants.PaddingType.INDENT ? (n2 == 0 ? 7 : 3) : (n2 == 0 ? 3 : 7)) : (n2 == 0 ? 5 : 1);
            int n6 = n3 = paddingType != LayoutConstants.PaddingType.SEPARATE ? FormLAF.getDesignerLayoutStyle().getPreferredGap(jComponent, jComponent2, n4, n5, null) : 18;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + string3 + "\", new Integer(" + n3 + ")); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
            }
            return n3;
        }

        public int getPreferredPaddingInParent(String string, String string2, int n, int n2) {
            String string3 = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                string3 = string + "-" + string2 + "-" + n + "-" + n2;
            }
            JComponent jComponent = null;
            Container container = (Container)this.getVisualComponent(string, true, false);
            if (container != null) {
                RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getMetaComponent(string);
                container = rADVisualContainer.getContainerDelegate(container);
                jComponent = (JComponent)this.getVisualComponent(string2, true, true);
            }
            if (jComponent == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + string3 + "\", new Integer(10)); // parentId-compId-dimension-compAlignment");
                }
                return 10;
            }
            assert (n == 0 || n == 1);
            assert (n2 == 0 || n2 == 1);
            int n3 = n == 0 ? (n2 == 0 ? 7 : 3) : (n2 == 0 ? 1 : 5);
            int n4 = FormLAF.getDesignerLayoutStyle().getContainerGap(jComponent, n3, container);
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + string3 + "\", new Integer(" + n4 + ")); // parentId-compId-dimension-compAlignment");
            }
            return n4;
        }

        public boolean[] getComponentResizability(String string, boolean[] blArray) {
            blArray[1] = true;
            blArray[0] = true;
            return blArray;
        }

        public void rebuildLayout(String string) {
            FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)this.getMetaComponent(string));
            FormDesigner.this.replicator.getLayoutBuilder(string).doLayout();
        }

        public void setComponentVisibility(String string, boolean bl) {
            Object object = FormDesigner.this.getComponent(string);
            if (object instanceof Component) {
                ((Component)object).setVisible(bl);
            }
        }

        private RADComponent getMetaComponent(String string) {
            RADVisualComponent rADVisualComponent;
            RADComponent rADComponent = FormDesigner.this.formModel.getMetaComponent(string);
            if (rADComponent == null && (rADVisualComponent = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent()) != null && rADVisualComponent.getId().equals(string)) {
                rADComponent = rADVisualComponent;
            }
            return rADComponent;
        }

        private Component getVisualComponent(String string, boolean bl, boolean bl2) {
            Object object;
            Object object2 = FormDesigner.this.getComponent(string);
            if (object2 == null) {
                RADComponent rADComponent;
                object = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent();
                if (object != null && ((RADComponent)object).getId().equals(string)) {
                    object2 = ((RADComponent)object).getBeanInstance();
                }
                if (object2 == null && !bl && (rADComponent = this.getMetaComponent(string)) != null) {
                    object2 = rADComponent.getBeanInstance();
                }
            }
            object = bl2 ? JComponent.class : Component.class;
            return object2 != null && ((Class)object).isAssignableFrom(object2.getClass()) ? (Component)object2 : null;
        }
    }
}

