/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class PersistenceManager
implements LazyDebuggerManagerListener {
    public synchronized Breakpoint[] initBreakpoints() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        Breakpoint[] breakpointArray = (Breakpoint[])properties.getArray("jpda", (Object[])new Breakpoint[0]);
        for (int i = 0; i < breakpointArray.length; ++i) {
            if (breakpointArray[i] instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpointArray[i];
                try {
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(lineBreakpoint.getURL()));
                    if (fileObject == null) {
                        Breakpoint[] breakpointArray2 = new Breakpoint[breakpointArray.length - 1];
                        if (i > 0) {
                            System.arraycopy(breakpointArray, 0, breakpointArray2, 0, i);
                        }
                        if (i < breakpointArray2.length) {
                            System.arraycopy(breakpointArray, i + 1, breakpointArray2, i, breakpointArray2.length - i);
                        }
                        breakpointArray = breakpointArray2;
                        --i;
                        continue;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify((Throwable)malformedURLException);
                }
            }
            breakpointArray[i].addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        return breakpointArray;
    }

    public synchronized Breakpoint[] unloadBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (!(breakpoint instanceof JPDABreakpoint)) continue;
            arrayList.add(breakpoint);
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        return arrayList.toArray(new Breakpoint[0]);
    }

    public void initWatches() {
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint && !((JPDABreakpoint)breakpoint).isHidden()) {
            PersistenceManager.storeBreakpoints();
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint && !((JPDABreakpoint)breakpoint).isHidden()) {
            PersistenceManager.storeBreakpoints();
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof JPDABreakpoint) {
            BreakpointsReader breakpointsReader;
            if ("lineNumber".equals(propertyChangeEvent.getPropertyName()) && (breakpointsReader = PersistenceManager.findBreakpointsReader()) != null) {
                breakpointsReader.storeCachedClassName((JPDABreakpoint)propertyChangeEvent.getSource(), null);
            }
            if ("validity".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            PersistenceManager.storeBreakpoints();
        }
    }

    static BreakpointsReader findBreakpointsReader() {
        BreakpointsReader breakpointsReader = null;
        for (Properties.Reader reader : DebuggerManager.getDebuggerManager().lookup(null, Properties.Reader.class)) {
            String[] stringArray = reader.getSupportedClassNames();
            if (stringArray.length != 1 || !JPDABreakpoint.class.getName().equals(stringArray[0])) continue;
            breakpointsReader = (BreakpointsReader)reader;
            break;
        }
        return breakpointsReader;
    }

    static void storeBreakpoints() {
        Properties.getDefault().getProperties("debugger").getProperties("breakpoints").setArray("jpda", (Object[])PersistenceManager.getBreakpoints());
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    private static Breakpoint[] getBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (int i = 0; i < n; ++i) {
            if (!(breakpointArray[i] instanceof JPDABreakpoint) || ((JPDABreakpoint)breakpointArray[i]).isHidden()) continue;
            arrayList.add(breakpointArray[i]);
        }
        breakpointArray = new Breakpoint[arrayList.size()];
        return arrayList.toArray(breakpointArray);
    }
}

