/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ModificationWatchpointEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.WatchpointEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.WatchpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBreakpointImpl
extends ClassBasedBreakpoint {
    private FieldBreakpoint breakpoint;

    public FieldBreakpointImpl(FieldBreakpoint fieldBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)fieldBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = fieldBreakpoint;
        this.set();
    }

    @Override
    protected void setRequests() {
        boolean bl = (this.breakpoint.getBreakpointType() & 1) != 0;
        try {
            boolean bl2;
            if (bl && !VirtualMachineWrapper.canWatchFieldAccess(this.getVirtualMachine())) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldAccess"));
                return;
            }
            boolean bl3 = bl2 = (this.breakpoint.getBreakpointType() & 2) != 0;
            if (bl2 && !VirtualMachineWrapper.canWatchFieldModification(this.getVirtualMachine())) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldModification"));
                return;
            }
            this.setClassRequests(new String[]{this.breakpoint.getClassName()}, new String[0], 1);
            this.checkLoadedClasses(this.breakpoint.getClassName(), null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    @Override
    protected void classLoaded(List<ReferenceType> list) {
        boolean bl = false;
        for (ReferenceType referenceType : list) {
            try {
                WatchpointRequest watchpointRequest;
                Field field = ReferenceTypeWrapper.fieldByName(referenceType, this.breakpoint.getFieldName());
                if (field == null) continue;
                if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                    watchpointRequest = EventRequestManagerWrapper.createAccessWatchpointRequest(this.getEventRequestManager(), field);
                    this.setFilters(watchpointRequest);
                    this.addEventRequest(watchpointRequest);
                }
                if ((this.breakpoint.getBreakpointType() & 2) != 0) {
                    watchpointRequest = EventRequestManagerWrapper.createModificationWatchpointRequest(this.getEventRequestManager(), field);
                    this.setFilters(watchpointRequest);
                    this.addEventRequest(watchpointRequest);
                }
                bl = true;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return;
            }
        }
        if (bl) {
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        } else {
            Object object;
            try {
                object = ReferenceTypeWrapper.name(list.get(0));
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                object = internalExceptionWrapper.getLocalizedMessage();
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                object = objectCollectedExceptionWrapper.getLocalizedMessage();
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return;
            }
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoField", (Object)object, (Object)this.breakpoint.getFieldName()));
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest eventRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        if (eventRequest instanceof AccessWatchpointRequest) {
            Field field = WatchpointRequestWrapper.field((AccessWatchpointRequest)eventRequest);
            AccessWatchpointRequest accessWatchpointRequest = EventRequestManagerWrapper.createAccessWatchpointRequest(this.getEventRequestManager(), field);
            this.setFilters(accessWatchpointRequest);
            return accessWatchpointRequest;
        }
        if (eventRequest instanceof ModificationWatchpointRequest) {
            Field field = WatchpointRequestWrapper.field((ModificationWatchpointRequest)eventRequest);
            ModificationWatchpointRequest modificationWatchpointRequest = EventRequestManagerWrapper.createModificationWatchpointRequest(this.getEventRequestManager(), field);
            this.setFilters(modificationWatchpointRequest);
            return modificationWatchpointRequest;
        }
        return null;
    }

    private void setFilters(WatchpointRequest watchpointRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        JPDAThread[] jPDAThreadArray;
        JPDAThread[] jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
        if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
            jPDAThreadArray = jPDAThreadArray2;
            int n = jPDAThreadArray.length;
            for (int i = 0; i < n; ++i) {
                JPDAThread jPDAThread = jPDAThreadArray[i];
                WatchpointRequestWrapper.addThreadFilter(watchpointRequest, ((JPDAThreadImpl)jPDAThread).getThreadReference());
            }
        }
        if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
            for (JPDAThread jPDAThread : jPDAThreadArray) {
                WatchpointRequestWrapper.addInstanceFilter(watchpointRequest, (ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
            }
        }
    }

    @Override
    public boolean processCondition(Event event) {
        ThreadReference threadReference;
        block5: {
            try {
                if (event instanceof ModificationWatchpointEvent) {
                    threadReference = LocatableEventWrapper.thread((ModificationWatchpointEvent)event);
                    break block5;
                }
                if (event instanceof AccessWatchpointEvent) {
                    threadReference = LocatableEventWrapper.thread((AccessWatchpointEvent)event);
                    break block5;
                }
                return true;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
        }
        return this.processCondition(event, this.breakpoint.getCondition(), threadReference, null);
    }

    @Override
    public boolean exec(Event event) {
        try {
            if (event instanceof ModificationWatchpointEvent) {
                ModificationWatchpointEvent modificationWatchpointEvent = (ModificationWatchpointEvent)event;
                return this.perform(event, LocatableEventWrapper.thread(modificationWatchpointEvent), LocationWrapper.declaringType(LocatableWrapper.location(modificationWatchpointEvent)), ModificationWatchpointEventWrapper.valueToBe(modificationWatchpointEvent));
            }
            if (event instanceof AccessWatchpointEvent) {
                AccessWatchpointEvent accessWatchpointEvent = (AccessWatchpointEvent)event;
                return this.perform(event, LocatableEventWrapper.thread((WatchpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), WatchpointEventWrapper.valueCurrent(accessWatchpointEvent));
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        return super.exec(event);
    }
}

