/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.List;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ExceptionEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ExceptionRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionBreakpointImpl
extends ClassBasedBreakpoint {
    private ExceptionBreakpoint breakpoint;

    public ExceptionBreakpointImpl(ExceptionBreakpoint exceptionBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)exceptionBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = exceptionBreakpoint;
        this.set();
    }

    @Override
    protected void setRequests() {
        this.setClassRequests(new String[]{this.breakpoint.getExceptionClassName()}, new String[0], 1);
        this.checkLoadedClasses(this.breakpoint.getExceptionClassName(), null);
    }

    @Override
    protected void classLoaded(List<ReferenceType> list) {
        for (ReferenceType referenceType : list) {
            try {
                ExceptionRequest exceptionRequest = EventRequestManagerWrapper.createExceptionRequest(this.getEventRequestManager(), referenceType, (this.breakpoint.getCatchType() & 1) != 0, (this.breakpoint.getCatchType() & 2) != 0);
                this.addFilters(exceptionRequest, this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters());
                this.addEventRequest(exceptionRequest);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
        }
    }

    @Override
    protected ExceptionRequest createEventRequest(EventRequest eventRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        ExceptionRequest exceptionRequest = (ExceptionRequest)eventRequest;
        ExceptionRequest exceptionRequest2 = EventRequestManagerWrapper.createExceptionRequest(this.getEventRequestManager(), ExceptionRequestWrapper.exception(exceptionRequest), ExceptionRequestWrapper.notifyCaught(exceptionRequest), ExceptionRequestWrapper.notifyUncaught(exceptionRequest));
        this.addFilters(exceptionRequest2, this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters());
        return exceptionRequest2;
    }

    private void addFilters(ExceptionRequest exceptionRequest, String[] stringArray, String[] stringArray2) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            ExceptionRequestWrapper.addClassFilter(exceptionRequest, stringArray[n]);
        }
        n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            ExceptionRequestWrapper.addClassExclusionFilter(exceptionRequest, stringArray2[n]);
        }
    }

    @Override
    public boolean processCondition(Event event) {
        if (event instanceof ExceptionEvent) {
            try {
                return this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((ExceptionEvent)event), null);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean exec(Event event) {
        if (event instanceof ExceptionEvent) {
            ExceptionEvent exceptionEvent = (ExceptionEvent)event;
            try {
                return this.perform(event, LocatableEventWrapper.thread(exceptionEvent), LocationWrapper.declaringType(LocatableWrapper.location(exceptionEvent)), ExceptionEventWrapper.exception(exceptionEvent));
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
        }
        return super.exec(event);
    }
}

