/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassPrepareRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassUnloadRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;

public class ClassBreakpointImpl
extends ClassBasedBreakpoint {
    private ClassLoadUnloadBreakpoint breakpoint;

    public ClassBreakpointImpl(ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)classLoadUnloadBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = classLoadUnloadBreakpoint;
        this.set();
    }

    protected void setRequests() {
        this.setClassRequests(this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters(), this.breakpoint.getBreakpointType(), false);
    }

    protected EventRequest createEventRequest(EventRequest eventRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        if (eventRequest instanceof ClassPrepareRequest) {
            int n;
            ClassPrepareRequest classPrepareRequest = EventRequestManagerWrapper.createClassPrepareRequest(this.getEventRequestManager());
            String[] stringArray = this.breakpoint.getClassFilters();
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                ClassPrepareRequestWrapper.addClassFilter(classPrepareRequest, stringArray[n]);
            }
            String[] stringArray2 = this.breakpoint.getClassExclusionFilters();
            n2 = stringArray2.length;
            for (n = 0; n < n2; ++n) {
                ClassPrepareRequestWrapper.addClassExclusionFilter(classPrepareRequest, stringArray2[n]);
            }
            return classPrepareRequest;
        }
        if (eventRequest instanceof ClassUnloadRequest) {
            int n;
            ClassUnloadRequest classUnloadRequest = EventRequestManagerWrapper.createClassUnloadRequest(this.getEventRequestManager());
            String[] stringArray = this.breakpoint.getClassFilters();
            int n3 = stringArray.length;
            for (n = 0; n < n3; ++n) {
                ClassUnloadRequestWrapper.addClassFilter(classUnloadRequest, stringArray[n]);
            }
            String[] stringArray3 = this.breakpoint.getClassExclusionFilters();
            n3 = stringArray3.length;
            for (n = 0; n < n3; ++n) {
                ClassUnloadRequestWrapper.addClassExclusionFilter(classUnloadRequest, stringArray3[n]);
            }
            return classUnloadRequest;
        }
        return null;
    }

    public boolean exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            try {
                ThreadReference threadReference = ClassPrepareEventWrapper.thread((ClassPrepareEvent)event);
                ReferenceType referenceType = ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event);
                try {
                    return this.perform(event, threadReference, referenceType, ReferenceTypeWrapper.classObject(referenceType));
                }
                catch (UnsupportedOperationExceptionWrapper unsupportedOperationExceptionWrapper) {
                    return this.perform(event, threadReference, referenceType, null);
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                return false;
            }
        }
        return this.perform(event, null, null, null);
    }

    public boolean processCondition(Event event) {
        return true;
    }
}

