/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Accessible;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Mirror;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDAStepImpl
extends JPDAStep
implements Executor {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private static final String INIT = "<init>";
    private EditorContext.Operation[] currentOperations;
    private EditorContext.Operation lastOperation;
    private MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private Set<BreakpointRequest> operationBreakpoints;
    private StepRequest boundaryStepRequest;
    private Set<EventRequest> requestsToCancel = new HashSet<EventRequest>();
    private Properties p;
    private Session session;

    public JPDAStepImpl(JPDADebugger jPDADebugger, Session session, int n, int n2) {
        super(jPDADebugger, n, n2);
        this.session = session;
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStep(JPDAThread jPDAThread) {
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger;
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)jPDAThread;
        VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        SourcePath sourcePath = ((JPDADebuggerImpl)this.debugger).getEngineContext();
        boolean[] blArray = new boolean[]{false};
        jPDAThreadImpl.accessLock.readLock().lock();
        try {
            ((JPDAThreadImpl)jPDAThread).waitUntilMethodInvokeDone();
            EventRequestManager eventRequestManager = VirtualMachineWrapper.eventRequestManager(virtualMachine);
            List<StepRequest> list = EventRequestManagerWrapper.stepRequests(eventRequestManager);
            EventRequestManagerWrapper.deleteEventRequests(eventRequestManager, list);
            for (StepRequest stepRequest : list) {
                jPDADebuggerImpl.getOperator().unregister(stepRequest);
            }
            int n = this.getSize();
            boolean bl = false;
            logger.log(Level.FINE, "Step " + (n == 10 ? "operation" : "line") + " " + (this.getDepth() == 1 ? "into" : (this.getDepth() == 2 ? "over" : "out")) + " in thread " + jPDAThread.getName());
            if (n == 10 && !(bl = this.addOperationStep(jPDAThreadImpl, false, sourcePath, blArray))) {
                n = -2;
                logger.log(Level.FINE, "Operation step changed to line step");
            }
            if (!bl) {
                StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), jPDAThreadImpl.getThreadReference(), n, this.getDepth());
                String[] stringArray = jPDADebuggerImpl.getSmartSteppingFilter().getExclusionPatterns();
                for (int i = 0; i < stringArray.length; ++i) {
                    StepRequestWrapper.addClassExclusionFilter(stepRequest, stringArray[i]);
                    logger.finer("   add pattern: " + stringArray[i]);
                }
                jPDADebuggerImpl.getOperator().register(stepRequest, this);
                EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
                try {
                    EventRequestWrapper.enable(stepRequest);
                    jPDAThreadImpl.setInStep(true, stepRequest);
                    this.requestsToCancel.add(stepRequest);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    jPDADebuggerImpl.getOperator().unregister(stepRequest);
                    stepRequest = null;
                }
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        finally {
            jPDAThreadImpl.accessLock.readLock().unlock();
        }
        if (blArray[0]) {
            jPDADebuggerImpl.setStoppedStateNoContinue(jPDAThreadImpl.getThreadReference());
        }
    }

    private boolean addOperationStep(JPDAThreadImpl jPDAThreadImpl, boolean bl, SourcePath sourcePath, boolean[] blArray) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        EditorContext.Operation operation;
        int n;
        MethodBreakpoint methodBreakpoint;
        Object object;
        VirtualMachine virtualMachine;
        EditorContext.Operation operation2;
        StackFrame stackFrame;
        ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
        try {
            stackFrame = ThreadReferenceWrapper.frame(threadReference, 0);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        Location location = LocatableWrapper.location(stackFrame);
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string = session == null ? null : session.getCurrentLanguage();
        String string2 = sourcePath.getURL(location, string);
        ExpressionPool expressionPool = ((JPDADebuggerImpl)this.debugger).getExpressionPool();
        ExpressionPool.Expression expression = expressionPool.getExpressionAt(location, string2);
        if (expression == null) {
            return false;
        }
        EditorContext.Operation[] operationArray = expression.getOperations();
        int n2 = -1;
        int n3 = (int)LocationWrapper.codeIndex(location);
        if (n3 <= operationArray[0].getBytecodeIndex()) {
            if (!bl) {
                jPDAThreadImpl.clearLastOperations();
            }
            if (!operationArray[0].equals((Object)jPDAThreadImpl.getCurrentOperation()) && (n2 = expression.findNextOperationIndex(n3 - 1)) >= 0 && operationArray[n2].getBytecodeIndex() == n3) {
                jPDAThreadImpl.setCurrentOperation(operationArray[n2]);
                if (bl) {
                    return false;
                }
                if (!this.getHidden()) {
                    blArray[0] = true;
                }
                return true;
            }
        }
        if ((operation2 = jPDAThreadImpl.getCurrentOperation()) != null) {
            virtualMachine = null;
            object = jPDAThreadImpl.getLastOperations();
            if (object != null && object.size() > 0) {
                virtualMachine = object.get(object.size() - 1);
            }
            if (virtualMachine == operation2) {
                methodBreakpoint = operationArray;
                n = ((EditorContext.Operation[])methodBreakpoint).length;
                for (int i = 0; i < n; ++i) {
                    operation = methodBreakpoint[i];
                    if (operation.getBytecodeIndex() != n3) continue;
                    jPDAThreadImpl.setCurrentOperation(operation);
                    if (!this.getHidden()) {
                        blArray[0] = true;
                    }
                    return true;
                }
            }
        }
        this.lastOperation = operation2;
        virtualMachine = MirrorWrapper.virtualMachine(location);
        if (this.lastOperation != null && (object = this.lastOperation.getMethodName()) != null && !INIT.equals(object) && MethodBreakpointImpl.canGetMethodReturnValues(virtualMachine)) {
            methodBreakpoint = MethodBreakpoint.create((String)this.lastOperation.getMethodClassType(), (String)object);
            methodBreakpoint.setClassFilters(JPDAStepImpl.createClassFilters(virtualMachine, this.lastOperation.getMethodClassType(), (String)object));
            methodBreakpoint.setThreadFilters(this.debugger, new JPDAThread[]{jPDAThreadImpl});
            methodBreakpoint.setBreakpointType(2);
            methodBreakpoint.setHidden(true);
            methodBreakpoint.setSuspend(0);
            this.lastMethodExitBreakpointListener = new MethodExitBreakpointListener(methodBreakpoint);
            methodBreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
            try {
                Method method = JPDABreakpoint.class.getDeclaredMethod("setSession", JPDADebugger.class);
                method.setAccessible(true);
                method.invoke((Object)methodBreakpoint, this.debugger);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)methodBreakpoint);
        }
        jPDAThreadImpl.holdLastOperations(true);
        if (n2 < 0) {
            object = expression.findNextOperationLocations(n3);
        } else {
            methodBreakpoint = expression.getLocations();
            object = new ExpressionPool.OperationLocation[]{new ExpressionPool.OperationLocation(operationArray[n2], (Location)methodBreakpoint[n2], n2)};
        }
        boolean bl2 = false;
        if (object != null) {
            this.operationBreakpoints = new HashSet<BreakpointRequest>();
            for (n = 0; n < ((ExpressionPool.OperationLocation[])object).length; ++n) {
                Location location2 = object[n].getLocation();
                if (object[n].getIndex() < 0) {
                    bl2 = true;
                    operation = new EditorContext.Operation[operationArray.length + 1];
                    System.arraycopy(operationArray, 0, operation, 0, operationArray.length);
                    operation[operationArray.length] = object[n].getOperation();
                    operationArray = operation;
                }
                operation = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), location2);
                this.operationBreakpoints.add((BreakpointRequest)operation);
                ((JPDADebuggerImpl)this.debugger).getOperator().register((EventRequest)operation, this);
                EventRequestWrapper.setSuspendPolicy((EventRequest)operation, this.debugger.getSuspend());
                BreakpointRequestWrapper.addThreadFilter((BreakpointRequest)operation, threadReference);
                EventRequestWrapper.putProperty((EventRequest)operation, "thread", threadReference);
                EventRequestWrapper.enable((EventRequest)operation);
                jPDAThreadImpl.setInStep(true, (EventRequest)operation);
                this.requestsToCancel.add((EventRequest)operation);
            }
        } else if (bl) {
            return false;
        }
        this.boundaryStepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), threadReference, -2, 2);
        if (bl2) {
            EventRequestWrapper.addCountFilter(this.boundaryStepRequest, 2);
        } else {
            EventRequestWrapper.addCountFilter(this.boundaryStepRequest, 1);
        }
        ((JPDADebuggerImpl)this.debugger).getOperator().register(this.boundaryStepRequest, this);
        EventRequestWrapper.setSuspendPolicy(this.boundaryStepRequest, this.debugger.getSuspend());
        try {
            EventRequestWrapper.enable(this.boundaryStepRequest);
            this.requestsToCancel.add(this.boundaryStepRequest);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            ((JPDADebuggerImpl)this.debugger).getOperator().unregister(this.boundaryStepRequest);
            this.boundaryStepRequest = null;
            return false;
        }
        this.currentOperations = operationArray;
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exec(Event var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removed(EventRequest eventRequest) {
        JPDADebuggerImpl jPDADebuggerImpl;
        VirtualMachine virtualMachine;
        try {
            this.stepDone(eventRequest);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return;
        }
        if (this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
        if ((virtualMachine = (jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger).getVirtualMachine()) == null) {
            return;
        }
        try {
            EventRequestManager eventRequestManager = VirtualMachineWrapper.eventRequestManager(virtualMachine);
            if (this.operationBreakpoints != null) {
                for (BreakpointRequest breakpointRequest : this.operationBreakpoints) {
                    EventRequestManagerWrapper.deleteEventRequest(eventRequestManager, breakpointRequest);
                    jPDADebuggerImpl.getOperator().unregister(breakpointRequest);
                }
                this.operationBreakpoints = null;
            }
            if (this.boundaryStepRequest != null) {
                EventRequestManagerWrapper.deleteEventRequest(eventRequestManager, this.boundaryStepRequest);
                jPDADebuggerImpl.getOperator().unregister(this.boundaryStepRequest);
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
    }

    private void stepDone(EventRequest eventRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        JPDAThreadImpl jPDAThreadImpl;
        if (eventRequest instanceof StepRequest) {
            StepRequest stepRequest = (StepRequest)eventRequest;
            jPDAThreadImpl = ((JPDADebuggerImpl)this.debugger).getThread(StepRequestWrapper.thread(stepRequest));
        } else {
            ThreadReference threadReference = (ThreadReference)EventRequestWrapper.getProperty(eventRequest, "thread");
            jPDAThreadImpl = threadReference != null ? ((JPDADebuggerImpl)this.debugger).getThread(threadReference) : null;
        }
        if (jPDAThreadImpl != null) {
            jPDAThreadImpl.setInStep(false, null);
        }
    }

    private static String[] createClassFilters(VirtualMachine virtualMachine, String string, String string2) throws VMDisconnectedExceptionWrapper {
        return JPDAStepImpl.createClassFilters(virtualMachine, string, string2, new ArrayList<String>()).toArray(new String[0]);
    }

    private static List<String> createClassFilters(VirtualMachine virtualMachine, String string, String string2, List<String> list) throws VMDisconnectedExceptionWrapper {
        List<ReferenceType> list2 = VirtualMachineWrapper.classesByName0(virtualMachine, string);
        for (ReferenceType referenceType : list2) {
            try {
                Accessible accessible;
                List<com.sun.jdi.Method> list3;
                try {
                    list3 = ReferenceTypeWrapper.methodsByName0(referenceType, string2);
                }
                catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                    continue;
                }
                boolean bl = list3.isEmpty();
                Object object = list3.iterator();
                while (object.hasNext()) {
                    accessible = object.next();
                    if (!list.contains(ReferenceTypeWrapper.name(referenceType))) {
                        list.add(ReferenceTypeWrapper.name(referenceType));
                    }
                    if (TypeComponentWrapper.isStatic(accessible)) continue;
                    bl = true;
                }
                if (!bl || !(referenceType instanceof ClassType) || (accessible = ClassTypeWrapper.superclass((ClassType)(object = (ClassType)referenceType))) == null) continue;
                JPDAStepImpl.createClassFilters(virtualMachine, ReferenceTypeWrapper.name((ReferenceType)accessible), string2, list);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldNotStopHere(StepEvent stepEvent) {
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n;
            Mirror mirror;
            ThreadReference threadReference = LocatableEventWrapper.thread(stepEvent);
            JPDAThreadImpl jPDAThreadImpl = jPDADebuggerImpl.getThread(threadReference);
            jPDAThreadImpl.accessLock.readLock().lock();
            try {
                boolean bl4;
                if (!ThreadReferenceWrapper.isSuspended(threadReference)) {
                    boolean bl5 = false;
                    return bl5;
                }
                mirror = LocationWrapper.method(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
                n = 0;
                int n2 = this.getDepth();
                bl3 = this.p.getBoolean("UseStepFilters", true);
                bl2 = bl3 && this.p.getBoolean("FilterSyntheticMethods", true);
                bl = bl3 && this.p.getBoolean("FilterStaticInitializers", false);
                boolean bl6 = bl4 = bl3 && this.p.getBoolean("FilterConstructors", false);
                if (bl2 && TypeComponentWrapper.isSynthetic(mirror)) {
                    n = 1;
                }
                if (bl && MethodWrapper.isStaticInitializer(mirror) || bl4 && MethodWrapper.isConstructor(mirror)) {
                    n = 1;
                    n2 = 3;
                }
                if (n != 0) {
                    VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
                    if (virtualMachine == null) {
                        boolean bl7 = false;
                        return bl7;
                    }
                    StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), threadReference, -2, n2);
                    EventRequestWrapper.addCountFilter(stepRequest, 1);
                    String[] stringArray = jPDADebuggerImpl.getSmartSteppingFilter().getExclusionPatterns();
                    for (int i = 0; i < stringArray.length; ++i) {
                        StepRequestWrapper.addClassExclusionFilter(stepRequest, stringArray[i]);
                    }
                    jPDADebuggerImpl.getOperator().register(stepRequest, this);
                    EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
                    try {
                        EventRequestWrapper.enable(stepRequest);
                        this.requestsToCancel.add(stepRequest);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        jPDADebuggerImpl.getOperator().unregister(stepRequest);
                    }
                    boolean bl8 = true;
                    return bl8;
                }
                if (jPDADebuggerImpl.stopHere(jPDAThreadImpl)) {
                    return false;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ErrorManager.getDefault().notify((Throwable)incompatibleThreadStateException);
                n = 0;
                return n != 0;
            }
            catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                ErrorManager.getDefault().notify((Throwable)invalidStackFrameExceptionWrapper);
                n = 0;
                return n != 0;
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                n = 0;
                return n != 0;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                n = 0;
                return n != 0;
            }
            mirror = jPDADebuggerImpl.getVirtualMachine();
            if (mirror == null) {
                return 0 != 0;
            }
            Map map = (Map)this.session.lookupFirst(null, Map.class);
            bl3 = map != null && map.containsKey("SS_ACTION_STEPOUT");
            bl2 = this.p.getBoolean("UseStepFilters", true);
            bl = bl2 && this.p.getBoolean("StepThroughFilters", false);
            n = !bl || bl3 ? 3 : ((StepRequest)stepEvent.request()).depth();
            StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager((VirtualMachine)mirror), threadReference, -2, n);
            if (logger.isLoggable(Level.FINE)) {
                try {
                    logger.fine("Can not stop at " + ThreadReferenceWrapper.frame(threadReference, 0) + ", smart-stepping. Submitting step = " + stepRequest + "; depth = " + n);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", internalExceptionWrapper);
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", vMDisconnectedExceptionWrapper);
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", objectCollectedExceptionWrapper);
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", illegalThreadStateExceptionWrapper);
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", incompatibleThreadStateException);
                }
            }
            String[] stringArray = jPDADebuggerImpl.getSmartSteppingFilter().getExclusionPatterns();
            for (int i = 0; i < stringArray.length; ++i) {
                StepRequestWrapper.addClassExclusionFilter(stepRequest, stringArray[i]);
                logger.finer("   add pattern: " + stringArray[i]);
            }
            jPDADebuggerImpl.getOperator().register(stepRequest, this);
            EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
            try {
                EventRequestWrapper.enable(stepRequest);
                this.requestsToCancel.add(stepRequest);
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                jPDADebuggerImpl.getOperator().unregister(stepRequest);
                return true;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                jPDADebuggerImpl.getOperator().unregister(stepRequest);
                return true;
            }
            finally {
                jPDAThreadImpl.accessLock.readLock().unlock();
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
    }

    public void cancel() {
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger;
        VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        try {
            EventRequestManager eventRequestManager = VirtualMachineWrapper.eventRequestManager(virtualMachine);
            for (EventRequest eventRequest : this.requestsToCancel) {
                EventRequestManagerWrapper.deleteEventRequest(eventRequestManager, eventRequest);
                jPDADebuggerImpl.getOperator().unregister(eventRequest);
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
    }

    public static final class MethodExitBreakpointListener
    implements JPDABreakpointListener {
        private MethodBreakpoint mb;
        private Variable returnValue;

        public MethodExitBreakpointListener(MethodBreakpoint methodBreakpoint) {
            this.mb = methodBreakpoint;
        }

        public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
            this.returnValue = jPDABreakpointEvent.getVariable();
        }

        public Variable getReturnValue() {
            return this.returnValue;
        }

        public void destroy() {
            this.mb.removeJPDABreakpointListener((JPDABreakpointListener)this);
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.mb);
        }
    }
}

