/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadlockDetectorImpl
extends DeadlockDetector
implements PropertyChangeListener {
    private final Set<JPDAThread> suspendedThreads = new WeakSet();
    private final RequestProcessor rp = new RequestProcessor("Deadlock Detector", 1);
    private final Set<RequestProcessor.Task> unfinishedTasks = new HashSet<RequestProcessor.Task>();
    private Map<Long, Node> monitorToNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeadlockDetectorImpl(JPDADebugger jPDADebugger) {
        jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
        List list = jPDADebugger.getThreadsCollector().getAllThreads();
        for (JPDAThread jPDAThread : list) {
            ((Customizer)jPDAThread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jPDAThread));
            if (!jPDAThread.isSuspended()) continue;
            Set<JPDAThread> set = this.suspendedThreads;
            synchronized (set) {
                this.suspendedThreads.add(jPDAThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("threadStarted".equals(string)) {
            JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getNewValue();
            ((Customizer)jPDAThread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jPDAThread));
        } else if ("suspended".equals(string)) {
            JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getSource();
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                final RequestProcessor.Task[] taskArray = this.suspendedThreads;
                synchronized (this.suspendedThreads) {
                    this.suspendedThreads.add(jPDAThread);
                    final HashSet<JPDAThread> hashSet = new HashSet<JPDAThread>(this.suspendedThreads);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    taskArray = new RequestProcessor.Task[]{null};
                    Set<RequestProcessor.Task> set = this.unfinishedTasks;
                    synchronized (set) {
                        RequestProcessor.Task task = this.rp.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Set set = DeadlockDetectorImpl.this.findDeadlockedThreads(hashSet);
                                if (set != null) {
                                    DeadlockDetectorImpl.this.setDeadlocks(set);
                                }
                                Set set2 = DeadlockDetectorImpl.this.unfinishedTasks;
                                synchronized (set2) {
                                    DeadlockDetectorImpl.this.unfinishedTasks.remove(taskArray[0]);
                                }
                            }
                        });
                        this.unfinishedTasks.add(task);
                        taskArray[0] = task;
                    }
                }
            }
            Set<JPDAThread> set = this.suspendedThreads;
            synchronized (set) {
                this.suspendedThreads.remove(jPDAThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForUnfinishedTasks(long l) throws InterruptedException {
        HashSet<RequestProcessor.Task> hashSet = new HashSet<RequestProcessor.Task>();
        RequestProcessor.Task task = this.unfinishedTasks;
        synchronized (task) {
            hashSet.addAll(this.unfinishedTasks);
        }
        while (!hashSet.isEmpty()) {
            task = (RequestProcessor.Task)hashSet.iterator().next();
            task.waitFinished(l);
            hashSet.remove(task);
        }
    }

    private Set<DeadlockDetector.Deadlock> findDeadlockedThreads(Collection<JPDAThread> collection) {
        HashSet<DeadlockDetector.Deadlock> hashSet;
        this.buildGraph(collection);
        HashSet<Node> hashSet2 = new HashSet<Node>();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Map.Entry<Long, Node> object2 : this.monitorToNode.entrySet()) {
            Node node = object2.getValue();
            if (!node.isSimple()) continue;
            hashSet2.add(node);
            linkedList.add(node);
        }
        while (linkedList.size() > 0) {
            hashSet = (Node)linkedList.removeFirst();
            hashSet2.remove(hashSet);
            if (((Node)((Object)hashSet)).outgoing != null) {
                ((Node)((Object)hashSet)).outgoing.removeIncomming((Node)((Object)hashSet));
                if (((Node)((Object)hashSet)).outgoing.isSimple() && !hashSet2.contains(((Node)((Object)hashSet)).outgoing)) {
                    hashSet2.add(((Node)((Object)hashSet)).outgoing);
                    linkedList.add(((Node)((Object)hashSet)).outgoing);
                }
            }
            for (Node node : ((Node)((Object)hashSet)).incomming) {
                node.setOutgoing(null);
                if (!node.isSimple() || hashSet2.contains(node)) continue;
                hashSet2.add(node);
                linkedList.add(node);
            }
            this.monitorToNode.remove(((Node)((Object)hashSet)).ownedMonitor.getUniqueID());
        }
        hashSet = null;
        if (!this.monitorToNode.isEmpty()) {
            hashSet = new HashSet<DeadlockDetector.Deadlock>();
            HashSet<Node> hashSet3 = new HashSet<Node>(this.monitorToNode.values());
            while (!hashSet3.isEmpty()) {
                ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>(hashSet3.size());
                Node node = (Node)hashSet3.iterator().next();
                hashSet3.remove(node);
                do {
                    arrayList.add(node.thread);
                } while (hashSet3.remove(node = node.outgoing));
                hashSet.add(this.createDeadlock(arrayList));
            }
        }
        return hashSet;
    }

    private void buildGraph(Collection<JPDAThread> collection) {
        this.monitorToNode = new HashMap<Long, Node>();
        for (JPDAThread jPDAThread : collection) {
            ObjectVariable objectVariable = jPDAThread.getContendedMonitor();
            ObjectVariable[] objectVariableArray = jPDAThread.getOwnedMonitors();
            if (objectVariable == null || objectVariableArray.length == 0) continue;
            Node node = this.monitorToNode.get(objectVariable.getUniqueID());
            if (node == null) {
                node = new Node(null, objectVariable);
                this.monitorToNode.put(objectVariable.getUniqueID(), node);
            }
            for (int i = 0; i < objectVariableArray.length; ++i) {
                Node node2 = this.monitorToNode.get(objectVariableArray[i].getUniqueID());
                if (node2 == null) {
                    node2 = new Node(jPDAThread, objectVariableArray[i]);
                    this.monitorToNode.put(objectVariableArray[i].getUniqueID(), node2);
                } else {
                    if (node2.thread != null) continue;
                    node2.thread = jPDAThread;
                }
                node2.setOutgoing(node);
                node.addIncomming(node2);
            }
        }
    }

    private static class Node {
        JPDAThread thread;
        ObjectVariable ownedMonitor;
        Collection<Node> incomming = new HashSet<Node>();
        Node outgoing = null;

        Node(JPDAThread jPDAThread, ObjectVariable objectVariable) {
            this.thread = jPDAThread;
            this.ownedMonitor = objectVariable;
        }

        void setOutgoing(Node node) {
            this.outgoing = node;
        }

        void addIncomming(Node node) {
            this.incomming.add(node);
        }

        void removeIncomming(Node node) {
            this.incomming.remove(node);
        }

        boolean isSimple() {
            return this.outgoing == null || this.incomming.size() == 0;
        }
    }
}

