/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmIncludeHyperlinkProvider;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ThisReferenceImpl;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferencesSupport {
    private static ReferencesSupport instance = new ReferencesSupport();
    private static Reference<FileToDoc> lastCsmFile = null;
    private final CsmProgressListener progressListener;
    private static final int MAX_CACHE_SIZE = 10;
    private final Object cacheLock = new CacheLock();
    private Map<CsmFile, Map<Integer, CsmObject>> cache = new HashMap<CsmFile, Map<Integer, CsmObject>>();
    private static CsmObject FAKE = new CsmObject(){

        public String toString() {
            return "FAKE REFERENCE";
        }
    };

    private ReferencesSupport() {
        this.progressListener = new CsmProgressAdapter(){

            public void fileParsingFinished(CsmFile csmFile) {
                ReferencesSupport.this.clearFileReferences(csmFile);
            }

            public void projectParsingFinished(CsmProject csmProject) {
                ReferencesSupport.this.clearFileReferences(null);
            }
        };
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    public static ReferencesSupport instance() {
        return instance;
    }

    public static int getDocumentOffset(BaseDocument baseDocument, int n, int n2) {
        return Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1)) + (n2 - 1);
    }

    public static BaseDocument getBaseDocument(String string) throws DataObjectNotFoundException, IOException {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            throw new IllegalStateException("Given file (\"" + dataObject.getName() + "\") does not have EditorCookie.");
        }
        StyledDocument styledDocument = null;
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (UserQuestionException userQuestionException) {
            userQuestionException.confirmed();
            styledDocument = editorCookie.openDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    public CsmObject findReferencedObject(CsmFile csmFile, BaseDocument baseDocument, int n) {
        return this.findReferencedObject(csmFile, baseDocument, n, null, null);
    }

    static CsmObject findOwnerObject(CsmFile csmFile, BaseDocument baseDocument, int n, TokenItem<CppTokenId> tokenItem) {
        CsmObject csmObject = CsmOffsetResolver.findObject(csmFile, n);
        return csmObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmObject findReferencedObject(CsmFile csmFile, BaseDocument baseDocument, int n, TokenItem<CppTokenId> tokenItem, FileReferencesContext fileReferencesContext) {
        long l = CsmFileInfoQuery.getDefault().getFileVersion(csmFile);
        CsmInclude csmInclude = null;
        Object var9_8 = null;
        if (tokenItem == null) {
            baseDocument.readLock();
            try {
                tokenItem = CndTokenUtilities.getTokenCheckPrev((Document)baseDocument, (int)n);
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        if (tokenItem != null) {
            switch ((CppTokenId)tokenItem.id()) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: {
                    csmInclude = ReferencesSupport.findInclude(csmFile, n);
                    break;
                }
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    csmInclude = ReferencesSupport.findInclude(csmFile, n);
                    if (csmInclude == null) break;
                    csmInclude = csmInclude.getIncludeFile();
                }
            }
        }
        if (csmInclude == null) {
            int n2 = tokenItem.offset();
            if (n2 < 0) {
                n2 = n;
            }
            if ((csmInclude = this.getReferencedObject(csmFile, n2, l)) == null) {
                csmInclude = ReferencesSupport.findDeclaration(csmFile, (Document)baseDocument, (TokenItem<CppTokenId>)tokenItem, n2, fileReferencesContext);
                if (csmInclude == null) {
                    this.putReferencedObject(csmFile, n2, FAKE, l);
                } else {
                    this.putReferencedObject(csmFile, n2, (CsmObject)csmInclude, l);
                }
            } else if (csmInclude == FAKE) {
                csmInclude = null;
            }
        }
        return csmInclude;
    }

    public static CsmInclude findInclude(CsmFile csmFile, int n) {
        assert (csmFile != null);
        return (CsmInclude)CsmOffsetUtilities.findObject(csmFile.getIncludes(), null, n);
    }

    public static CsmObject findDeclaration(CsmFile csmFile, Document document, TokenItem<CppTokenId> tokenItem, int n) {
        return ReferencesSupport.findDeclaration(csmFile, document, tokenItem, n, null);
    }

    private static CsmObject findDeclaration(CsmFile csmFile, Document document, TokenItem<CppTokenId> tokenItem, int n, FileReferencesContext fileReferencesContext) {
        Object object;
        CsmObject csmObject = null;
        List list = CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
        csmObject = ReferencesSupport.findMacro(list, n);
        if (csmObject != null) {
            return csmObject;
        }
        CsmObject csmObject2 = CsmOffsetResolver.findObject(csmFile, n, fileReferencesContext);
        if (CsmKindUtilities.isEnumerator((Object)csmObject2)) {
            object = (CsmEnumerator)csmObject2;
            if (object.getExplicitValue() == null) {
                csmObject = object;
            }
        } else if (CsmKindUtilities.isLabel((CsmObject)csmObject2)) {
            csmObject = csmObject2;
        } else if (CsmKindUtilities.isGotoStatement((CsmObject)csmObject2)) {
            Collection collection;
            object = (CsmGotoStatement)csmObject2;
            CsmScope csmScope = object.getScope();
            while (csmScope != null && CsmKindUtilities.isScopeElement((CsmObject)csmScope) && !CsmKindUtilities.isFunctionDefinition((CsmObject)csmScope)) {
                csmScope = ((CsmScopeElement)csmScope).getScope();
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmScope) && !(collection = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)csmScope, object.getLabel(), EnumSet.of(CsmLabelResolver.LabelKind.Definiton))).isEmpty()) {
                csmObject = ((CsmReference)collection.iterator().next()).getReferencedObject();
            }
            if (csmObject == null) {
                return null;
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)csmObject2) || CsmKindUtilities.isTypedef((CsmObject)csmObject2)) {
            boolean bl;
            object = CsmKindUtilities.isVariable((CsmObject)csmObject2) ? ((CsmVariable)csmObject2).getType() : ((CsmTypedef)csmObject2).getType();
            CsmParameter csmParameter = null;
            do {
                CsmParameter csmParameter2;
                bl = false;
                if (CsmOffsetUtilities.isInObject((CsmObject)object, n)) {
                    csmParameter = null;
                    continue;
                }
                if (!CsmKindUtilities.isFunctionPointerType((CsmObject)object) || (csmParameter2 = (CsmParameter)CsmOffsetUtilities.findObject(((CsmFunctionPointerType)object).getParameters(), null, n)) == null) continue;
                csmParameter = csmParameter2;
                object = csmParameter2.getType();
                bl = true;
            } while (bl);
            csmObject = csmParameter;
        }
        if (csmObject == null) {
            object = null;
            try {
                if (document instanceof BaseDocument) {
                    object = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)((BaseDocument)document), (int)n);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (object != null && ((CsmEnumerator)object).length != 3) {
                csmObject = ReferencesSupport.findDeclaration(csmFile, document, tokenItem, n, CsmCompletionQuery.QueryScope.SMART_QUERY, fileReferencesContext);
            }
        }
        csmObject = csmObject != null ? csmObject : ReferencesSupport.findDeclaration(csmFile, document, tokenItem, n, CsmCompletionQuery.QueryScope.GLOBAL_QUERY, fileReferencesContext);
        return csmObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CsmObject findDeclaration(CsmFile csmFile, Document document, TokenItem<CppTokenId> tokenItem, int n, CsmCompletionQuery.QueryScope queryScope, FileReferencesContext fileReferencesContext) {
        Object object;
        assert (csmFile != null);
        if (tokenItem == null && document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
            try {
                tokenItem = CndTokenUtilities.getTokenCheckPrev((Document)document, (int)n);
            }
            finally {
                ((AbstractDocument)document).readUnlock();
            }
        }
        if (tokenItem == null) {
            return null;
        }
        Object object2 = null;
        if (tokenItem.id() == CppTokenId.OPERATOR) {
            object = CsmOffsetResolver.findObject(csmFile, n, fileReferencesContext);
            object2 = object;
            if (CsmKindUtilities.isFunction((CsmObject)object2)) {
                CsmFunction csmFunction = null;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)object2)) {
                    csmFunction = ((CsmFunctionDefinition)object2).getDeclaration();
                } else if (CsmKindUtilities.isFriendMethod((CsmObject)object2)) {
                    csmFunction = ((CsmFriendFunction)object2).getReferencedFunction();
                }
                if (csmFunction != null) {
                    object2 = csmFunction;
                }
            } else {
                object2 = null;
            }
        }
        if (object2 == null && !(object = CompletionUtilities.findItemsReferencedAtCaretPos(null, document, CsmCompletionProvider.getCompletionQuery(csmFile, queryScope, fileReferencesContext), n)).isEmpty()) {
            object2 = (CsmObject)object.iterator().next();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n) {
        ReferenceImpl referenceImpl = null;
        baseDocument.readLock();
        try {
            TokenItem tokenItem = CndTokenUtilities.getTokenCheckPrev((Document)baseDocument, (int)n);
            if (ReferencesSupport.isSupportedToken((TokenItem<CppTokenId>)tokenItem)) {
                referenceImpl = ReferencesSupport.createReferenceImpl(csmFile, baseDocument, n, (TokenItem<CppTokenId>)tokenItem, null);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return referenceImpl;
    }

    public static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n, TokenItem<CppTokenId> tokenItem, CsmReferenceKind csmReferenceKind) {
        assert (tokenItem != null);
        assert (csmFile != null) : "null file for document " + baseDocument + " on offset " + n + " " + tokenItem;
        if (tokenItem.id() == CppTokenId.THIS) {
            return new ThisReferenceImpl(csmFile, baseDocument, n, tokenItem, csmReferenceKind);
        }
        return new ReferenceImpl(csmFile, baseDocument, n, tokenItem, csmReferenceKind);
    }

    private static boolean isSupportedToken(TokenItem<CppTokenId> tokenItem) {
        return tokenItem != null && (CsmIncludeHyperlinkProvider.isSupportedToken(tokenItem, HyperlinkType.GO_TO_DECLARATION) || CsmHyperlinkProvider.isSupportedToken(tokenItem, HyperlinkType.GO_TO_DECLARATION));
    }

    public static CsmReferenceResolver.Scope fastCheckScope(CsmReference csmReference) {
        Parameters.notNull((CharSequence)"ref", (Object)csmReference);
        CsmObject csmObject = ReferencesSupport.getTargetIfPossible(csmReference);
        if (csmObject == null) {
            int n = ReferencesSupport.getRefOffset(csmReference);
            BaseDocument baseDocument = ReferencesSupport.getRefDocument(csmReference);
            if (baseDocument != null) {
                TokenItem<CppTokenId> tokenItem = ReferencesSupport.getRefTokenIfPossible(csmReference);
                csmObject = ReferencesSupport.findDeclaration(csmReference.getContainingFile(), (Document)baseDocument, tokenItem, n, CsmCompletionQuery.QueryScope.LOCAL_QUERY, null);
                ReferencesSupport.setResolvedInfo(csmReference, csmObject);
            }
        }
        return ReferencesSupport.getTargetScope(csmObject);
    }

    private static CsmReferenceResolver.Scope getTargetScope(CsmObject csmObject) {
        if (csmObject == null) {
            return CsmReferenceResolver.Scope.UNKNOWN;
        }
        if (ReferencesSupport.isLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.LOCAL;
        }
        if (ReferencesSupport.isFileLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.FILE_LOCAL;
        }
        return CsmReferenceResolver.Scope.GLOBAL;
    }

    private static CsmObject getTargetIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getTarget();
        }
        return null;
    }

    static TokenItem<CppTokenId> getRefTokenIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getToken();
        }
        return null;
    }

    private static CsmReferenceKind getRefKindIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getKindImpl();
        }
        return null;
    }

    private static BaseDocument getRefDocument(CsmReference csmReference) {
        if (csmReference instanceof DocOffsetableImpl) {
            return ((DocOffsetableImpl)csmReference).getDocument();
        }
        CsmFile csmFile = csmReference.getContainingFile();
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        StyledDocument styledDocument = null;
        if (cloneableEditorSupport != null) {
            styledDocument = cloneableEditorSupport.getDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    private static int getRefOffset(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getOffset();
        }
        return (csmReference.getStartOffset() + csmReference.getEndOffset() + 1) / 2;
    }

    private static void setResolvedInfo(CsmReference csmReference, CsmObject csmObject) {
        if (csmObject != null && csmReference instanceof ReferenceImpl) {
            ((ReferenceImpl)csmReference).setTarget(csmObject);
        }
    }

    private static boolean isLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        CsmObject csmObject2 = csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
                return true;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)csmScope)) break;
            csmObject2 = (CsmScopeElement)csmScope;
        }
        return false;
    }

    private static boolean isFileLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        if (CsmBaseUtilities.isDeclarationFromUnnamedNamespace((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            return CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObject));
        }
        return false;
    }

    static BaseDocument getDocument(CsmFile csmFile) {
        BaseDocument baseDocument = null;
        try {
            FileToDoc fileToDoc;
            Reference<FileToDoc> reference = lastCsmFile;
            if (reference != null && (fileToDoc = reference.get()) != null && fileToDoc.file == csmFile) {
                return fileToDoc.doc;
            }
            baseDocument = ReferencesSupport.getBaseDocument(((Object)csmFile.getAbsolutePath()).toString());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        if (baseDocument != null) {
            lastCsmFile = new WeakReference<FileToDoc>(new FileToDoc(baseDocument, csmFile));
        }
        return baseDocument;
    }

    static CsmReferenceKind getReferenceKind(CsmReference csmReference) {
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.UNKNOWN;
        CsmObject csmObject = csmReference.getOwner();
        if (CsmKindUtilities.isType((CsmObject)csmObject) || CsmKindUtilities.isInheritance((CsmObject)csmObject)) {
            csmReferenceKind = ReferencesSupport.getReferenceUsageKind(csmReference);
        } else if (CsmKindUtilities.isInclude((CsmObject)csmObject)) {
            csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        } else {
            CsmObject csmObject2 = csmReference.getReferencedObject();
            if (csmObject2 == null) {
                csmReferenceKind = ReferencesSupport.getReferenceUsageKind(csmReference);
            } else {
                CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject2, (boolean)true);
                CsmObject csmObject3 = csmObjectArray[0];
                CsmObject csmObject4 = csmObjectArray[1];
                assert (csmObject3 != null);
                csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
                if (csmObject != null) {
                    csmReferenceKind = csmObject.equals(csmObject4) ? CsmReferenceKind.DEFINITION : (ReferencesSupport.sameDeclaration(csmObject, csmObject3) ? CsmReferenceKind.DECLARATION : ReferencesSupport.getReferenceUsageKind(csmReference));
                }
            }
        }
        return csmReferenceKind;
    }

    private static boolean sameDeclaration(CsmObject csmObject, CsmObject csmObject2) {
        if (csmObject.equals(csmObject2)) {
            return true;
        }
        if (CsmKindUtilities.isQualified((CsmObject)csmObject) && CsmKindUtilities.isQualified((CsmObject)csmObject2)) {
            CharSequence charSequence;
            CharSequence charSequence2 = ((CsmQualifiedNamedElement)csmObject).getQualifiedName();
            if (charSequence2.equals(charSequence = ((CsmQualifiedNamedElement)csmObject2).getQualifiedName())) {
                return true;
            }
            String string = ((Object)charSequence2).toString().trim();
            if (string.endsWith("const")) {
                int n = string.lastIndexOf("const");
                assert (n >= 0);
                charSequence2 = CharSequenceKey.create((CharSequence)string.substring(n));
            }
            return charSequence2.equals(charSequence);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CsmReferenceKind getReferenceUsageKind(CsmReference csmReference) {
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        if (!(csmReference instanceof ReferenceImpl)) return csmReferenceKind;
        CsmReferenceKind csmReferenceKind2 = ReferencesSupport.getRefKindIfPossible(csmReference);
        if (csmReferenceKind2 != null) {
            return csmReferenceKind2;
        }
        BaseDocument baseDocument = ReferencesSupport.getRefDocument(csmReference);
        baseDocument.readLock();
        try {
            int n = csmReference.getStartOffset();
            TokenItem tokenItem = CndTokenUtilities.getFirstNonWhiteBwd((Document)baseDocument, (int)n);
            if (tokenItem == null) return csmReferenceKind;
            switch ((CppTokenId)tokenItem.id()) {
                case DOT: 
                case DOTMBR: 
                case ARROW: 
                case ARROWMBR: 
                case SCOPE: {
                    csmReferenceKind = CsmReferenceKind.AFTER_DEREFERENCE_USAGE;
                    return csmReferenceKind;
                }
            }
            return csmReferenceKind;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject getReferencedObject(CsmFile csmFile, int n, long l) {
        Object object = this.cacheLock;
        synchronized (object) {
            Map<Integer, CsmObject> map = this.cache.get(csmFile);
            CsmObject csmObject = null;
            if (map != null && (csmObject = map.get(n)) == FAKE && CsmFileInfoQuery.getDefault().getFileVersion(csmFile) != l) {
                map.put(n, null);
                csmObject = null;
            }
            return csmObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putReferencedObject(CsmFile csmFile, int n, CsmObject csmObject, long l) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (csmObject == FAKE && CsmFileInfoQuery.getDefault().getFileVersion(csmFile) != l) {
                return;
            }
            Map<Integer, CsmObject> map = this.cache.get(csmFile);
            if (map == null) {
                if (this.cache.size() > 10) {
                    this.cache.clear();
                }
                map = new HashMap<Integer, CsmObject>();
                this.cache.put(csmFile, map);
            }
            map.put(n, csmObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFileReferences(CsmFile csmFile) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (csmFile == null) {
                this.cache.clear();
            } else {
                this.cache.remove(csmFile);
            }
        }
    }

    public static CsmObject findMacro(List<CsmReference> list, int n) {
        int n2 = Collections.binarySearch(list, new RefOffsetKey(n), new Comparator<CsmReference>(){

            @Override
            public int compare(CsmReference csmReference, CsmReference csmReference2) {
                if (csmReference instanceof RefOffsetKey ? csmReference2.getStartOffset() <= csmReference.getStartOffset() && csmReference.getEndOffset() <= csmReference2.getEndOffset() : csmReference2 instanceof RefOffsetKey && csmReference.getStartOffset() <= csmReference2.getStartOffset() && csmReference2.getEndOffset() <= csmReference.getEndOffset()) {
                    return 0;
                }
                return csmReference.getStartOffset() - csmReference2.getStartOffset();
            }
        });
        if (n2 >= 0) {
            CsmReference csmReference = list.get(n2);
            CsmObject csmObject = csmReference.getReferencedObject();
            assert (csmObject != null) : "referenced macro is null. ref " + csmReference + ", file " + csmReference.getContainingFile() + ", name " + csmReference.getText();
            return csmObject;
        }
        return null;
    }

    private static final class RefOffsetKey
    implements CsmReference {
        private final int offset;

        private RefOffsetKey(int n) {
            this.offset = n;
        }

        public CsmReferenceKind getKind() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmObject getReferencedObject() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmObject getOwner() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getStartOffset() {
            return this.offset;
        }

        public int getEndOffset() {
            return this.offset;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class CacheLock {
        private CacheLock() {
        }
    }

    private static class FileToDoc {
        BaseDocument doc;
        CsmFile file;

        FileToDoc(BaseDocument baseDocument, CsmFile csmFile) {
            this.doc = baseDocument;
            this.file = csmFile;
        }
    }
}

