/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.awt.Component;
import java.awt.Graphics;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmTemplateBasedReferencedObject;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionTokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmExpandedTokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmCompletionQuery {
    private BaseDocument baseDocument;
    private static final String NO_SUGGESTIONS = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-no-suggestions");
    private static final String PROJECT_BEEING_PARSED = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-project-beeing-parsed");
    private static final boolean TRACE_COMPLETION = Boolean.getBoolean("cnd.completion.trace");
    private static CsmItemFactory itemFactory;
    private static final int MAX_DEPTH = 15;
    private static final int FAKE_PRIORITY = 1000;

    protected BaseDocument getBaseDocument() {
        return this.baseDocument;
    }

    protected abstract CompletionResolver getCompletionResolver(boolean var1, boolean var2, boolean var3);

    protected abstract CsmFinder getFinder();

    protected abstract QueryScope getCompletionQueryScope();

    protected abstract FileReferencesContext getFileReferencesContext();

    public CsmCompletionQuery() {
        this.initFactory();
    }

    protected void initFactory() {
        this.setCsmItemFactory(new DefaultCsmItemFactory());
    }

    public CsmCompletionResult query(JTextComponent jTextComponent, int n, boolean bl) {
        boolean bl2 = false;
        return this.query(jTextComponent, n, false, bl2, bl);
    }

    public CsmCompletionResult query(JTextComponent jTextComponent, int n, boolean bl, boolean bl2, boolean bl3) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        return this.query(jTextComponent, baseDocument, n, bl, bl2, bl3);
    }

    public static boolean checkCondition(final Document document, final int n, boolean bl) {
        if (!bl) {
            return CsmCompletionQuery._checkCondition(document, n);
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).render(new Runnable(){

                public void run() {
                    atomicBoolean.set(CsmCompletionQuery._checkCondition(document, n));
                }
            });
        } else {
            atomicBoolean.set(CsmCompletionQuery._checkCondition(document, n));
        }
        return atomicBoolean.get();
    }

    private static boolean _checkCondition(Document document, int n) {
        return !CompletionSupport.isPreprocCompletionEnabled(document, n) && CompletionSupport.isCompletionEnabled(document, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmCompletionResult query(JTextComponent jTextComponent, BaseDocument baseDocument, int n, boolean bl, boolean bl2, boolean bl3) {
        this.baseDocument = baseDocument;
        CsmCompletionResult csmCompletionResult = null;
        CompletionSupport completionSupport = CompletionSupport.get((Document)baseDocument);
        if (completionSupport == null || !CsmCompletionQuery.checkCondition((Document)baseDocument, n, true)) {
            return null;
        }
        try {
            int n2 = completionSupport.getLastCommandSeparator(n);
            CsmCompletionTokenProcessor csmCompletionTokenProcessor = new CsmCompletionTokenProcessor(n, n2);
            CndTokenProcessor<Token<CppTokenId>> cndTokenProcessor = CsmExpandedTokenProcessor.create((Document)baseDocument, csmCompletionTokenProcessor, n);
            if (cndTokenProcessor instanceof CsmExpandedTokenProcessor) {
                csmCompletionTokenProcessor.setMacroCallback((CsmExpandedTokenProcessor)cndTokenProcessor);
            }
            csmCompletionTokenProcessor.enableTemplateSupport(true);
            baseDocument.readLock();
            try {
                CndTokenUtilities.processTokens(cndTokenProcessor, (Document)baseDocument, (int)n2, (int)n);
            }
            finally {
                baseDocument.readUnlock();
            }
            completionSupport.setLastSeparatorOffset(csmCompletionTokenProcessor.getLastSeparatorOffset());
            boolean bl4 = false;
            CppTokenId cppTokenId = csmCompletionTokenProcessor.getLastValidTokenID();
            if (cppTokenId != null) {
                switch (cppTokenId) {
                    case BLOCK_COMMENT: {
                        if (csmCompletionTokenProcessor.getLastValidTokenText() != null && csmCompletionTokenProcessor.getLastValidTokenText().endsWith("*/")) break;
                        bl4 = true;
                        break;
                    }
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        bl4 = true;
                        break;
                    }
                    default: {
                        bl4 = "preprocessor-keyword".equals(cppTokenId.primaryCategory()) ? true : csmCompletionTokenProcessor.isErrorState();
                    }
                }
            }
            if (!bl4) {
                CsmCompletionExpression csmCompletionExpression = csmCompletionTokenProcessor.getResultExp();
                if (TRACE_COMPLETION) {
                    System.err.println("expression " + csmCompletionExpression);
                }
                csmCompletionResult = this.getResult(jTextComponent, (Document)baseDocument, bl, n, csmCompletionExpression, bl2, this.isInIncludeDirective(baseDocument, n), bl3);
            } else if (TRACE_COMPLETION) {
                System.err.println("Error expression " + csmCompletionTokenProcessor.getResultExp());
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return csmCompletionResult;
    }

    protected abstract boolean isProjectBeeingParsed(boolean var1);

    private CsmCompletionResult getResult(JTextComponent jTextComponent, Document document, boolean bl, int n, CsmCompletionExpression csmCompletionExpression, boolean bl2, boolean bl3, boolean bl4) {
        CompletionResolver completionResolver = this.getCompletionResolver(bl, bl2, bl3);
        if (completionResolver != null) {
            CompletionSupport completionSupport = CompletionSupport.get(document);
            CsmOffsetableDeclaration csmOffsetableDeclaration = completionSupport.getDefinition(n, this.getFileReferencesContext());
            Context context = new Context(jTextComponent, completionSupport, bl, n, this.getFinder(), completionResolver, csmOffsetableDeclaration, bl2, bl4);
            context.resolveExp(csmCompletionExpression);
            if (context.result != null) {
                context.result.setSimpleVariableExpression(CsmCompletionQuery.isSimpleVariableExpression(csmCompletionExpression));
            }
            if (TRACE_COMPLETION) {
                CompletionItem[] completionItemArray = context.result == null ? new CompletionItem[]{} : context.result.getItems().toArray(new CompletionItem[context.result.getItems().size()]);
                System.err.println("Completion Items " + completionItemArray.length);
                for (int i = 0; i < completionItemArray.length; ++i) {
                    CompletionItem completionItem = completionItemArray[i];
                    System.err.println(completionItem.toString());
                }
            }
            return context.result;
        }
        boolean bl5 = this.isProjectBeeingParsed(bl);
        return new CsmCompletionResult(jTextComponent, this.getBaseDocument(), Collections.EMPTY_LIST, "", csmCompletionExpression, 0, bl5, null, bl4);
    }

    private String formatName(String string, boolean bl) {
        return string != null ? (bl ? string + '*' : string) : (bl ? "*" : "");
    }

    private String formatType(CsmType csmType, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (csmType != null) {
            stringBuilder.append(csmType.getText());
        }
        if (bl2) {
            stringBuilder.append("::");
        }
        return stringBuilder.toString();
    }

    private static String formatType(CsmType csmType, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (csmType != null && csmType.getClassifier() != null) {
            stringBuilder.append(bl ? csmType.getClassifier().getQualifiedName() : csmType.getClassifier().getName());
        }
        if (bl2) {
            stringBuilder.append("::");
        }
        if (bl3) {
            stringBuilder.append('*');
        }
        return stringBuilder.toString();
    }

    static List<CsmClassifier> findNestedClassifiers(CsmFinder csmFinder, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClassifier csmClassifier, String string, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<CsmClassifier> arrayList = new ArrayList<CsmClassifier>();
        if (!CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier, (CsmFile)csmFinder.getCsmFile())))) {
            return arrayList;
        }
        CsmClass csmClass = (CsmClass)csmClassifier;
        List<CsmClassifier> list = csmFinder.findNestedClassifiers(csmOffsetableDeclaration, csmClass, string, bl, bl2, bl3);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    static List<CsmObject> findFieldsAndMethods(CsmFinder csmFinder, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClassifier csmClassifier, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        List<CsmField> list;
        ArrayList<CsmObject> arrayList = new ArrayList<CsmObject>();
        if (!CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier, (CsmFile)csmFinder.getCsmFile())))) {
            return arrayList;
        }
        CsmClass csmClass = (CsmClass)csmClassifier;
        CsmFunction csmFunction = CsmBaseUtilities.getContextFunction((CsmOffsetableDeclaration)csmOffsetableDeclaration);
        CsmClass csmClass2 = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)csmOffsetableDeclaration);
        if (CsmInheritanceUtilities.isAssignableFrom((CsmClass)csmClass2, (CsmClass)csmClass)) {
            bl2 = false;
        }
        if ((list = csmFinder.findFields(csmOffsetableDeclaration, csmClass, string, bl, bl2, bl3, bl4, bl5, bl7)) != null) {
            arrayList.addAll(list);
        }
        if ((list = csmFinder.findEnumerators(csmOffsetableDeclaration, csmClass, string, bl, bl3, bl4, bl5, bl7)) != null) {
            arrayList.addAll(list);
        }
        if (csmFunction == null && csmClass2 == null) {
            bl2 = false;
            csmOffsetableDeclaration = csmClass;
        }
        if ((list = csmFinder.findMethods(csmOffsetableDeclaration, csmClass, string, bl, bl2, bl3, bl4, bl5, bl7)) != null) {
            if (!bl6) {
                arrayList.addAll(list);
            } else {
                for (CsmField csmField : list) {
                    if (CsmKindUtilities.isConstructor((CsmObject)((CsmObject)csmField))) continue;
                    arrayList.add((CsmObject)csmField);
                }
            }
        }
        return arrayList;
    }

    private static CsmClassifier getClassifier(CsmType csmType, CsmFile csmFile) {
        CsmClassifier csmClassifier = CsmBaseUtilities.getClassifier((CsmType)csmType, (CsmFile)csmFile, (boolean)true);
        return csmClassifier;
    }

    private static CsmFunction getOperator(CsmClassifier csmClassifier, CsmFile csmFile, CsmFunction.OperatorKind operatorKind) {
        if (!CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
            return null;
        }
        CsmClass csmClass = (CsmClass)csmClassifier;
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter((CharSequence)("operator " + operatorKind.getImage()), false, true, false);
        return CsmCompletionQuery.getOperatorCheckBaseClasses(csmClass, csmFile, csmFilter, operatorKind, new AntiLoop());
    }

    private static CsmFunction getOperatorCheckBaseClasses(CsmClass csmClass, CsmFile csmFile, CsmSelect.CsmFilter csmFilter, CsmFunction.OperatorKind operatorKind, AntiLoop antiLoop) {
        if (antiLoop.contains((CsmClassifier)csmClass)) {
            return null;
        }
        antiLoop.add((CsmClassifier)csmClass);
        Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)csmFilter);
        while (iterator.hasNext()) {
            CsmMember csmMember = (CsmMember)iterator.next();
            if (!CsmKindUtilities.isOperator((CsmObject)csmMember) || ((CsmFunction)csmMember).getOperatorKind() != operatorKind) continue;
            return (CsmFunction)csmMember;
        }
        for (CsmInheritance csmInheritance : csmClass.getBaseClasses()) {
            CsmFunction csmFunction;
            CsmClassifier csmClassifier = CsmCompletionQuery.getClassifier(csmInheritance.getAncestorType(), csmFile);
            if (!CsmKindUtilities.isClass((CsmObject)csmClassifier) || (csmFunction = CsmCompletionQuery.getOperatorCheckBaseClasses((CsmClass)csmClassifier, csmFile, csmFilter, operatorKind, antiLoop)) == null) continue;
            return csmFunction;
        }
        return null;
    }

    private static CsmType getOverloadedOperatorReturnType(CsmType csmType, CsmFile csmFile, CsmFunction.OperatorKind operatorKind, int n) {
        CsmFunction csmFunction;
        if (csmType == null || csmType.isPointer() || csmType.getArrayDepth() > 0) {
            return null;
        }
        CsmType csmType2 = null;
        CsmClassifier csmClassifier = CsmCompletionQuery.getClassifier(csmType, csmFile);
        if (CsmKindUtilities.isClass((CsmObject)csmClassifier) && (csmFunction = CsmCompletionQuery.getOperator((CsmClassifier)((CsmClass)csmClassifier), csmFile, operatorKind)) != null) {
            csmType2 = csmFunction.getReturnType();
            if (!csmType.equals(csmType2) && n > 0) {
                CsmType csmType3;
                if (operatorKind == CsmFunction.OperatorKind.ARROW && (csmType3 = CsmCompletionQuery.getOverloadedOperatorReturnType(csmType2, csmFile, operatorKind, n - 1)) != null) {
                    csmType2 = csmType3;
                }
            } else {
                CsmFile csmFile2 = csmType.getContainingFile();
                System.err.printf("circular pointer delegation detected:%s, line %d/n", csmFile2 != null ? csmFile2.getAbsolutePath() : csmType, csmType.getStartOffset());
                CndUtils.assertTrueInConsole((boolean)false, (String)("Infinite recursion in file " + csmFile2 + " type " + csmType));
            }
        }
        return csmType2;
    }

    private boolean isInIncludeDirective(BaseDocument baseDocument, int n) {
        return false;
    }

    private static String formatTypeList(List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() > 0) {
            int n = list.size() - 1;
            for (int i = 0; i <= n; ++i) {
                CsmType csmType = (CsmType)list.get(i);
                if (csmType != null) {
                    stringBuilder.append(csmType.getText());
                } else {
                    stringBuilder.append('?');
                }
                if (i >= n) continue;
                stringBuilder.append(", ");
            }
            if (bl) {
                stringBuilder.append(", *");
            }
        } else if (bl) {
            stringBuilder.append("*");
        }
        return stringBuilder.toString();
    }

    private static boolean isSimpleVariableExpression(CsmCompletionExpression csmCompletionExpression) {
        switch (csmCompletionExpression.getExpID()) {
            case 4: 
            case 5: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return false;
            }
        }
        return true;
    }

    protected void setCsmItemFactory(CsmItemFactory csmItemFactory) {
        itemFactory = csmItemFactory;
    }

    public static CsmItemFactory getCsmItemFactory() {
        return itemFactory;
    }

    private static List<CompletionItem> convertData(Collection collection, int n, CsmCompletionExpression csmCompletionExpression, int n2, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        for (Object e : collection) {
            CsmResultItem csmResultItem = CsmCompletionQuery.createResultItem(e, n, csmCompletionExpression, csmOffsetableDeclaration, bl);
            assert (csmResultItem != null) : "why null item? object " + e;
            if (csmResultItem == null) continue;
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        return arrayList;
    }

    private static CsmResultItem createResultItem(Object object, int n, CsmCompletionExpression csmCompletionExpression, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl) {
        if (CsmKindUtilities.isCsmObject((Object)object)) {
            CsmObject csmObject = (CsmObject)object;
            assert (!CsmKindUtilities.isMethod((CsmObject)csmObject) || CsmKindUtilities.isMethodDeclaration((CsmObject)csmObject)) : "completion result can not have method definitions " + object;
            if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createNamespaceResultItem((CsmNamespace)csmObject, false);
            }
            if (CsmKindUtilities.isEnum((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createEnumResultItem((CsmEnum)csmObject, n, false);
            }
            if (CsmKindUtilities.isEnumerator((Object)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalEnumeratorResultItem((CsmEnumerator)csmObject, n, false);
            }
            if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createClassResultItem((CsmClass)csmObject, n, false);
            }
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createForwardClassResultItem((CsmClassForwardDeclaration)csmObject, n, false);
            }
            if (CsmKindUtilities.isField((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createFieldResultItem((CsmField)csmObject);
            }
            if (CsmKindUtilities.isConstructor((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createConstructorResultItem((CsmConstructor)csmObject, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl);
            }
            if (CsmKindUtilities.isMethodDeclaration((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createMethodResultItem((CsmMethod)csmObject, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl);
            }
            if (CsmKindUtilities.isGlobalFunction((CsmObject)csmObject)) {
                if (CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObject))) {
                    return CsmCompletionQuery.getCsmItemFactory().createFileLocalFunctionResultItem((CsmFunction)csmObject, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl);
                }
                return CsmCompletionQuery.getCsmItemFactory().createGlobalFunctionResultItem((CsmFunction)csmObject, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl);
            }
            if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalVariableResultItem((CsmVariable)csmObject);
            }
            if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createFileLocalVariableResultItem((CsmVariable)csmObject);
            }
            if (CsmKindUtilities.isLocalVariable((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createLocalVariableResultItem((CsmVariable)csmObject);
            }
            if (CsmKindUtilities.isMacro((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalMacroResultItem((CsmMacro)csmObject);
            }
            if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createTypedefResultItem((CsmTypedef)csmObject, n, false);
            }
            if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createLabelResultItem((CsmLabel)csmObject);
            }
            if (CsmKindUtilities.isNamespaceAlias((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createNamespaceAliasResultItem((CsmNamespaceAlias)csmObject, false);
            }
            if (csmObject instanceof CsmTemplateBasedReferencedObject) {
                return new TemplateBasedReferencedObjectResultItem((CsmObject)object);
            }
        }
        return null;
    }

    private static List<CompletionItem> convertData(CompletionResolver.Result result, int n, CsmCompletionExpression csmCompletionExpression, int n2, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl) {
        CsmResultItem csmResultItem;
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(result.size());
        CsmItemFactory csmItemFactory = CsmCompletionQuery.getCsmItemFactory();
        for (CsmVariable csmVariable : result.getLocalVariables()) {
            csmResultItem = csmItemFactory.createLocalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmTemplateParameter csmTemplateParameter : result.getTemplateparameters()) {
            csmResultItem = csmItemFactory.createTemplateParameterResultItem(csmTemplateParameter);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmField csmField : result.getClassFields()) {
            csmResultItem = csmItemFactory.createFieldResultItem(csmField);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getClassEnumerators()) {
            csmResultItem = csmItemFactory.createMemberEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMethod csmMethod : result.getClassMethods()) {
            csmResultItem = CsmKindUtilities.isConstructor((CsmObject)csmMethod) ? csmItemFactory.createConstructorResultItem((CsmConstructor)csmMethod, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl) : csmItemFactory.createMethodResultItem(csmMethod, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmClassifier csmClassifier : result.getProjectClassesifiersEnums()) {
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createClassResultItem((CsmClass)csmClassifier, n, false);
            } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmClassifier)) {
                CsmClassForwardDeclaration csmClassForwardDeclaration = (CsmClassForwardDeclaration)csmClassifier;
                if (csmClassForwardDeclaration.getCsmClass() == null) continue;
                csmResultItem = csmItemFactory.createClassResultItem(csmClassForwardDeclaration.getCsmClass(), n, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createTypedefResultItem((CsmTypedef)csmClassifier, n, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                csmResultItem = csmItemFactory.createEnumResultItem((CsmEnum)csmClassifier, n, false);
            }
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmVariable csmVariable : result.getFileLocalVars()) {
            csmResultItem = csmItemFactory.createFileLocalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getFileLocalEnumerators()) {
            csmResultItem = csmItemFactory.createFileLocalEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getFileLocalMacros()) {
            csmResultItem = csmItemFactory.createFileLocalMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmFunction csmFunction : result.getFileLocalFunctions()) {
            csmResultItem = csmItemFactory.createFileLocalFunctionResultItem(csmFunction, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getInFileIncludedProjectMacros()) {
            csmResultItem = csmItemFactory.createFileIncludedProjectMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmVariable csmVariable : result.getGlobalVariables()) {
            csmResultItem = csmItemFactory.createGlobalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getGlobalEnumerators()) {
            csmResultItem = csmItemFactory.createGlobalEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getGlobalProjectMacros()) {
            csmResultItem = csmItemFactory.createGlobalMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmFunction csmFunction : result.getGlobalProjectFunctions()) {
            csmResultItem = csmItemFactory.createGlobalFunctionResultItem(csmFunction, csmCompletionExpression, CsmCompletionQuery.isDeclaration(csmCompletionExpression, csmOffsetableDeclaration), bl);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespace csmNamespace : result.getGlobalProjectNamespaces()) {
            csmResultItem = csmItemFactory.createNamespaceResultItem(csmNamespace, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : result.getProjectNamespaceAliases()) {
            csmResultItem = csmItemFactory.createNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmClassifier csmClassifier : result.getLibClassifiersEnums()) {
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createLibClassResultItem((CsmClass)csmClassifier, n, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createLibTypedefResultItem((CsmTypedef)csmClassifier, n, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                csmResultItem = csmItemFactory.createLibEnumResultItem((CsmEnum)csmClassifier, n, false);
            }
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getInFileIncludedLibMacros()) {
            csmResultItem = csmItemFactory.createFileIncludedLibMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getLibMacros()) {
            csmResultItem = csmItemFactory.createLibMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmVariable csmVariable : result.getLibVariables()) {
            csmResultItem = csmItemFactory.createLibGlobalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getLibEnumerators()) {
            csmResultItem = csmItemFactory.createLibGlobalEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmFunction csmFunction : result.getLibFunctions()) {
            csmResultItem = csmItemFactory.createLibGlobalFunctionResultItem(csmFunction, csmCompletionExpression, bl);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespace csmNamespace : result.getLibNamespaces()) {
            csmResultItem = csmItemFactory.createLibNamespaceResultItem(csmNamespace, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : result.getLibNamespaceAliases()) {
            csmResultItem = csmItemFactory.createLibNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        return arrayList;
    }

    private static boolean isDeclaration(CsmCompletionExpression csmCompletionExpression, CsmOffsetableDeclaration csmOffsetableDeclaration) {
        int n = csmCompletionExpression.getExpID();
        return csmOffsetableDeclaration == null && (n == 1 || n == 27 || n == 28);
    }

    static /* synthetic */ CsmFunction access$600(CsmClassifier csmClassifier, CsmFile csmFile, CsmFunction.OperatorKind operatorKind) {
        return CsmCompletionQuery.getOperator(csmClassifier, csmFile, operatorKind);
    }

    static /* synthetic */ String access$700(List list, boolean bl) {
        return CsmCompletionQuery.formatTypeList(list, bl);
    }

    private static class TemplateBasedReferencedObjectResultItem
    extends CsmResultItem {
        TemplateBasedReferencedObjectResultItem(CsmObject csmObject) {
            super(csmObject, 0);
        }

        public String getItemText() {
            return "TemplateBasedReferencedObjectResultItem for " + this.getAssociatedObject();
        }

        protected Component getPaintComponent(boolean bl) {
            return new CsmPaintComponent(){

                protected void draw(Graphics graphics) {
                }

                public String toString() {
                    return "fake TemplateBasedReferencedObjectResultItem paint component";
                }
            };
        }

        public String toString() {
            return "TemplateBasedReferencedObjectResultItem for " + this.getAssociatedObject();
        }
    }

    private static class TemplateBasedReferencedObjectImpl
    implements CsmTemplateBasedReferencedObject {
        private TemplateBasedReferencedObjectImpl() {
        }

        public int getNameStartOffset() {
            return 0;
        }

        public int getNameEndOffset() {
            return 0;
        }

        public CharSequence getName() {
            return "template based ref object";
        }

        public CsmFile getContainingFile() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public CsmOffsetable.Position getStartPosition() {
            return null;
        }

        public CsmOffsetable.Position getEndPosition() {
            return null;
        }

        public CharSequence getText() {
            return this.getName();
        }
    }

    public static final class DefaultCsmItemFactory
    implements CsmItemFactory {
        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace csmNamespace, boolean bl) {
            return new CsmResultItem.NamespaceResultItem(csmNamespace, bl, 1000);
        }

        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias csmNamespaceAlias, boolean bl) {
            return new CsmResultItem.NamespaceAliasResultItem(csmNamespaceAlias, bl, 1000);
        }

        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return this.createGlobalEnumeratorResultItem(csmEnumerator, n, bl);
        }

        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return this.createGlobalEnumeratorResultItem(csmEnumerator, n, bl);
        }

        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return new CsmResultItem.EnumeratorResultItem(csmEnumerator, n, bl, 1000);
        }

        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass csmClass, int n, boolean bl) {
            return new CsmResultItem.ClassResultItem(csmClass, n, bl, 1000);
        }

        public CsmResultItem.ForwardClassResultItem createForwardClassResultItem(CsmClassForwardDeclaration csmClassForwardDeclaration, int n, boolean bl) {
            return new CsmResultItem.ForwardClassResultItem(csmClassForwardDeclaration, n, bl, 1000);
        }

        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum csmEnum, int n, boolean bl) {
            return new CsmResultItem.EnumResultItem(csmEnum, n, bl, 1000);
        }

        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef csmTypedef, int n, boolean bl) {
            return new CsmResultItem.TypedefResultItem(csmTypedef, n, bl, 1000);
        }

        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass csmClass, int n, boolean bl) {
            return this.createClassResultItem(csmClass, n, bl);
        }

        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum csmEnum, int n, boolean bl) {
            return this.createEnumResultItem(csmEnum, n, bl);
        }

        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef csmTypedef, int n, boolean bl) {
            return this.createTypedefResultItem(csmTypedef, n, bl);
        }

        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField csmField) {
            return new CsmResultItem.FieldResultItem(csmField, 1000);
        }

        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod csmMethod, CsmCompletionExpression csmCompletionExpression, boolean bl, boolean bl2) {
            return new CsmResultItem.MethodResultItem((CsmFunction)csmMethod, csmCompletionExpression, 1000, bl, bl2);
        }

        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor csmConstructor, CsmCompletionExpression csmCompletionExpression, boolean bl, boolean bl2) {
            return new CsmResultItem.ConstructorResultItem((CsmFunction)csmConstructor, csmCompletionExpression, 1000, bl, bl2);
        }

        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, boolean bl, boolean bl2) {
            return new CsmResultItem.GlobalFunctionResultItem(csmFunction, csmCompletionExpression, 1000, bl, bl2);
        }

        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable csmVariable) {
            return new CsmResultItem.GlobalVariableResultItem(csmVariable, 1000);
        }

        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable csmVariable) {
            return new CsmResultItem.LocalVariableResultItem(csmVariable, 1000);
        }

        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable csmVariable) {
            return new CsmResultItem.FileLocalVariableResultItem(csmVariable, 1000);
        }

        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, boolean bl, boolean bl2) {
            return new CsmResultItem.FileLocalFunctionResultItem(csmFunction, csmCompletionExpression, 1000, bl, bl2);
        }

        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro csmMacro) {
            return new CsmResultItem.MacroResultItem(csmMacro, 1000);
        }

        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable csmVariable) {
            return this.createGlobalVariableResultItem(csmVariable);
        }

        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return this.createGlobalEnumeratorResultItem(csmEnumerator, n, bl);
        }

        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, boolean bl) {
            return this.createGlobalFunctionResultItem(csmFunction, csmCompletionExpression, false, bl);
        }

        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace csmNamespace, boolean bl) {
            return this.createNamespaceResultItem(csmNamespace, bl);
        }

        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias csmNamespaceAlias, boolean bl) {
            return this.createNamespaceAliasResultItem(csmNamespaceAlias, bl);
        }

        public CsmResultItem.TemplateParameterResultItem createTemplateParameterResultItem(CsmTemplateParameter csmTemplateParameter) {
            return new CsmResultItem.TemplateParameterResultItem(csmTemplateParameter, 1000);
        }

        public CsmResultItem createLabelResultItem(CsmLabel csmLabel) {
            return new CsmResultItem.LabelResultItem(csmLabel, 1000);
        }
    }

    public static interface CsmItemFactory {
        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem createLabelResultItem(CsmLabel var1);

        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField var1);

        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.ForwardClassResultItem createForwardClassResultItem(CsmClassForwardDeclaration var1, int var2, boolean var3);

        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro var1);

        public CsmResultItem.TemplateParameterResultItem createTemplateParameterResultItem(CsmTemplateParameter var1);

        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro var1);

        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);

        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3);

        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CsmCompletionResult {
        private int classDisplayOffset;
        private CsmCompletionExpression substituteExp;
        private int substituteOffset;
        private int substituteLength;
        private JTextComponent component;
        private BaseDocument baseDocument;
        private List<CompletionItem> items;
        private boolean simpleVariableExpression;

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, Collection collection, String string, CsmCompletionExpression csmCompletionExpression, int n, boolean bl, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl2) {
            this(jTextComponent, baseDocument, collection, string, csmCompletionExpression, csmCompletionExpression.getTokenOffset(0), csmCompletionExpression.getTokenLength(0), n, bl, csmOffsetableDeclaration, bl2);
        }

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, CompletionResolver.Result result, String string, CsmCompletionExpression csmCompletionExpression, int n, int n2, int n3, boolean bl, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl2) {
            this(jTextComponent, baseDocument, CsmCompletionQuery.convertData(result, n3, csmCompletionExpression, n, csmOffsetableDeclaration, bl2), true, string, csmCompletionExpression, n, n2, n3, bl);
        }

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, Collection collection, String string, CsmCompletionExpression csmCompletionExpression, int n, int n2, int n3, boolean bl, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl2) {
            this(jTextComponent, baseDocument, CsmCompletionQuery.convertData(collection, n3, csmCompletionExpression, n, csmOffsetableDeclaration, bl2), true, string, csmCompletionExpression, n, n2, n3, bl);
        }

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, List<CompletionItem> list, boolean bl, String string, CsmCompletionExpression csmCompletionExpression, int n, int n2, int n3, boolean bl2) {
            this.component = jTextComponent;
            this.baseDocument = baseDocument;
            this.substituteExp = csmCompletionExpression;
            this.substituteOffset = n;
            this.substituteLength = n2;
            this.classDisplayOffset = n3;
            this.items = list;
        }

        public List<CompletionItem> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        private static String getTitle(List list, String string, boolean bl) {
            if (CsmUtilities.DEBUG) {
                System.out.println("original title (resolved type) was " + string);
            }
            String string2 = NO_SUGGESTIONS;
            if (list != null && list.size() > 0) {
                string2 = string;
            }
            if (bl) {
                string2 = MessageFormat.format(PROJECT_BEEING_PARSED, string2);
            }
            return string2;
        }

        protected JTextComponent getComponent() {
            return this.component;
        }

        protected int getSubstituteLength() {
            return this.substituteLength;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }

        protected CsmCompletionExpression getSubstituteExp() {
            return this.substituteExp;
        }

        protected int getClassDisplayOffset() {
            return this.classDisplayOffset;
        }

        private void setSimpleVariableExpression(boolean bl) {
            this.simpleVariableExpression = bl;
        }

        public boolean isSimpleVariableExpression() {
            return this.simpleVariableExpression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Context {
        private boolean sort;
        private JTextComponent component;
        private CompletionSupport sup;
        private boolean openingSource;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = false;
        private boolean memberPointer = false;
        private boolean scopeAccessedClassifier = false;
        private CsmNamespace lastNamespace;
        private CsmType lastType;
        private CsmCompletionResult result;
        private boolean isConstructor;
        private final CsmFinder finder;
        private final CsmFile contextFile;
        private CompletionResolver compResolver;
        private CsmOffsetableDeclaration contextElement;
        private final boolean instantiateTypes;

        public Context(JTextComponent jTextComponent, CompletionSupport completionSupport, boolean bl, int n, CsmFinder csmFinder, CompletionResolver completionResolver, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl2, boolean bl3) {
            this.component = jTextComponent;
            this.sup = completionSupport;
            this.openingSource = bl;
            this.endOffset = n;
            this.finder = csmFinder;
            this.contextFile = csmFinder == null ? null : csmFinder.getCsmFile();
            this.compResolver = completionResolver;
            this.contextElement = csmOffsetableDeclaration;
            this.sort = bl2;
            this.instantiateTypes = bl3;
        }

        private int convertOffset(int n) {
            return this.sup.doc2context(n);
        }

        private boolean resolve(int n, String string, boolean bl) {
            n = this.convertOffset(n);
            return this.compResolver.refresh() && this.compResolver.resolve(n, string, bl);
        }

        private void setFindType(boolean bl) {
            this.findType = bl;
        }

        protected Object clone() {
            return new Context(this.component, this.sup, this.openingSource, this.endOffset, this.finder, this.compResolver, this.contextElement, this.sort, this.instantiateTypes);
        }

        private CsmClassifier extractLastTypeClassifier(ExprKind exprKind) {
            CsmCompletion.SimpleClass simpleClass = this.lastType.getArrayDepth() == 0 || exprKind == ExprKind.ARROW ? CsmCompletionQuery.getClassifier(this.lastType, this.contextFile) : CsmCompletion.OBJECT_CLASS_ARRAY;
            return simpleClass;
        }

        private Collection<CsmFunction> getConstructors(CsmClass csmClass) {
            ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
            CsmSelect.CsmFilterBuilder csmFilterBuilder = CsmSelect.getFilterBuilder();
            CsmSelect.CsmFilter csmFilter = csmFilterBuilder.createCompoundFilter(csmFilterBuilder.createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION}), csmFilterBuilder.createNameFilter(csmClass.getName(), true, true, false));
            Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)csmFilter);
            while (iterator.hasNext()) {
                CsmMember csmMember = (CsmMember)iterator.next();
                if (!CsmKindUtilities.isConstructor((CsmObject)csmMember)) continue;
                arrayList.add((CsmFunction)((CsmConstructor)csmMember));
            }
            return arrayList;
        }

        private CsmType extractFunctionType(Collection<CsmFunction> collection, CsmCompletionExpression csmCompletionExpression) {
            CsmType csmType = null;
            if (collection.isEmpty()) {
                return null;
            }
            for (CsmFunction csmFunction : collection) {
                CsmClass csmClass;
                if (csmCompletionExpression != null && CsmKindUtilities.isTemplate((CsmObject)csmFunction) && CsmKindUtilities.isFunction((CsmObject)(csmClass = this.createInstantiation((CsmTemplate)csmFunction, csmCompletionExpression)))) {
                    csmFunction = (CsmFunction)csmClass;
                }
                if (CsmKindUtilities.isConstructor((CsmObject)csmFunction)) {
                    csmClass = ((CsmConstructor)csmFunction).getContainingClass();
                    csmType = CsmCompletion.getType((CsmClassifier)csmClass, 0, false, 0, false);
                } else {
                    csmType = csmFunction.getReturnType();
                }
                if (csmType == null) continue;
                break;
            }
            return csmType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CsmType resolveType(CsmCompletionExpression csmCompletionExpression) {
            CsmType csmType = csmCompletionExpression.getCachedType();
            if (csmType == null) {
                Context context = (Context)this.clone();
                context.setFindType(true);
                QueryScope queryScope = context.compResolver.setResolveScope(QueryScope.GLOBAL_QUERY);
                try {
                    if (context.resolveExp(csmCompletionExpression)) {
                        csmType = context.lastType;
                    }
                }
                finally {
                    csmCompletionExpression.cacheType(csmType);
                    context.compResolver.setResolveScope(queryScope);
                }
            }
            return csmType;
        }

        private boolean isProjectBeeingParsed() {
            return CsmCompletionQuery.this.isProjectBeeingParsed(this.openingSource);
        }

        private ExprKind extractKind(CsmCompletionExpression csmCompletionExpression, int n, int n2, boolean bl, boolean bl2) {
            ExprKind exprKind;
            block15: {
                block16: {
                    int n3;
                    block14: {
                        exprKind = ExprKind.NONE;
                        n3 = csmCompletionExpression.getTokenCount();
                        if (n != n2) break block14;
                        exprKind = ExprKind.NONE;
                        break block15;
                    }
                    if (n - 1 >= n3) break block16;
                    switch (csmCompletionExpression.getTokenID(n - 1)) {
                        case ARROW: {
                            exprKind = ExprKind.ARROW;
                            if (bl2) {
                                this.scopeAccessedClassifier = false;
                                break;
                            }
                            break block15;
                        }
                        case DOT: {
                            exprKind = ExprKind.DOT;
                            if (bl2) {
                                this.scopeAccessedClassifier = false;
                                break;
                            }
                            break block15;
                        }
                        case SCOPE: {
                            exprKind = ExprKind.SCOPE;
                            if (bl2) {
                                this.scopeAccessedClassifier = true;
                                break;
                            }
                            break block15;
                        }
                        default: {
                            System.err.println("unexpected token " + csmCompletionExpression.getTokenID(n));
                            break;
                        }
                    }
                    break block15;
                }
                if (bl) {
                    switch (csmCompletionExpression.getExpID()) {
                        case 25: 
                        case 26: {
                            exprKind = ExprKind.ARROW;
                            if (!bl2) break;
                            this.scopeAccessedClassifier = false;
                            break;
                        }
                        case 4: 
                        case 5: {
                            exprKind = ExprKind.DOT;
                            if (!bl2) break;
                            this.scopeAccessedClassifier = false;
                            break;
                        }
                        case 27: 
                        case 28: {
                            exprKind = ExprKind.SCOPE;
                            if (!bl2) break;
                            this.scopeAccessedClassifier = true;
                            break;
                        }
                        default: {
                            System.err.println("unexpected expression" + csmCompletionExpression);
                        }
                    }
                }
            }
            return exprKind;
        }

        private boolean resolveParams(CsmCompletionExpression csmCompletionExpression, boolean bl, ExprKind[] exprKindArray) {
            CsmType csmType;
            Object object;
            boolean bl2 = true;
            int n = csmCompletionExpression.getParameterCount();
            int n2 = 0;
            int n3 = csmCompletionExpression.getTokenCount();
            for (int i = n3 - 1; 0 <= i; --i) {
                object = csmCompletionExpression.getTokenID(i);
                if (object != CppTokenId.DOTMBR && object != CppTokenId.ARROWMBR) continue;
                n2 = i + 1;
                break;
            }
            ExprKind exprKind = ExprKind.NONE;
            object = ExprKind.NONE;
            int n4 = n - 1;
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            for (int i = n2; i < n && bl2; ++i) {
                CsmType csmType2;
                exprKind = this.extractKind(csmCompletionExpression, i, n2, bl, true);
                object = this.extractKind(csmCompletionExpression, i + 1, n2, bl, false);
                if (exprKind == ExprKind.ARROW && !atomicBoolean.get() && i != n2 && (i < n || bl || this.findType) && this.lastType != null && this.lastType.getArrayDepth() == 0 && (csmType2 = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, CsmFunction.OperatorKind.ARROW, 15)) != null) {
                    this.lastType = csmType2;
                }
                atomicBoolean.set(false);
                bl2 = this.resolveItem(csmCompletionExpression.getParameter(i), i == n2, !bl && i == n4, exprKind, (ExprKind)((Object)object), atomicBoolean);
            }
            if (bl2 && bl && (exprKind = this.extractKind(csmCompletionExpression, n3 + 1, n2, true, true)) == ExprKind.ARROW && !atomicBoolean.get() && (bl || this.findType) && this.lastType != null && this.lastType.getArrayDepth() == 0 && (csmType = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, CsmFunction.OperatorKind.ARROW, 15)) != null) {
                this.lastType = csmType;
            }
            exprKindArray[0] = exprKind;
            return bl2;
        }

        boolean resolveExp(CsmCompletionExpression csmCompletionExpression) {
            boolean bl = false;
            boolean bl2 = true;
            switch (csmCompletionExpression.getExpID()) {
                case 5: 
                case 26: {
                    bl = true;
                }
                case 4: 
                case 25: {
                    ExprKind[] exprKindArray = new ExprKind[]{ExprKind.NONE};
                    bl2 = this.resolveParams(csmCompletionExpression, bl, exprKindArray);
                    if (!bl2 || !bl) break;
                    int n = csmCompletionExpression.getTokenCount() - 1;
                    int n2 = csmCompletionExpression.getTokenOffset(n) + csmCompletionExpression.getTokenLength(n);
                    if (this.lastType != null) {
                        List<Object> list;
                        CsmClassifier csmClassifier = this.extractLastTypeClassifier(exprKindArray[0]);
                        if (this.openingSource) {
                            list = new ArrayList<CsmClassifier>();
                            list.add(this.lastType.getClassifier());
                        } else {
                            list = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, csmClassifier, "", false, this.staticOnly && !this.memberPointer, false, true, this.scopeAccessedClassifier, true, this.sort);
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, CsmCompletionQuery.formatType(this.lastType, true, true, true), csmCompletionExpression, n2, 0, csmClassifier.getName().length() + 1, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    this.result = null;
                    break;
                }
                case 28: {
                    bl = true;
                }
                case 27: {
                    List<Object> list;
                    this.staticOnly = true;
                    ExprKind[] exprKindArray = new ExprKind[]{ExprKind.NONE};
                    bl2 = this.resolveParams(csmCompletionExpression, bl, exprKindArray);
                    if (!bl2 || !bl) break;
                    int n = csmCompletionExpression.getTokenCount() - 1;
                    int n3 = csmCompletionExpression.getTokenOffset(n) + csmCompletionExpression.getTokenLength(n);
                    if (this.lastType != null) {
                        List<Object> list2;
                        CsmClassifier csmClassifier = this.extractLastTypeClassifier(ExprKind.SCOPE);
                        if (this.openingSource) {
                            list2 = new ArrayList<CsmClassifier>();
                            list2.add(this.lastType.getClassifier());
                        } else {
                            list2 = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, csmClassifier, "", false, this.staticOnly && !this.memberPointer, false, true, this.scopeAccessedClassifier, false, this.sort);
                            List<CsmClassifier> list3 = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, csmClassifier, "", false, true, this.sort);
                            list2.addAll(list3);
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list2, CsmCompletionQuery.formatType(this.lastType, true, true, true), csmCompletionExpression, n3, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    String string = (this.lastNamespace.isGlobal() ? "" : this.lastNamespace.getQualifiedName()) + "::";
                    if (this.openingSource) {
                        list = new ArrayList<CsmNamespace>();
                        list.add(this.lastNamespace);
                    } else {
                        list = this.finder.findNestedNamespaces(this.lastNamespace, "", false, false);
                        String string2 = null;
                        try {
                            int n4 = csmCompletionExpression.getTokenOffset(0);
                            int n5 = this.sup.getLastCommandSeparator(n4);
                            if (n5 >= 0) {
                                string2 = this.sup.getDocument().getText(n5, n4 - n5);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (string2 != null && -1 == string2.indexOf("namespace")) {
                            list.addAll(this.finder.findNamespaceElements(this.lastNamespace, "", false, false, false));
                        }
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, string + '*', csmCompletionExpression, n3, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 15: {
                    List<CsmClassifier> list = this.finder.findClasses(null, "", false, false);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, "*", csmCompletionExpression, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 35: {
                    String string = csmCompletionExpression.getParameter(0).getTokenText(0);
                    List<CsmLabel> list = this.finder.findLabel(this.contextElement, string, false, false);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, "*", csmCompletionExpression, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 24: {
                    csmCompletionExpression = csmCompletionExpression.getParameter(0);
                }
                default: {
                    AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                    bl2 = this.resolveItem(csmCompletionExpression, true, true, ExprKind.NONE, ExprKind.NONE, atomicBoolean);
                }
            }
            return bl2;
        }

        private CsmType getPredefinedType(CsmCompletionExpression csmCompletionExpression) {
            CsmFile csmFile = CsmCompletionQuery.this.getFinder().getCsmFile();
            int n = csmCompletionExpression.getTokenOffset(0);
            int n2 = csmCompletionExpression.getTokenCount() - 1;
            int n3 = csmCompletionExpression.getTokenOffset(n2) + csmCompletionExpression.getTokenLength(n2);
            return CsmCompletion.getPredefinedType(csmFile, n, n3, csmCompletionExpression.getType());
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        boolean resolveItem(CsmCompletionExpression var1_1, boolean var2_2, boolean var3_3, ExprKind var4_4, ExprKind var5_5, AtomicBoolean var6_6) {
            block169: {
                var7_7 = true;
                var8_8 = false;
                var9_9 = var4_4 != ExprKind.NONE && var4_4 != ExprKind.SCOPE;
                block0 : switch (var1_1.getExpID()) {
                    case 0: {
                        if (var2_2) {
                            this.lastType = this.getPredefinedType(var1_1);
                            this.staticOnly = false;
                            break;
                        }
                        var7_7 = false;
                        break;
                    }
                    case 1: {
                        switch (2.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[var1_1.getTokenID(0).ordinal()]) {
                            case 9: {
                                if (var2_2) {
                                    var10_10 = this.sup.getClass(var1_1.getTokenOffset(0));
                                    if (var10_10 == null) break block0;
                                    var6_6.set(true);
                                    this.lastType = CsmCompletion.getType((CsmClassifier)var10_10, 0, false, 0, false);
                                    this.staticOnly = false;
                                    break;
                                }
                                this.staticOnly = false;
                                break;
                            }
                            default: {
                                var10_10 = var1_1.getTokenText(0);
                                var11_20 = var1_1.getTokenOffset(0) + var1_1.getTokenLength(0);
                                if (var2_2) {
                                    if (var3_3 && !this.findType) {
                                        var12_28 = null;
                                        if (this.isConstructor) {
                                            this.compResolver.setResolveTypes(39322242);
                                        } else {
                                            this.compResolver.setResolveTypes(1);
                                        }
                                        if (this.resolve(var11_20, var10_10, this.openingSource)) {
                                            var12_28 = this.compResolver.getResult();
                                        }
                                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var12_28, var10_10 + '*', var1_1, var1_1.getTokenOffset(0), var1_1.getTokenLength(0), 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                        break;
                                    }
                                    if (var5_5 != ExprKind.SCOPE) {
                                        if (var2_2 && !this.findType) {
                                            this.lastType = this.findExactVarType(var10_10, var11_20);
                                        }
                                        if (this.lastType == null) {
                                            var12_29 = null;
                                            this.compResolver.setResolveTypes(1);
                                            if (this.resolve(var11_20, var10_10, true)) {
                                                var12_29 = this.compResolver.getResult();
                                                var13_39 = new ArrayList<E>();
                                                var12_29.addResulItemsToCol((Collection<? extends CsmObject>)var13_39);
                                                var14_48 = var13_39.iterator();
                                                while (var14_48.hasNext()) {
                                                    var15_59 = (CsmObject)var14_48.next();
                                                    if (CsmKindUtilities.isVariable((CsmObject)var15_59)) {
                                                        var16_64 /* !! */  = (CsmVariable)var15_59;
                                                        this.lastType = var16_64 /* !! */ .getType();
                                                    } else if (this.findType && CsmKindUtilities.isClassifier((CsmObject)var15_59)) {
                                                        this.lastType = CsmCompletion.getType((CsmClassifier)var15_59, 0, false, 0, false);
                                                    }
                                                    if (this.lastType == null) continue;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    if (this.lastType != null) {
                                        this.staticOnly = false;
                                        break;
                                    }
                                    if (var10_10.length() == 0) {
                                        this.lastNamespace = this.finder.getCsmFile().getProject().getGlobalNamespace();
                                        break;
                                    }
                                    this.compResolver.setResolveTypes(37749378);
                                    var12_30 = false;
                                    if (this.resolve(var11_20, var10_10, true) && !(var13_39 = this.compResolver.getResult().addResulItemsToCol(new ArrayList<E>())).isEmpty()) {
                                        this.lastType = null;
                                        var14_48 = null;
                                        var15_59 = var13_39.iterator();
                                        while (var15_59.hasNext()) {
                                            var16_64 /* !! */  = (CsmObject)var15_59.next();
                                            if (this.lastType != null || !CsmKindUtilities.isClassifier((CsmObject)var16_64 /* !! */ )) continue;
                                            if (var14_48 == null) {
                                                var14_48 = var16_64 /* !! */ ;
                                            }
                                            if (!CsmIncludeResolver.getDefault().isObjectVisible(this.contextFile, (CsmObject)var16_64 /* !! */ )) continue;
                                            this.lastType = CsmCompletion.getType((CsmClassifier)var16_64 /* !! */ , 0, false, 0, false);
                                            var12_30 = true;
                                            break;
                                        }
                                        if (this.lastType == null && var14_48 != null) {
                                            this.lastType = CsmCompletion.getType((CsmClassifier)var14_48, 0, false, 0, false);
                                        }
                                    }
                                    if (var12_30) break block0;
                                    var13_39 = this.compResolver.setResolveScope(QueryScope.GLOBAL_QUERY);
                                    this.compResolver.setResolveTypes(0x180000);
                                    if (this.resolve(var11_20, var10_10, true) && !(var14_48 = this.compResolver.getResult().addResulItemsToCol(new ArrayList<E>())).isEmpty()) {
                                        var15_59 = (CsmObject)var14_48.iterator().next();
                                        if (CsmKindUtilities.isNamespaceAlias((CsmObject)var15_59)) {
                                            this.lastNamespace = ((CsmNamespaceAlias)var15_59).getReferencedNamespace();
                                        } else if (CsmKindUtilities.isNamespace((Object)var15_59)) {
                                            this.lastNamespace = (CsmNamespace)var15_59;
                                        }
                                    }
                                    this.compResolver.setResolveScope((QueryScope)var13_39);
                                    if (this.lastNamespace == null) break block0;
                                    this.lastType = null;
                                    break;
                                }
                                var12_31 = true;
                                if (this.lastType != null) {
                                    var12_31 = false;
                                    if (this.findType || !var3_3) {
                                        var13_40 = false;
                                        var14_49 = this.lastType.getArrayDepth();
                                        if (this.staticOnly && !var14_49 && CsmKindUtilities.isClass((CsmObject)(var15_59 = CsmCompletionQuery.access$300(this.lastType, this.contextFile))) && (var17_73 = this.finder.findNestedClassifiers(this.contextElement, var16_64 /* !! */  = (CsmClass)var15_59, var10_10, true, true, this.sort)) != null && !var17_73.isEmpty()) {
                                            this.lastType = CsmCompletion.createType(var17_73.get(0), 0, 0, false);
                                            var13_40 = true;
                                        }
                                        if (!var13_40) {
                                            if (!var14_49 || var4_4 == ExprKind.ARROW) {
                                                var15_59 = CsmCompletionQuery.access$300(this.lastType, this.contextFile);
                                                if (CsmKindUtilities.isClass((CsmObject)var15_59)) {
                                                    var16_64 /* !! */  = (CsmClass)var15_59;
                                                    var17_73 = this.finder.findFields(this.contextElement, var16_64 /* !! */ , var10_10, true, this.staticOnly, true, true, this.scopeAccessedClassifier, this.sort);
                                                    if (var4_4 == ExprKind.ARROW || var4_4 == ExprKind.DOT) {
                                                        var18_79 = this.finder.findBaseClasses(this.contextElement, (CsmClassifier)var16_64 /* !! */ , var10_10, true, this.sort);
                                                        if (var17_73 == null) {
                                                            var17_73 = var18_79;
                                                        } else if (var18_79 != null) {
                                                            var17_73.addAll((Collection<CsmClass>)var18_79);
                                                        }
                                                    }
                                                    if (var17_73 != null && var17_73.size() > 0) {
                                                        var18_79 = (CsmObject)var17_73.get(0);
                                                        this.lastType = CsmCompletion.getObjectType((CsmObject)var18_79);
                                                        this.staticOnly = false;
                                                    } else if (var4_4 != ExprKind.ARROW) {
                                                        this.lastType = null;
                                                        var7_7 = false;
                                                    }
                                                } else {
                                                    this.lastType = null;
                                                    var7_7 = false;
                                                }
                                            } else {
                                                var7_7 = false;
                                            }
                                        }
                                    } else {
                                        this.scopeAccessedClassifier = var4_4 == ExprKind.SCOPE;
                                        var13_41 = this.extractLastTypeClassifier(var4_4);
                                        if (var13_41 == null) {
                                            this.lastType = null;
                                            var7_7 = false;
                                        } else {
                                            var14_49 = this.contextElement != null || this.scopeAccessedClassifier == false;
                                            var15_59 = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, var13_41, var10_10, this.openingSource, this.staticOnly != false && this.memberPointer == false, false, var14_49, this.scopeAccessedClassifier, var9_9, this.sort);
                                            var16_64 /* !! */  = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, var13_41, var10_10, this.openingSource, true, this.sort);
                                            var15_59.addAll(var16_64 /* !! */ );
                                            if (var4_4 == ExprKind.ARROW || var4_4 == ExprKind.DOT) {
                                                var17_73 = this.finder.findBaseClasses(this.contextElement, var13_41, var10_10, this.openingSource, this.sort);
                                                var15_59.addAll(var17_73);
                                            }
                                            if (var15_59.isEmpty() && this.scopeAccessedClassifier && this.lastNamespace != null) {
                                                var12_31 = true;
                                            } else {
                                                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), (Collection)var15_59, CsmCompletionQuery.access$500(this.lastType, true, true, false) + var10_10 + '*', var1_1, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                            }
                                        }
                                    }
                                }
                                if (this.lastNamespace == null || !var12_31) break block0;
                                var13_42 = (this.lastNamespace.isGlobal() != false ? "" : this.lastNamespace.getQualifiedName() + "::") + var10_10;
                                if (this.findType || !var3_3) {
                                    var14_50 = this.finder.findNestedNamespaces(this.lastNamespace, var10_10, true, false);
                                    v0 /* !! */  = var15_59 = var14_50.isEmpty() != false ? null : var14_50.get(0);
                                    if (var15_59 != null) {
                                        this.lastNamespace = var15_59;
                                        this.lastType = null;
                                        break;
                                    }
                                    var14_50 = this.finder.findNamespaceElements(this.lastNamespace, var10_10, true, false, true);
                                    var16_64 /* !! */  = var14_50.isEmpty() != false ? null : (CsmObject)var14_50.iterator().next();
                                    this.lastType = CsmCompletion.getObjectType((CsmObject)var16_64 /* !! */ );
                                    var7_7 = this.lastType != null;
                                    this.lastNamespace = null;
                                    break;
                                }
                                if (!var3_3) break block0;
                                var14_51 = this.finder.findNestedNamespaces(this.lastNamespace, var10_10, this.openingSource, false);
                                var14_51.addAll(this.finder.findNamespaceElements(this.lastNamespace, var10_10, this.openingSource, false, false));
                                var14_51.addAll(this.finder.findStaticNamespaceElements(this.lastNamespace, var10_10, this.openingSource));
                                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var14_51, var13_42 + '*', var1_1, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                break;
                            }
                        }
                        break;
                    }
                    case 7: {
                        this.lastType = this.resolveType(var1_1.getParameter(0));
                        var7_7 = false;
                        if (this.lastType == null || (var10_11 = CsmCompletionQuery.access$300(this.lastType, this.contextFile)) == null) break;
                        if (var1_1.getParameterCount() == 2) {
                            var11_21 = this.lastType.getPointerDepth();
                            var12_32 = this.lastType.getArrayDepth();
                            if (var11_21 > 0) {
                                this.lastType = CsmCompletion.getType(var10_11, var11_21, --var11_21 > 0, var12_32, this.lastType.isConst());
                            } else if (var12_32 > 0) {
                                this.lastType = CsmCompletion.getType(var10_11, var11_21, var11_21 > 0, --var12_32, this.lastType.isConst());
                            } else {
                                var13_43 = CsmCompletionQuery.access$600(var10_11, this.contextFile, CsmFunction.OperatorKind.ARRAY);
                                if (var13_43 != null) {
                                    this.lastType = var13_43.getReturnType();
                                }
                            }
                            var7_7 = true;
                            break;
                        }
                        this.lastType = CsmCompletion.getType(var10_11, this.lastType.getPointerDepth(), this.lastType.isPointer(), this.lastType.getArrayDepth() + 1, this.lastType.isConst());
                        var7_7 = true;
                        break;
                    }
                    case 16: {
                        this.lastType = CsmCompletion.BOOLEAN_TYPE;
                        break;
                    }
                    case 17: {
                        var10_12 = this.resolveType(var1_1.getParameter(0));
                        if (var10_12 == null) break;
                        this.lastType = var10_12;
                        var11_22 = CsmCompletionQuery.access$300(this.lastType, this.contextFile);
                        if (var11_22 == null || !CsmKindUtilities.isTemplate((CsmObject)var11_22) || (var12_33 = this.createInstantiation((CsmTemplate)var11_22, var1_1)) == null || !CsmKindUtilities.isClass((CsmObject)var12_33)) break;
                        this.lastType = CsmCompletion.createType((CsmClassifier)((CsmClass)var12_33), 0, 0, false);
                        break;
                    }
                    case 2: 
                    case 18: {
                        var10_13 = null;
                        var11_23 = new LinkedHashSet<CsmFunction>();
                        this.compResolver.setResolveTypes(0x800828);
                        var12_34 = "operator " + var1_1.getTokenText(0);
                        if (this.resolve(var1_1.getTokenOffset(0), var12_34, false)) {
                            var10_13 = this.compResolver.getResult();
                        }
                        var10_13.addResulItemsToCol((Collection<? extends CsmObject>)var11_23);
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var10_13, var12_34, var1_1, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        this.lastType = null;
                        block21 : switch (2.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[var1_1.getTokenID(0).ordinal()]) {
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: {
                                if (var1_1.getParameterCount() > 0) {
                                    this.lastType = this.resolveType(var1_1.getParameter(0));
                                    this.staticOnly = false;
                                    break;
                                }
                                break block169;
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 27: 
                            case 28: {
                                this.lastType = CsmCompletion.BOOLEAN_TYPE;
                            }
                            case 29: 
                            case 30: {
                                if (!this.findType || !var11_23.isEmpty() || this.lastType != null) ** GOTO lbl237
                                if (var1_1.getParameterCount() > 0) {
                                    this.lastType = this.resolveType(var1_1.getParameter(0));
                                    this.staticOnly = false;
                                    break;
                                }
                                break block169;
                            }
lbl237:
                            // 2 sources

                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: {
                                if (this.findType && !var11_23.isEmpty()) {
                                    var13_44 /* !! */  = this.getTypeList(var1_1, 0);
                                    var14_52 = CompletionSupport.filterMethods(var11_23, (List)var13_44 /* !! */ , false, false);
                                    if (var14_52.size() > 0) {
                                        var11_23 = var14_52;
                                        this.lastType = this.extractFunctionType((Collection<CsmFunction>)var11_23, null);
                                        break;
                                    }
                                    if (var1_1.getParameterCount() <= 0) break block0;
                                    this.lastType = this.resolveType(var1_1.getParameter(0));
                                    this.staticOnly = false;
                                    break;
                                }
                                if (this.lastType != null) {
                                    switch (var1_1.getParameterCount()) {
                                        case 2: {
                                            var13_44 /* !! */  = this.resolveType(var1_1.getParameter(0));
                                            var14_52 = this.resolveType(var1_1.getParameter(1));
                                            if (var13_44 /* !! */  == null || var14_52 == null || var13_44 /* !! */ .getArrayDepth() != 0 || var14_52.getArrayDepth() != 0 || !CsmCompletion.isPrimitiveClass(var13_44 /* !! */ .getClassifier()) || !CsmCompletion.isPrimitiveClass(var14_52.getClassifier())) break;
                                            this.lastType = this.sup.getCommonType(var13_44 /* !! */ , (CsmType)var14_52);
                                            break block21;
                                        }
                                        case 1: {
                                            var15_59 = this.resolveType(var1_1.getParameter(0));
                                            if (var15_59 == null || !CsmCompletion.isPrimitiveClass(var15_59.getClassifier())) break;
                                            this.lastType = var15_59;
                                        }
                                    }
                                    break;
                                }
                                break block169;
                            }
                            case 39: {
                                switch (var1_1.getParameterCount()) {
                                    case 2: {
                                        var13_44 /* !! */  = this.resolveType(var1_1.getParameter(0));
                                        var14_52 = this.resolveType(var1_1.getParameter(1));
                                        if (var13_44 /* !! */  == null || var14_52 == null) break;
                                        this.lastType = this.sup.getCommonType(var13_44 /* !! */ , (CsmType)var14_52);
                                        break block21;
                                    }
                                    case 1: {
                                        this.lastType = this.resolveType(var1_1.getParameter(0));
                                    }
                                }
                                break;
                            }
                            case 40: {
                                if (var1_1.getParameterCount() >= 2) {
                                    this.lastType = this.resolveType(var1_1.getParameter(1));
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (var1_1.getParameterCount() <= 0) break;
                        this.lastType = this.resolveType(var1_1.getParameter(0));
                        this.staticOnly = false;
                        break;
                    }
                    case 33: {
                        if (var1_1.getParameterCount() <= 0) break;
                        if (var1_1.getTokenCount() == 1) {
                            switch (2.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[var1_1.getTokenID(0).ordinal()]) {
                                case 35: {
                                    this.memberPointer = true;
                                }
                            }
                        }
                        var7_7 = this.resolveExp(var1_1.getParameter(0));
                        this.memberPointer = false;
                        break;
                    }
                    case 32: {
                        if (var1_1.getParameterCount() <= 0) break;
                        this.lastType = this.resolveType(var1_1.getParameter(0));
                        this.staticOnly = false;
                        var10_14 = null;
                        if (var1_1.getTokenCount() == 1) {
                            switch (2.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[var1_1.getTokenID(0).ordinal()]) {
                                case 35: {
                                    var10_14 = CsmFunction.OperatorKind.ADDRESS;
                                    break;
                                }
                                case 33: {
                                    var10_14 = CsmFunction.OperatorKind.POINTER;
                                }
                            }
                        }
                        if (var10_14 == null) break;
                        var11_24 = CsmCompletionQuery.access$400(this.lastType, this.contextFile, var10_14, 15);
                        if (var11_24 != null) {
                            this.lastType = var11_24;
                            break;
                        }
                        if (this.lastType == null) break;
                        var12_35 = this.lastType.getPointerDepth();
                        if (var12_35 > 0 && var10_14 == CsmFunction.OperatorKind.POINTER) {
                            --var12_35;
                        }
                        this.lastType = CsmCompletion.getType(CsmCompletionQuery.access$300(this.lastType, this.contextFile), var12_35, this.lastType.isReference(), this.lastType.getArrayDepth(), this.lastType.isConst());
                        break;
                    }
                    case 13: {
                        this.lastType = this.resolveType(var1_1.getParameter(0));
                        this.staticOnly = false;
                        break;
                    }
                    case 31: {
                        if (var1_1.getParameterCount() <= 0) break;
                        var10_15 = var1_1.getParameter(0);
                        this.staticOnly = false;
                        this.lastType = this.resolveType(var10_15);
                        if (this.lastType == null) break;
                        this.lastType = new CsmCompletion.BaseType(this.lastType.getClassifier(), this.lastType.getPointerDepth() + 1, this.lastType.isReference(), this.lastType.getArrayDepth(), this.lastType.isConst());
                        break;
                    }
                    case 14: {
                        if (this.findType) {
                            this.lastType = var1_1.getParameterCount() > 0 ? this.resolveType(var1_1.getParameter(0)) : this.getPredefinedType(var1_1);
                        }
                        if (this.findType && this.lastType != null || (var10_16 = var1_1.getTokenCount()) < 1) break;
                        var11_25 = var1_1.getTokenText(var10_16 - 1);
                        var12_36 = var1_1.getTokenOffset(var10_16 - 1);
                        this.compResolver.setResolveTypes(38273090);
                        if (!this.resolve(var12_36, var11_25, this.openingSource)) break;
                        var13_45 = this.compResolver.getResult();
                        if (this.findType) {
                            var14_53 = null;
                            var15_59 = new ArrayList<E>();
                            var13_45.addResulItemsToCol((Collection<? extends CsmObject>)var15_59);
                            var16_65 = var15_59.iterator();
                            while (var16_65.hasNext()) {
                                var17_74 = (CsmObject)var16_65.next();
                                if (CsmKindUtilities.isVariable((CsmObject)var17_74)) {
                                    this.lastType = ((CsmVariable)var17_74).getType();
                                    break;
                                }
                                if (!CsmKindUtilities.isClassifier((CsmObject)var17_74)) continue;
                                var14_53 = (CsmClassifier)var17_74;
                                break;
                            }
                            if (this.lastType == null && var14_53 != null) {
                                var16_66 = false;
                                for (var17_75 = 0; var17_75 < var1_1.getTokenCount() - 1; ++var17_75) {
                                    var16_66 |= var1_1.getTokenText(var17_75).equals("const");
                                }
                                this.lastType = CsmCompletion.getType(var14_53, 0, false, 0, var16_66);
                            }
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var13_45, var11_25 + '*', var1_1, var12_36, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    case 9: {
                        this.lastType = this.resolveType(var1_1.getParameter(var1_1.getParameterCount() - 1));
                        break;
                    }
                    case 12: {
                        this.isConstructor = true;
                        var7_7 = this.resolveExp(var1_1.getParameter(0));
                        this.staticOnly = false;
                        break;
                    }
                    case 10: {
                        var8_8 = true;
                    }
                    case 11: {
                        var10_17 = var1_1.getParameter(0);
                        var11_26 = null;
                        while (var10_17.getExpID() == 17) {
                            var11_26 = var10_17;
                            if (var10_17.getParameterCount() <= 0) break;
                            var10_17 = var10_17.getParameter(0);
                        }
                        var12_37 = var10_17.getTokenText(0);
                        var13_46 = var1_1.getParameter(0);
                        if (var13_46.getExpID() == 11) {
                            var14_54 = this.findType;
                            this.setFindType(true);
                            var7_7 = this.resolveExp(var13_46);
                            this.setFindType(var14_54);
                        }
                        if (this.isConstructor) {
                            var14_55 = null;
                            if (var2_2) {
                                var14_55 = CompletionSupport.getClassFromName(CsmCompletionQuery.this.getFinder(), var12_37, true);
                            }
                            if (var14_55 == null) {
                                var14_55 = this.findExactClass(var12_37, var10_17.getTokenOffset(0));
                            }
                            if (var14_55 != null) {
                                this.lastType = CsmCompletion.getType(var14_55, 0, false, 0, false);
                            } else {
                                this.isConstructor = false;
                            }
                        }
                        if (!var8_8 || this.openingSource) {
                            var14_56 = new LinkedHashSet<CsmFunction>();
                            if (var2_2 && (!this.isConstructor || this.lastType == null)) {
                                var15_60 = var10_17.getTokenOffset(0);
                                v1 = var16_67 = this.findType != false || this.openingSource != false;
                                if (var16_67) {
                                    var17_76 /* !! */  = new ArrayList<E>();
                                    this.compResolver.setResolveTypes(25167912);
                                    if (this.resolve(var15_60, var12_37, true)) {
                                        this.compResolver.getResult().addResulItemsToCol((Collection<? extends CsmObject>)var17_76 /* !! */ );
                                    }
                                    var18_79 = var17_76 /* !! */ .iterator();
                                    while (var18_79.hasNext()) {
                                        var19_81 = (CsmObject)var18_79.next();
                                        if (CsmKindUtilities.isClass((CsmObject)var19_81)) {
                                            var14_56.addAll(this.getConstructors((CsmClass)var19_81));
                                            continue;
                                        }
                                        if (!CsmKindUtilities.isFunction((CsmObject)var19_81)) continue;
                                        var14_56.add((CsmFunction)var19_81);
                                    }
                                }
                                this.compResolver.setResolveTypes(0x800828);
                                if (this.resolve(var15_60, var12_37, this.openingSource)) {
                                    this.compResolver.getResult().addResulItemsToCol(var14_56);
                                }
                                if (!var3_3 || this.findType) {
                                    var17_76 /* !! */  = new ArrayList<CsmFunction>();
                                    this.compResolver.setResolveTypes(1364);
                                    if (this.resolve(var15_60, var12_37, true)) {
                                        this.compResolver.getResult().addResulItemsToCol((Collection<? extends CsmObject>)var17_76 /* !! */ );
                                    }
                                    var18_79 = var17_76 /* !! */ .iterator();
                                    while (var18_79.hasNext()) {
                                        var19_81 = (CsmObject)var18_79.next();
                                        if (!CsmKindUtilities.isVariable((CsmObject)var19_81) || (var20_83 = ((CsmVariable)var19_81).getType()) == null || (var22_87 = (var21_85 = CsmCompletionQuery.access$300(var20_83, this.contextFile)) == null ? null : CsmCompletionQuery.access$600(var21_85, this.contextFile, CsmFunction.OperatorKind.CAST)) == null) continue;
                                        var14_56.add(var22_87);
                                    }
                                }
                                if (this.lastType != null && (!var3_3 || this.findType)) {
                                    var17_76 /* !! */  = CsmCompletionQuery.access$300(this.lastType, this.contextFile);
                                    v2 /* !! */  = var18_79 = var17_76 /* !! */  == null ? null : CsmCompletionQuery.access$600(var17_76 /* !! */ , this.contextFile, CsmFunction.OperatorKind.CAST);
                                    if (var18_79 != null) {
                                        var14_56.add((CsmFunction)var18_79);
                                    }
                                }
                            } else if (this.lastType != null) {
                                var15_61 = this.extractLastTypeClassifier(var4_4);
                                if (CsmKindUtilities.isClass((CsmObject)var15_61)) {
                                    var16_68 = this.contextElement != null;
                                    var14_56.addAll(this.finder.findMethods(this.contextElement, (CsmClass)var15_61, var12_37, true, false, var2_2, var16_68, this.scopeAccessedClassifier, this.sort));
                                    if (var14_56 == null || var14_56.size() == 0) {
                                        var17_77 = this.finder.findFields(this.contextElement, (CsmClass)var15_61, var12_37, true, false, var2_2, true, this.scopeAccessedClassifier, this.sort);
                                        if (var17_77 != null && !var17_77.isEmpty()) {
                                            if (!var3_3 || this.findType) {
                                                this.lastType = null;
                                                var18_80 = var17_77.iterator();
                                                while (var18_80.hasNext()) {
                                                    var19_82 = (CsmField)var18_80.next();
                                                    var20_84 = var19_82.getType();
                                                    if (var20_84 != null) {
                                                        if (CsmKindUtilities.isFunctionPointerType((CsmObject)var20_84)) {
                                                            this.lastType = var20_84;
                                                        } else {
                                                            var21_86 = var20_84.getClassifier();
                                                            if (CsmKindUtilities.isTypedef((CsmObject)var21_86) && CsmKindUtilities.isFunctionPointerType((CsmObject)(var22_88 /* !! */  = ((CsmTypedef)var21_86).getType()))) {
                                                                this.lastType = var20_84 = var22_88 /* !! */ ;
                                                            }
                                                        }
                                                    }
                                                    if (var20_84 == null || (var22_88 /* !! */  = (var21_86 = CsmCompletionQuery.access$300(var20_84, this.contextFile)) == null ? null : CsmCompletionQuery.access$600(var21_86, this.contextFile, CsmFunction.OperatorKind.CAST)) == null) continue;
                                                    this.lastType = var22_88 /* !! */ .getReturnType();
                                                }
                                            }
                                            if (var3_3 && (var19_82 = (var18_80 = var17_77.get(0)).getType()) != null && CsmKindUtilities.isTypedef((CsmObject)(var20_84 = var19_82.getClassifier())) && CsmKindUtilities.isFunctionPointerType((CsmObject)(var21_86 = ((CsmTypedef)var20_84).getType()))) {
                                                this.lastType = var19_82 = var21_86;
                                                var22_88 /* !! */  = this.getTypeList(var1_1, 1);
                                                var23_89 = CsmCompletionQuery.access$700((List)var22_88 /* !! */ , var8_8);
                                                var24_90 = new LinkedHashSet<CsmField>();
                                                var24_90.add(var18_80);
                                                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var24_90, CsmCompletionQuery.access$500(this.lastType, true, true, false) + var12_37 + '(' + var23_89 + ')', var1_1, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                            }
                                        }
                                        return this.lastType != null;
                                    }
                                }
                            } else if (this.lastNamespace != null) {
                                var15_62 = this.lastNamespace;
                                this.lastNamespace = null;
                                var16_69 = this.finder.findNestedNamespaces(var15_62, var12_37, this.openingSource, false);
                                var17_76 /* !! */  = var16_69.iterator();
                                if (var17_76 /* !! */ .hasNext()) {
                                    var18_79 = (CsmNamespace)var17_76 /* !! */ .next();
                                    this.lastNamespace = var18_79;
                                }
                                var17_76 /* !! */  = this.finder.findNamespaceElements(var15_62, var12_37, this.openingSource, false, false);
                                for (CsmObject var19_81 : var17_76 /* !! */ ) {
                                    if (CsmKindUtilities.isFunction((CsmObject)var19_81)) {
                                        var14_56.add((CsmFunction)var19_81);
                                        continue;
                                    }
                                    if (CsmKindUtilities.isTypedef((CsmObject)var19_81)) {
                                        this.lastType = ((CsmTypedef)var19_81).getType();
                                        break;
                                    }
                                    if (!CsmKindUtilities.isClassifier((CsmObject)var19_81)) continue;
                                    this.lastType = CsmCompletion.getType((CsmClassifier)var19_81, 0, false, 0, false);
                                    break;
                                }
                                if (this.findType && var14_56.isEmpty()) {
                                    return this.lastType != null || this.lastNamespace != null;
                                }
                            }
                            if (var14_56 == null || var14_56.size() == 0) {
                                if (!this.isConstructor) {
                                    if (var2_2) {
                                        var15_63 = null;
                                        if (var15_63 == null) {
                                            var15_63 = this.findExactClass(var12_37, var10_17.getTokenOffset(0));
                                        }
                                        if (var15_63 != null) {
                                            if (CsmKindUtilities.isTemplate(var15_63) && var11_26 != null && CsmKindUtilities.isClassifier((CsmObject)(var16_70 = this.createInstantiation((CsmTemplate)var15_63, var11_26)))) {
                                                var15_63 = (CsmClassifier)var16_70;
                                            }
                                            this.lastType = CsmCompletion.getType(var15_63, 0, false, 0, false);
                                        }
                                    } else {
                                        this.lastType = null;
                                    }
                                    if (this.lastType == null && (!var3_3 || this.findType)) {
                                        this.lastType = this.findBuiltInFunctionReturnType(var12_37, var10_17.getTokenOffset(0));
                                    }
                                }
                                return this.lastType != null;
                            }
                            var15_59 = "*";
                            var16_71 = this.getTypeList(var1_1, 1);
                            var17_76 /* !! */  = CompletionSupport.filterMethods(var14_56, var16_71, var8_8, true);
                            if (var17_76 /* !! */ .size() > 0) {
                                var14_56 = var17_76 /* !! */ ;
                                var15_59 = CsmCompletionQuery.access$700(var16_71, var8_8);
                            }
                            if (var14_56.size() > 0) {
                                if (var3_3 && !this.findType) {
                                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var14_56, CsmCompletionQuery.access$500(this.lastType, true, true, false) + var12_37 + '(' + (String)var15_59 + ')', var1_1, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                    break;
                                }
                                this.lastType = this.extractFunctionType(var14_56, var11_26);
                                this.staticOnly = false;
                                break;
                            }
                            this.lastType = null;
                            var7_7 = false;
                            break;
                        }
                        var14_57 = this.endOffset;
                        this.compResolver.setResolveTypes(1);
                        if (!this.resolve(var14_57, "", false)) break;
                        var15_59 = this.compResolver.getResult();
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), (CompletionResolver.Result)var15_59, var12_37 + '*', var10_17, var14_57, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    }
                }
            }
            if ((this.result == null || this.result.getItems().isEmpty()) && this.lastType != null && (this.lastType.isTemplateBased() || CsmFileReferences.isTemplateParameterInvolved((CsmObject)this.lastType) || CsmFileReferences.hasTemplateBasedAncestors((CsmType)this.lastType))) {
                var10_18 = new ArrayList<TemplateBasedReferencedObjectImpl>();
                var10_18.add(new TemplateBasedReferencedObjectImpl());
                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var10_18, "title", var1_1, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
            }
            if (var3_3 && !var2_2 && (this.result == null || this.result.getItems().isEmpty()) && this.lastType != null && CsmKindUtilities.isInstantiation((CsmObject)(var10_19 = CsmCompletionQuery.access$300(this.lastType, this.contextFile)))) {
                var11_27 = false;
                var12_38 = (CsmInstantiation)var10_19;
                var13_47 = var12_38.getMapping();
                for (Object var15_59 : var13_47.keySet()) {
                    var16_72 = (CsmSpecializationParameter)var13_47.get(var15_59);
                    if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)var16_72) || (var17_78 = ((CsmTypeBasedSpecializationParameter)var16_72).getType()) == null || !var17_78.isTemplateBased()) continue;
                    var11_27 = true;
                    break;
                }
                if (var11_27 && !CsmInstantiationProvider.getDefault().getSpecializations(var10_19, this.contextFile, this.endOffset).isEmpty()) {
                    var14_58 = new ArrayList<E>();
                    var14_58.add(new TemplateBasedReferencedObjectImpl());
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), var14_58, "title", var1_1, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                }
            }
            if (this.lastType == null && this.lastNamespace == null) {
                var7_7 = false;
            }
            return var7_7;
        }

        private CsmObject createInstantiation(CsmTemplate csmTemplate, CsmCompletionExpression csmCompletionExpression) {
            if (csmCompletionExpression.getExpID() == 17) {
                CsmCompletionExpression csmCompletionExpression2;
                int n;
                CsmInstantiationProvider csmInstantiationProvider = CsmInstantiationProvider.getDefault();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = csmTemplate.getTemplateParameters().size() < csmCompletionExpression.getParameterCount() - 1 ? csmTemplate.getTemplateParameters().size() : csmCompletionExpression.getParameterCount() - 1;
                block3: for (n = 0; n < n2 && (csmCompletionExpression2 = csmCompletionExpression.getParameter(n + 1)) != null; ++n) {
                    switch (csmCompletionExpression2.getExpID()) {
                        case 0: {
                            arrayList.add(csmInstantiationProvider.createExpressionBasedSpecializationParameter(csmCompletionExpression2.getTokenText(0), this.contextFile, csmCompletionExpression2.getTokenOffset(0), csmCompletionExpression2.getTokenOffset(0) + csmCompletionExpression2.getTokenLength(0)));
                            continue block3;
                        }
                        default: {
                            CsmType csmType = this.resolveType(csmCompletionExpression2);
                            if (csmType != null) {
                                arrayList.add(csmInstantiationProvider.createTypeBasedSpecializationParameter(csmType));
                                continue block3;
                            }
                            arrayList.add(csmInstantiationProvider.createExpressionBasedSpecializationParameter(csmCompletionExpression2.getTokenText(0), this.contextFile, csmCompletionExpression2.getTokenOffset(0), csmCompletionExpression2.getTokenOffset(0) + csmCompletionExpression2.getTokenLength(0)));
                        }
                    }
                }
                n = csmCompletionExpression.getTokenOffset(0);
                return csmInstantiationProvider.instantiate(csmTemplate, arrayList, CsmCompletionQuery.this.getFinder().getCsmFile(), n);
            }
            return null;
        }

        private CsmType findBuiltInFunctionReturnType(String string, int n) {
            CsmType csmType = null;
            if ("typeid".contentEquals(string)) {
                List<CsmClassifier> list;
                Iterator<CsmClassifier> iterator;
                CsmNamespace csmNamespace;
                CsmClassifier csmClassifier = CsmCompletionQuery.this.getFinder().getExactClassifier("std::type_info");
                if (csmClassifier == null && (csmNamespace = this.findExactNamespace("std", n)) != null && (iterator = (list = CsmCompletionQuery.this.getFinder().findClasses(csmNamespace, string, true, false)).iterator()).hasNext()) {
                    CsmClassifier csmClassifier2;
                    csmClassifier = csmClassifier2 = iterator.next();
                }
                if (csmClassifier != null) {
                    csmType = CsmCompletion.getType(csmClassifier, 0, false, 0, false);
                }
            }
            return csmType;
        }

        private CsmNamespace findExactNamespace(String string, int n) {
            CsmNamespace csmNamespace = null;
            this.compResolver.setResolveTypes(0x180000);
            if (this.resolve(n, string, true)) {
                CompletionResolver.Result result = this.compResolver.getResult();
                Collection<? extends CsmObject> collection = result.addResulItemsToCol(new ArrayList());
                for (CsmObject csmObject : collection) {
                    if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                        return (CsmNamespace)csmObject;
                    }
                    if (!CsmKindUtilities.isNamespaceAlias((CsmObject)csmObject) || (csmNamespace = ((CsmNamespaceAlias)csmObject).getReferencedNamespace()) == null) continue;
                    return csmNamespace;
                }
            }
            return csmNamespace;
        }

        private CsmClassifier findExactClass(String string, int n) {
            CsmClassifier csmClassifier = null;
            this.compResolver.setResolveTypes(0x400202);
            if (this.resolve(n, string, true)) {
                CompletionResolver.Result result = this.compResolver.getResult();
                Collection<? extends CsmObject> collection = result.addResulItemsToCol(new ArrayList());
                for (CsmObject csmObject : collection) {
                    if (CsmKindUtilities.isClassifier((CsmObject)csmObject)) {
                        csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)((CsmClassifier)csmObject), (CsmFile)this.contextFile);
                    }
                    if (csmClassifier == null) continue;
                    break;
                }
            }
            return csmClassifier;
        }

        private CsmType findExactVarType(String string, int n) {
            return this.sup.findExactVarType(this.finder.getCsmFile(), string, n, CsmCompletionQuery.this.getFileReferencesContext());
        }

        private List<CsmType> getTypeList(CsmCompletionExpression csmCompletionExpression, int n) {
            int n2 = csmCompletionExpression.getParameterCount();
            ArrayList<CsmType> arrayList = new ArrayList<CsmType>();
            if (n2 > n) {
                for (int i = n; i < n2; ++i) {
                    CsmCompletionExpression csmCompletionExpression2 = csmCompletionExpression.getParameter(i);
                    CsmType csmType = this.resolveType(csmCompletionExpression2);
                    arrayList.add(csmType);
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExprKind {
        NONE,
        SCOPE,
        ARROW,
        DOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryScope {
        LOCAL_QUERY,
        SMART_QUERY,
        GLOBAL_QUERY;

    }
}

