/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import org.netbeans.modules.vmd.game.dialog.AbstractImagePreviewComponent;
import org.netbeans.modules.vmd.game.model.ImageUtils;

public class PartialImageGridPreview
extends AbstractImagePreviewComponent {
    public static final boolean DEBUG = false;
    private static final int TILE_GAP = 4;
    private URL imageURL;
    private BufferedImage originalImage;
    private Image preview;
    private int tileWidth;
    private int tileHeight;

    public PartialImageGridPreview() {
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        Dimension dimension = new Dimension(50, 20);
        this.setMinimumSize(dimension);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PartialImageGridPreview.this.createPartialPreview();
                PartialImageGridPreview.this.repaint();
            }
        });
    }

    public void setImageURL(URL uRL) throws MalformedURLException, IllegalArgumentException {
        this.imageURL = uRL;
        if (uRL == null) {
            return;
        }
        BufferedImage bufferedImage = ImageUtils.loadImage(uRL);
        if (bufferedImage == null) {
            throw new IllegalArgumentException();
        }
        BufferedImage bufferedImage2 = new BufferedImage(((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        this.originalImage = bufferedImage2;
        this.tileWidth = this.originalImage.getWidth(this);
        this.tileHeight = this.originalImage.getHeight(this);
        this.createPartialPreview();
        this.repaint();
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public Image getImage() {
        return this.originalImage;
    }

    private void createPartialPreview() {
        if (this.originalImage == null) {
            return;
        }
        BufferedImage bufferedImage = null;
        int n = this.originalImage.getHeight(this) / this.tileHeight;
        int n2 = this.originalImage.getWidth(this) / this.tileWidth;
        if (n == 1 && n2 == 1) {
            this.preview = ImageUtils.getScaledImage(this.originalImage, this.getWidth(), this.getHeight());
            return;
        }
        if (n == 1 && n2 != 1) {
            int n3 = (this.getWidth() - 4) / 2;
            int n4 = this.getHeight();
            Image image = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, 0, this.tileWidth, this.tileHeight), n3, n4);
            Image image2 = ImageUtils.getScaledImage(this.originalImage.getSubimage(this.tileWidth, 0, this.tileWidth, this.tileHeight), n3, n4);
            bufferedImage = new BufferedImage(image.getWidth(this) * 2 + 4, image.getHeight(this), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, this);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(image.getWidth(this), 0, 4, image.getHeight(this) * 2 + 4);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(image.getWidth(this) + 1, 0, 2, image.getHeight(this) * 2 + 4);
            graphics2D.drawImage(image2, image.getWidth(this) + 4, 0, this);
        } else if (n != 1 && n2 == 1) {
            int n5 = this.getWidth();
            int n6 = (this.getHeight() - 4) / 2;
            Image image = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, 0, this.tileWidth, this.tileHeight), n5, n6);
            Image image3 = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, this.tileHeight, this.tileWidth, this.tileHeight), n5, n6);
            bufferedImage = new BufferedImage(image.getWidth(this), image.getHeight(this) * 2 + 4, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, this);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, image.getHeight(this), image.getWidth(this) * 2 + 4, 4);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, image.getHeight(this) + 1, image.getWidth(this) * 2 + 4, 2);
            graphics2D.drawImage(image3, 0, image.getHeight(this) + 4, this);
        } else {
            int n7 = (this.getWidth() - 4) / 2;
            int n8 = (this.getHeight() - 4) / 2;
            Image image = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, 0, this.tileWidth, this.tileHeight), n7, n8);
            Image image4 = ImageUtils.getScaledImage(this.originalImage.getSubimage(this.tileWidth, 0, this.tileWidth, this.tileHeight), n7, n8);
            Image image5 = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, this.tileHeight, this.tileWidth, this.tileHeight), n7, n8);
            Image image6 = ImageUtils.getScaledImage(this.originalImage.getSubimage(this.tileWidth, this.tileHeight, this.tileWidth, this.tileHeight), n7, n8);
            bufferedImage = new BufferedImage(image.getWidth(this) * 2 + 4, image.getHeight(this) * 2 + 4, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, this);
            graphics2D.drawImage(image4, image.getWidth(this) + 4, 0, this);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(image.getWidth(this), 0, 4, image.getHeight(this) * 2 + 4);
            graphics2D.fillRect(0, image.getHeight(this), image.getWidth(this) * 2 + 4, 4);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(image.getWidth(this) + 1, 0, 2, image.getHeight(this) * 2 + 4);
            graphics2D.fillRect(0, image.getHeight(this) + 1, image.getWidth(this) * 2 + 4, 2);
            graphics2D.drawImage(image5, 0, image.getHeight(this) + 4, this);
            graphics2D.drawImage(image6, image.getWidth(this) + 4, image.getHeight(this) + 4, this);
        }
        this.preview = bufferedImage;
    }

    public void setTileWidth(int n) {
        this.tileWidth = n;
        this.createPartialPreview();
        this.repaint();
    }

    public void setTileHeight(int n) {
        this.tileHeight = n;
        this.createPartialPreview();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        if (this.originalImage != null) {
            int n = (this.getWidth() - this.preview.getWidth(this)) / 2;
            int n2 = (this.getHeight() - this.preview.getHeight(this)) / 2;
            graphics.clearRect(0, 0, this.getWidth(), this.getWidth());
            graphics.drawImage(this.preview, n, n2, this);
        }
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }
}

