/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;

public class Right
extends DbObjectBase {
    public static final int SELECT = 1;
    public static final int DELETE = 2;
    public static final int INSERT = 4;
    public static final int UPDATE = 8;
    public static final int ALL = 15;
    private Role grantedRole;
    private int grantedRight;
    private Table grantedTable;
    private RightOwner grantee;

    public Right(Database database, int n, RightOwner rightOwner, Role role) {
        this.initDbObjectBase(database, n, "RIGHT_" + n, "user");
        this.grantee = rightOwner;
        this.grantedRole = role;
    }

    public Right(Database database, int n, RightOwner rightOwner, int n2, Table table) {
        this.initDbObjectBase(database, n, "" + n, "user");
        this.grantee = rightOwner;
        this.grantedRight = n2;
        this.grantedTable = table;
    }

    private boolean appendRight(StringBuffer stringBuffer, int n, int n2, String string, boolean bl) {
        if ((n & n2) != 0) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            return true;
        }
        return bl;
    }

    public String getRights() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.grantedRight == 15) {
            stringBuffer.append("ALL");
        } else {
            boolean bl = false;
            bl = this.appendRight(stringBuffer, this.grantedRight, 1, "SELECT", bl);
            bl = this.appendRight(stringBuffer, this.grantedRight, 2, "DELETE", bl);
            bl = this.appendRight(stringBuffer, this.grantedRight, 4, "INSERT", bl);
            this.appendRight(stringBuffer, this.grantedRight, 8, "UPDATE", bl);
        }
        return stringBuffer.toString();
    }

    public Role getGrantedRole() {
        return this.grantedRole;
    }

    public Table getGrantedTable() {
        return this.grantedTable;
    }

    public DbObject getGrantee() {
        return this.grantee;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GRANT ");
        if (this.grantedRole != null) {
            stringBuffer.append(this.grantedRole.getSQL());
        } else {
            stringBuffer.append(this.getRights());
            stringBuffer.append(" ON ");
            stringBuffer.append(table.getSQL());
        }
        stringBuffer.append(" TO ");
        stringBuffer.append(this.grantee.getSQL());
        return stringBuffer.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.grantedTable, null);
    }

    public int getType() {
        return 8;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        if (this.grantedTable != null) {
            this.grantee.revokeRight(this.grantedTable);
        } else {
            this.grantee.revokeRole(this.grantedRole);
        }
        this.database.removeMeta(session, this.getId());
        this.grantedRole = null;
        this.grantedTable = null;
        this.grantee = null;
        this.invalidate();
    }

    public void checkRename() {
        throw Message.getInternalError();
    }

    public void setRightMask(int n) {
        this.grantedRight = n;
    }

    public int getRightMask() {
        return this.grantedRight;
    }
}

