/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;

public class CVS
extends VersioningSystem
implements VersioningListener,
PreferenceChangeListener {
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File file, File file2) {
            File file3 = CVS.this.getTopmostManagedAncestor(file);
            File file4 = CVS.this.getTopmostManagedAncestor(file2);
            if (file3 == null || !file3.equals(file4)) {
                return false;
            }
            try {
                String string = Utils.getCVSRootFor(file);
                String string2 = Utils.getCVSRootFor(file2);
                String string3 = Utils.getCVSRootFor(file3);
                return string.equals(string2) && string.equals(string3);
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public File findRoot(File file) {
            return CVS.this.getTopmostManagedAncestor(file);
        }
    };

    public CVS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(CVS.class, (String)"CTL_CVS_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(CVS.class, (String)"CTL_CVS_MainMenu"));
        CvsVersioningSystem.getInstance().addVersioningListener(this);
        CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public File getTopmostManagedAncestor(File file) {
        return CvsVersioningSystem.getInstance().getTopmostManagedParent(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return CvsVersioningSystem.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return CvsVersioningSystem.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File file, File file2) {
        CvsVersioningSystem.getInstance().getOriginalFile(file, file2);
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)versioningEvent.getParams()[0];
            this.fireStatusChanged(file);
        } else if (versioningEvent.getId() == CvsVersioningSystem.EVENT_REFRESH_ANNOTATIONS) {
            this.fireStatusChanged(null);
        } else if (versioningEvent.getId() == CvsVersioningSystem.EVENT_VERSIONED_FILES_CHANGED) {
            this.fireVersionedFilesChanged();
        }
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        } else if (preferenceChangeEvent.getKey().startsWith("annotationsFormat")) {
            this.fireAnnotationsChanged(null);
        }
    }
}

