/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.PositionRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModificationResult {
    private Source js;
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();

    ModificationResult(Source source) {
        this.js = source;
    }

    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public List<? extends Difference> getDifferences(FileObject fileObject) {
        return this.diffs.get(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        try {
            for (Map.Entry<FileObject, List<Difference>> entry : this.diffs.entrySet()) {
                this.commit(entry.getKey(), entry.getValue(), null);
            }
        }
        finally {
            if (this.js != null) {
                this.js.revalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(FileObject fileObject, final List<Difference> list, Writer writer) throws IOException {
        final StyledDocument styledDocument = DataLoadersBridge.getDefault().getDocument(fileObject);
        if (styledDocument != null && writer == null) {
            final IOException[] iOExceptionArray = new IOException[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    for (Difference difference : list) {
                        if (difference.isExcluded()) continue;
                        try {
                            switch (difference.getKind()) {
                                case INSERT: {
                                    styledDocument.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                                    break;
                                }
                                case REMOVE: {
                                    styledDocument.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                                    break;
                                }
                                case CHANGE: {
                                    styledDocument.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                                    styledDocument.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            IOException iOException = new IOException();
                            iOException.initCause(badLocationException);
                            iOExceptionArray[0] = iOException;
                        }
                    }
                }
            };
            if (styledDocument instanceof BaseDocument) {
                ((BaseDocument)styledDocument).runAtomic(runnable);
            } else {
                runnable.run();
            }
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
            return;
        }
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Reader reader = null;
        try {
            int n;
            Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
            inputStream = fileObject.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            inputStream.close();
            inputStream = null;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n2 = this.convertToLF(byArray);
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), charset);
            if (writer == null) {
                writer = new OutputStreamWriter(fileObject.getOutputStream(), charset);
            }
            int n3 = 0;
            for (Difference difference : list) {
                int n4;
                if (difference.isExcluded()) continue;
                int n5 = difference.getStartPosition().getOffset();
                int n6 = n5 - n3;
                char[] cArray = new char[n6];
                int n7 = 0;
                while ((n4 = reader.read(cArray, 0, n6 - n7)) > 0 && n7 < n6) {
                    writer.write(cArray, 0, n4);
                    n7 += n4;
                    n3 += n4;
                }
                switch (difference.getKind()) {
                    case INSERT: {
                        writer.write(difference.getNewText());
                        break;
                    }
                    case REMOVE: {
                        int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n8);
                        n3 += n8;
                        break;
                    }
                    case CHANGE: {
                        int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n8);
                        n3 += n8;
                        writer.write(difference.getNewText());
                    }
                }
            }
            Object object = new char[1024];
            while ((n = reader.read((char[])object)) > 0) {
                writer.write((char[])object, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private int convertToLF(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 13) continue;
            byArray[n++] = byArray[i];
        }
        return n;
    }

    public String getResultingSource(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Provided fileObject is null";
        StringWriter stringWriter = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), stringWriter);
        return stringWriter.toString();
    }

    public static final class Difference {
        Kind kind;
        PositionRef startPos;
        PositionRef endPos;
        String oldText;
        String newText;
        String description;
        private boolean excluded;

        public Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2, String string3) {
            this.kind = kind;
            this.startPos = positionRef;
            this.endPos = positionRef2;
            this.oldText = string;
            this.newText = string2;
            this.description = string3;
            this.excluded = false;
        }

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2) {
            this(kind, positionRef, positionRef2, string, string2, null);
        }

        public Kind getKind() {
            return this.kind;
        }

        public PositionRef getStartPosition() {
            return this.startPos;
        }

        public PositionRef getEndPosition() {
            return this.endPos;
        }

        public String getOldText() {
            return this.oldText;
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void exclude(boolean bl) {
            this.excluded = bl;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public String getDescription() {
            return this.description;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE;

        }
    }
}

