/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.gsfret.hints.infrastructure.SuggestionsTask;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.support.SelectionAwareSourceTaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionHintsTask
extends ScanningCancellableTask<CompilationInfo> {
    @Override
    public void run(CompilationInfo compilationInfo) throws Exception {
        RuleContext ruleContext;
        this.resume();
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return;
        }
        if (GsfUtilities.isCodeTemplateEditing((Document)document)) {
            return;
        }
        int[] nArray = SelectionAwareSourceTaskFactory.getLastSelection(compilationInfo.getFileObject());
        if (nArray == null || nArray.length != 2 || nArray[0] == -1 || nArray[1] == -1) {
            return;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        Language language = SuggestionsTask.getHintsProviderLanguage(document, n);
        if (language == null) {
            return;
        }
        HintsProvider hintsProvider = language.getHintsProvider();
        assert (hintsProvider != null);
        GsfHintsManager gsfHintsManager = language.getHintsManager();
        if (gsfHintsManager == null) {
            return;
        }
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        ArrayList arrayList2 = new ArrayList();
        if (n != n2 && (ruleContext = gsfHintsManager.createRuleContext(compilationInfo, language, -1, n, n2)) != null) {
            hintsProvider.computeSelectionHints((HintsProvider.HintsManager)gsfHintsManager, ruleContext, arrayList2, Math.min(n, n2), Math.max(n, n2));
            for (Hint hint : arrayList2) {
                ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, false);
                arrayList.add(errorDescription);
            }
        }
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)SelectionHintsTask.class.getName(), arrayList);
    }
}

