/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.codetemplates;

import java.io.IOException;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.util.Exceptions;

public class GsfCodeTemplateProcessor
implements CodeTemplateProcessor {
    private CodeTemplateInsertRequest request;
    private CompilationInfo cInfo = null;

    private GsfCodeTemplateProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
        this.request = codeTemplateInsertRequest;
    }

    public synchronized void updateDefaultValues() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (CodeTemplateParameter codeTemplateParameter : this.request.getMasterParameters()) {
                CodeTemplateParameter codeTemplateParameter2 = codeTemplateParameter;
                String string = this.getProposedValue(codeTemplateParameter2);
                if (string == null || string.equals(codeTemplateParameter2.getValue())) continue;
                codeTemplateParameter2.setValue(string);
                bl = true;
            }
        }
    }

    public void parameterValueChanged(CodeTemplateParameter codeTemplateParameter, boolean bl) {
        if (bl) {
            for (CodeTemplateParameter codeTemplateParameter2 : this.request.getMasterParameters()) {
                String string;
                CodeTemplateParameter codeTemplateParameter3 = codeTemplateParameter2;
                if (codeTemplateParameter3.isUserModified() || (string = this.getProposedValue(codeTemplateParameter3)) == null || string.equals(codeTemplateParameter3.getValue())) continue;
                codeTemplateParameter3.setValue(string);
            }
        }
    }

    public void release() {
    }

    private String getProposedValue(CodeTemplateParameter codeTemplateParameter) {
        String string = codeTemplateParameter.getName();
        JTextComponent jTextComponent = this.request.getComponent();
        int n = jTextComponent.getCaret().getDot();
        String string2 = this.delegatedResolve(n, codeTemplateParameter.getName(), string, codeTemplateParameter.getHints());
        return string2;
    }

    private String delegatedResolve(int n, String string, String string2, Map map) {
        try {
            if (this.initParsing()) {
                CodeCompletionHandler codeCompletionHandler = GsfCompletionProvider.getCompletable(this.cInfo, n);
                if (codeCompletionHandler == null) {
                    return null;
                }
                return codeCompletionHandler.resolveTemplateVariable(string2, (org.netbeans.modules.gsf.api.CompilationInfo)this.cInfo, n, string, map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean initParsing() {
        if (this.cInfo == null) {
            BaseDocument baseDocument;
            JTextComponent jTextComponent = this.request.getComponent();
            Source source = Source.forDocument(jTextComponent.getDocument());
            if (jTextComponent.getDocument() instanceof BaseDocument && (baseDocument = (BaseDocument)jTextComponent.getDocument()).isAtomicLock()) {
                return false;
            }
            if (source != null) {
                try {
                    source.runUserActionTask(new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws IOException {
                            compilationController.toPhase(Phase.RESOLVED);
                            GsfCodeTemplateProcessor.this.cInfo = compilationController;
                        }
                    }, false);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.cInfo != null;
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
            return new GsfCodeTemplateProcessor(codeTemplateInsertRequest);
        }
    }
}

