/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.structure.APTMacroBaseNode;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;
import org.netbeans.modules.cnd.debug.DebugUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTDefineNode
extends APTMacroBaseNode
implements APTDefine,
Serializable {
    private static final long serialVersionUID = -99267816578145490L;
    private List<APTToken> params = null;
    private List<APTToken> bodyTokens = null;
    private volatile int stateAndHashCode = 0;
    private static final byte BEFORE_MACRO_NAME = 0;
    private static final byte AFTER_MACRO_NAME = 1;
    private static final byte IN_PARAMS = 2;
    private static final byte IN_BODY = 3;
    private static final byte IN_BODY_AFTER_SHARP = 4;
    private static final byte ERROR = 5;

    APTDefineNode(APTDefineNode aPTDefineNode) {
        super(aPTDefineNode);
        this.params = aPTDefineNode.params;
        this.bodyTokens = aPTDefineNode.bodyTokens;
        this.stateAndHashCode = aPTDefineNode.stateAndHashCode;
    }

    protected APTDefineNode() {
    }

    public APTDefineNode(APTToken aPTToken) {
        super(aPTToken);
    }

    @Override
    public final int getType() {
        return 5;
    }

    @Override
    public Collection<APTToken> getParams() {
        if (this.params == null) {
            return null;
        }
        return Collections.unmodifiableList(this.params);
    }

    @Override
    public boolean isFunctionLike() {
        return this.params != null;
    }

    @Override
    public List<APTToken> getBody() {
        return this.bodyTokens != null ? this.bodyTokens : Collections.emptyList();
    }

    @Override
    public boolean isValid() {
        return this.stateAndHashCode != 5;
    }

    @Override
    public boolean accept(APTFile aPTFile, APTToken aPTToken) {
        int n = aPTToken.getType();
        if (APTUtils.isEndDirectiveToken(n)) {
            if (this.bodyTokens != null) {
                ((ArrayList)this.bodyTokens).trimToSize();
            }
            if (this.params != null) {
                ((ArrayList)this.params).trimToSize();
            }
            if (this.stateAndHashCode == 0) {
                this.stateAndHashCode = 5;
            }
            return false;
        }
        block0 : switch (this.stateAndHashCode) {
            case 0: {
                boolean bl = super.accept(aPTFile, aPTToken);
                assert (bl);
                this.stateAndHashCode = 1;
                break;
            }
            case 1: {
                if (aPTToken.getType() == 210) {
                    this.params = new ArrayList<APTToken>();
                    this.stateAndHashCode = 2;
                    break;
                }
                if (this.bodyTokens == null) {
                    this.bodyTokens = new ArrayList<APTToken>();
                }
                this.bodyTokens.add(aPTToken);
                this.stateAndHashCode = 3;
                break;
            }
            case 2: {
                switch (aPTToken.getType()) {
                    case 205: {
                        this.params.add(aPTToken);
                        break block0;
                    }
                    case 139: {
                        this.stateAndHashCode = 3;
                        break block0;
                    }
                    case 6: {
                        this.params.add(APTUtils.VA_ARGS_TOKEN);
                        break block0;
                    }
                }
                if (aPTToken.getType() == 134 || APTUtils.isCommentToken(aPTToken.getType())) break;
                if (DebugUtils.STANDALONE) {
                    System.err.printf("%s, line %d: \"%s\" may not appear in macro parameter list\n", APTTraceUtils.toFileString(aPTFile), this.getToken().getLine(), aPTToken.getText());
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "{0} line {1}: {2} may not appear in macro parameter list", new Object[]{APTTraceUtils.toFileString(aPTFile), this.getToken().getLine(), aPTToken.getText()});
                }
                this.stateAndHashCode = 5;
                break;
            }
            case 3: {
                if (this.bodyTokens == null) {
                    this.bodyTokens = new ArrayList<APTToken>();
                }
                if (aPTToken.getType() == 183) {
                    this.stateAndHashCode = 4;
                }
                this.bodyTokens.add(aPTToken);
                break;
            }
            case 4: {
                this.bodyTokens.add(aPTToken);
                if (!APTUtils.isCommentToken(aPTToken.getType())) {
                    this.stateAndHashCode = aPTToken.getType() == 205 ? (this.isInParamList(aPTToken) ? 3 : 5) : 5;
                }
                if (this.stateAndHashCode != 5) break;
                if (DebugUtils.STANDALONE) {
                    System.err.printf("%s, line %d: '#' is not followed by a macro parameter\n", APTTraceUtils.toFileString(aPTFile), this.getToken().getLine());
                    break;
                }
                APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: '#' is not followed by a macro parameter", new Object[]{APTTraceUtils.toFileString(aPTFile), this.getToken().getLine()});
                break;
            }
            case 5: {
                break;
            }
            default: {
                assert (false) : "unexpected state";
                break;
            }
        }
        return true;
    }

    private boolean isInParamList(APTToken aPTToken) {
        assert (aPTToken != null);
        if (this.params == null) {
            return false;
        }
        for (APTToken aPTToken2 : this.params) {
            if (!aPTToken2.getTextID().equals(aPTToken.getTextID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        String string = super.getText();
        String string2 = "";
        if (this.params != null) {
            string2 = "PARAMS{" + APTUtils.toString(new ListBasedTokenStream(this.params)) + "}";
        }
        String string3 = this.bodyTokens != null ? "BODY{" + APTUtils.toString(new ListBasedTokenStream(this.getBody())) + "}" : "{NO BODY}";
        return string + string2 + string3;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        APTDefineNode aPTDefineNode = (APTDefineNode)object;
        if (!APTUtils.equalArrayLists(this.params, aPTDefineNode.params)) {
            return false;
        }
        return APTUtils.equalArrayLists(this.bodyTokens, aPTDefineNode.bodyTokens);
    }

    @Override
    public int hashCode() {
        int n = this.stateAndHashCode;
        if (0 <= n && n < 5) {
            n = super.hashCode();
            n = 37 * n + APTUtils.hash(this.params);
            n = 37 * n + APTUtils.hash(this.bodyTokens);
            if (0 <= (n = APTUtils.hash(n)) && n <= 5) {
                n += 10;
            }
            this.stateAndHashCode = n;
        }
        return n;
    }
}

