/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.EmbedEvalUnitImpl;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.EvalStaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedRubyRuntimeAdapterImpl
implements EmbedRubyRuntimeAdapter {
    private RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
    private ScriptingContainer container;

    public EmbedRubyRuntimeAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    public EmbedEvalUnit parse(String script, int ... lines2) {
        if (script == null) {
            return null;
        }
        boolean unicode_escape = false;
        Object obj = this.container.getAttribute((Object)AttributeName.UNICODE_ESCAPE);
        if (obj != null && obj instanceof Boolean) {
            unicode_escape = (Boolean)obj;
        }
        if (unicode_escape) {
            ReaderInputStream istream = new ReaderInputStream(new StringReader(script));
            return this.runParser(istream, null, lines2);
        }
        return this.runParser(script, null, lines2);
    }

    public EmbedEvalUnit parse(Reader reader, String filename2, int ... lines2) {
        if (reader != null) {
            ReaderInputStream istream = new ReaderInputStream(reader);
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    public EmbedEvalUnit parse(PathType type2, String filename2, int ... lines2) {
        if (filename2 == null) {
            return null;
        }
        if (type2 == null) {
            type2 = PathType.ABSOLUTE;
        }
        try {
            InputStream istream = null;
            switch (type2) {
                case ABSOLUTE: {
                    istream = new FileInputStream(filename2);
                    break;
                }
                case RELATIVE: {
                    String basedir = (String)this.container.getAttribute((Object)AttributeName.BASE_DIR);
                    if (basedir == null) {
                        basedir = SystemPropertyCatcher.getBaseDir();
                    }
                    String absolutePath = basedir + File.separator + filename2;
                    istream = new FileInputStream(absolutePath);
                    break;
                }
                case CLASSPATH: {
                    istream = this.container.getRuntime().getJRubyClassLoader().getResourceAsStream(filename2);
                }
            }
            return this.parse(istream, filename2, lines2);
        }
        catch (FileNotFoundException e) {
            Writer w = this.container.getErrorWriter();
            if (w instanceof PrintWriter) {
                e.printStackTrace((PrintWriter)w);
            } else {
                try {
                    w.write(e.getMessage());
                }
                catch (IOException ex) {
                    throw new ParseFailedException(ex);
                }
            }
            throw new ParseFailedException(e);
        }
    }

    public EmbedEvalUnit parse(InputStream istream, String filename2, int ... lines2) {
        if (istream != null) {
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    private EmbedEvalUnit runParser(Object input, String filename2, int ... lines2) {
        if (input == null) {
            return null;
        }
        if (filename2 == null || filename2.length() == 0) {
            filename2 = "<script>";
        }
        int line = 0;
        if (lines2 != null && lines2.length > 0) {
            line = lines2[0];
        }
        try {
            Ruby runtime2 = this.container.getRuntime();
            ManyVarsDynamicScope scope = this.getManyVarsDynamicScope(runtime2, 0);
            Node node = null;
            node = input instanceof String ? this.container.getRuntime().parseEval((String)input, filename2, (DynamicScope)scope, line) : this.container.getRuntime().parseFile((InputStream)input, filename2, scope, line);
            RubyInstanceConfig.CompileMode compileMode = runtime2.getInstanceConfig().getCompileMode();
            if (compileMode == RubyInstanceConfig.CompileMode.JIT || compileMode == RubyInstanceConfig.CompileMode.FORCE) {
                Script script = runtime2.tryCompile(node);
                EmbedEvalUnitImpl embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope, script);
                return embedEvalUnitImpl;
            }
            EmbedEvalUnitImpl embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope);
            return embedEvalUnitImpl;
        }
        catch (RaiseException e) {
            this.container.getRuntime().printError(e.getException());
            throw new ParseFailedException(e.getMessage(), e);
        }
        catch (Throwable e) {
            Writer w = this.container.getErrorWriter();
            if (w instanceof PrintWriter) {
                e.printStackTrace((PrintWriter)w);
            } else {
                try {
                    w.write(e.getMessage());
                }
                catch (IOException ex) {
                    throw new ParseFailedException(ex);
                }
            }
            throw new ParseFailedException(e);
        }
        finally {
            try {
                if (input instanceof InputStream) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException ex) {
                throw new ParseFailedException(ex);
            }
        }
    }

    ManyVarsDynamicScope getManyVarsDynamicScope(Ruby runtime2, int depth) {
        ThreadContext context = runtime2.getCurrentContext();
        DynamicScope currentScope = context.getCurrentScope();
        String[] names4Injection = this.container.getVarMap().getLocalVarNames();
        ManyVarsDynamicScope scope = names4Injection == null || names4Injection.length == 0 ? new ManyVarsDynamicScope(new EvalStaticScope(currentScope.getStaticScope()), currentScope) : new ManyVarsDynamicScope(new EvalStaticScope(currentScope.getStaticScope(), names4Injection), currentScope);
        return scope;
    }

    public IRubyObject eval(Ruby runtime2, String script) {
        return this.adapter.eval(runtime2, script);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime2, String script, String filename2, int lineNumber) {
        return this.adapter.parse(runtime2, script, filename2, lineNumber);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime2, InputStream istream, String filename2, int lineNumber) {
        return this.adapter.parse(runtime2, istream, filename2, lineNumber);
    }
}

