/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;

public class HyperlinkLabel
extends HTMLLabel {
    private Runnable actionPerformer;
    private String focusedText;
    private String normalText;

    public HyperlinkLabel(String string, String string2, Runnable runnable) {
        this.setFocusable(true);
        this.setHighlighter(null);
        this.setText(string, string2);
        this.actionPerformer = runnable;
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                HyperlinkLabel.this.setText(HyperlinkLabel.this.focusedText);
            }

            public void focusLost(FocusEvent focusEvent) {
                HyperlinkLabel.this.setText(HyperlinkLabel.this.normalText);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    HyperlinkLabel.this.actionPerformer.run();
                }
            }
        });
    }

    public void setText(String string, String string2) {
        this.normalText = string;
        this.focusedText = string2;
        this.setText(this.isFocusOwner() ? string2 : string);
    }

    public void setText(String string) {
        Font font = this.getFont();
        string = string.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
        string = string.replaceAll("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
        super.setText("<html><body style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + string + "</body></html>");
    }

    protected void showURL(URL uRL) {
        this.actionPerformer.run();
    }
}

