/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.openide.ErrorManager;

public abstract class CodeProfilingPoint
extends ProfilingPoint {
    static final String PROPERTY_LOCATION = "p_location";
    static final String PROPERTY_ANNOTATION = "p_annotation";

    CodeProfilingPoint(String string, Project project, ProfilingPointFactory profilingPointFactory) {
        super(string, project, profilingPointFactory);
    }

    public abstract RuntimeProfilingPoint[] createRuntimeProfilingPoints();

    public Location getLocation() {
        Annotation annotation = this.getAnnotations()[0];
        return annotation == null ? null : this.getLocation(annotation);
    }

    abstract Annotation[] getAnnotations();

    abstract void setLocation(Annotation var1, Location var2);

    abstract Location getLocation(Annotation var1);

    String getServerHandlerClassName() {
        return ((CodeProfilingPointFactory)this.getFactory()).getServerHandlerClassName();
    }

    String getServerInfo() {
        return null;
    }

    RuntimeProfilingPoint createRuntimeProfilingPoint(Location location) {
        ProfilingPointsManager profilingPointsManager = ProfilingPointsManager.getDefault();
        String string = Utils.getClassName(location);
        if (string == null) {
            return null;
        }
        return new RuntimeProfilingPoint(profilingPointsManager.createUniqueRuntimeProfilingPointIdentificator(), string, location.getLine(), location.getOffset(), this.getServerHandlerClassName(), this.getServerInfo());
    }

    abstract void hit(RuntimeProfilingPoint.HitEvent var1, int var2);

    void internalUpdateLocation(Annotation annotation, int n) {
        Location location = this.getLocation(annotation);
        if (location != null) {
            location.line = n;
        }
    }

    public static abstract class Annotation
    extends org.openide.text.Annotation {
        public abstract String getAnnotationType();

        public abstract String getShortDescription();

        void fireDescriptionChanged() {
            this.firePropertyChange("shortDescription", false, true);
        }

        void fireTypeChanged() {
            this.firePropertyChange("annotationType", false, true);
        }
    }

    public static final class Location {
        public static final String PROPERTY_LOCATION_FILE = "p_location_file";
        public static final String PROPERTY_LOCATION_LINE = "p_location_line";
        public static final String PROPERTY_LOCATION_OFFSET = "p_location_offset";
        public static final int OFFSET_START = Integer.MIN_VALUE;
        public static final int OFFSET_END = Integer.MAX_VALUE;
        public static final Location EMPTY = new Location("", 0, Integer.MIN_VALUE);
        private String file;
        private int line;
        private int offset;

        public Location(String string, int n, int n2) {
            this.file = string;
            this.line = n;
            this.offset = n2;
        }

        public String getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public boolean isLineEnd() {
            return this.getOffset() == Integer.MAX_VALUE;
        }

        public boolean isLineStart() {
            return this.getOffset() == Integer.MIN_VALUE;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Location)) {
                return false;
            }
            Location location = (Location)object;
            return this.file.equals(location.file) && this.line == location.line && this.offset == location.offset;
        }

        public static Location load(Project project, int n, Properties properties) {
            return Location.load(project, n, null, properties);
        }

        public static Location load(Project project, int n, String string, Properties properties) {
            String string2 = string == null ? n + "_" : n + "_" + string;
            String string3 = properties.getProperty(string2 + PROPERTY_LOCATION_FILE, null);
            String string4 = properties.getProperty(string2 + PROPERTY_LOCATION_LINE, null);
            String string5 = properties.getProperty(string2 + PROPERTY_LOCATION_OFFSET, null);
            if (string3 == null || string4 == null || string5 == null) {
                return null;
            }
            Location location = null;
            String string6 = Utils.getAbsolutePath(project, string3);
            try {
                location = new Location(string6, Integer.parseInt(string4), Integer.parseInt(string5));
            }
            catch (Exception exception) {
                ErrorManager.getDefault().log(65536, exception.getMessage());
            }
            return location;
        }

        public void store(Project project, int n, Properties properties) {
            this.store(project, n, null, properties);
        }

        public void store(Project project, int n, String string, Properties properties) {
            String string2 = string == null ? n + "_" : n + "_" + string;
            properties.put(string2 + PROPERTY_LOCATION_FILE, Utils.getRelativePath(project, this.file));
            properties.put(string2 + PROPERTY_LOCATION_LINE, Integer.toString(this.line));
            properties.put(string2 + PROPERTY_LOCATION_OFFSET, Integer.toString(this.offset));
        }

        public String toString() {
            return "File: " + this.getFile() + ", line: " + this.getLine() + ", offset: " + this.getOffset();
        }
    }

    public static abstract class Single
    extends CodeProfilingPoint {
        private Location location;

        Single(String string, Location location, Project project, ProfilingPointFactory profilingPointFactory) {
            super(string, project, profilingPointFactory);
            this.location = location;
        }

        public boolean isValid() {
            if (this.location == null) {
                return false;
            }
            String string = this.location.getFile();
            File file = new File(string);
            return string.endsWith(".java") && file.exists() && file.isFile();
        }

        public void setEnabled(boolean bl) {
            if (this.isEnabled() != bl) {
                super.setEnabled(bl);
                this.getAnnotation().fireTypeChanged();
            }
        }

        public void setLocation(Location location) {
            if (this.location.equals(location)) {
                return;
            }
            Annotation annotation = this.getAnnotation();
            Location location2 = this.location;
            this.location = location;
            Annotation annotation2 = this.getAnnotation();
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_ANNOTATION, new Annotation[]{annotation}, new Annotation[]{annotation2});
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_LOCATION, location2, location);
        }

        public Location getLocation() {
            return this.location;
        }

        public RuntimeProfilingPoint[] createRuntimeProfilingPoints() {
            RuntimeProfilingPoint runtimeProfilingPoint = this.createRuntimeProfilingPoint(this.getLocation());
            if (runtimeProfilingPoint == null) {
                return new RuntimeProfilingPoint[0];
            }
            return new RuntimeProfilingPoint[]{runtimeProfilingPoint};
        }

        protected abstract Annotation getAnnotation();

        Annotation[] getAnnotations() {
            return new Annotation[]{this.getAnnotation()};
        }

        public void setLocation(Annotation annotation, Location location) {
            if (((Object)((Object)annotation)).equals((Object)this.getAnnotation())) {
                this.setLocation(location);
            }
        }

        Location getLocation(Annotation annotation) {
            if (((Object)((Object)annotation)).equals((Object)this.getAnnotation())) {
                return this.getLocation();
            }
            return null;
        }
    }

    public static abstract class Paired
    extends CodeProfilingPoint {
        private Location endLocation;
        private Location startLocation;

        Paired(String string, Location location, Location location2, Project project, ProfilingPointFactory profilingPointFactory) {
            super(string, project, profilingPointFactory);
            this.startLocation = location;
            this.endLocation = location2;
        }

        public boolean isValid() {
            if (this.startLocation == null) {
                return false;
            }
            String string = this.startLocation.getFile();
            File file = new File(string);
            if (!(string.endsWith(".java") && file.exists() && file.isFile())) {
                return false;
            }
            if (!this.usesEndLocation()) {
                return true;
            }
            if (this.endLocation == null) {
                return false;
            }
            string = this.endLocation.getFile();
            file = new File(string);
            return string.endsWith(".java") && file.exists() && file.isFile();
        }

        public void setEnabled(boolean bl) {
            if (this.isEnabled() != bl) {
                super.setEnabled(bl);
                this.getStartAnnotation().fireTypeChanged();
                if (this.usesEndLocation()) {
                    this.getEndAnnotation().fireTypeChanged();
                }
            }
        }

        public void setEndLocation(Location location) {
            Annotation[] annotationArray;
            Annotation[] annotationArray2;
            if (this.endLocation == null && location == null || this.endLocation != null && this.endLocation.equals(location)) {
                return;
            }
            Annotation annotation = this.getEndAnnotation();
            Location location2 = this.endLocation;
            this.endLocation = location;
            Annotation annotation2 = this.getEndAnnotation();
            PropertyChangeSupport propertyChangeSupport = this.getChangeSupport();
            if (annotation == null) {
                annotationArray2 = new Annotation[]{};
            } else {
                Annotation[] annotationArray3 = new Annotation[1];
                annotationArray2 = annotationArray3;
                annotationArray3[0] = annotation;
            }
            if (annotation2 == null) {
                annotationArray = new Annotation[]{};
            } else {
                Annotation[] annotationArray4 = new Annotation[1];
                annotationArray = annotationArray4;
                annotationArray4[0] = annotation2;
            }
            propertyChangeSupport.firePropertyChange(CodeProfilingPoint.PROPERTY_ANNOTATION, annotationArray2, annotationArray);
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_LOCATION, location2 == null ? Location.EMPTY : location2, location == null ? Location.EMPTY : location);
        }

        public Location getEndLocation() {
            return this.endLocation;
        }

        public void setStartLocation(Location location) {
            if (this.startLocation.equals(location)) {
                return;
            }
            Annotation annotation = this.getStartAnnotation();
            Location location2 = this.startLocation;
            this.startLocation = location;
            Annotation annotation2 = this.getStartAnnotation();
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_ANNOTATION, new Annotation[]{annotation}, new Annotation[]{annotation2});
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_LOCATION, location2, location);
        }

        public Location getStartLocation() {
            return this.startLocation;
        }

        public RuntimeProfilingPoint[] createRuntimeProfilingPoints() {
            RuntimeProfilingPoint runtimeProfilingPoint = this.createRuntimeProfilingPoint(this.getStartLocation());
            if (runtimeProfilingPoint == null) {
                return new RuntimeProfilingPoint[0];
            }
            if (this.usesEndLocation()) {
                RuntimeProfilingPoint runtimeProfilingPoint2 = this.createRuntimeProfilingPoint(this.getEndLocation());
                if (runtimeProfilingPoint2 == null) {
                    return new RuntimeProfilingPoint[0];
                }
                return new RuntimeProfilingPoint[]{runtimeProfilingPoint, runtimeProfilingPoint2};
            }
            return new RuntimeProfilingPoint[]{runtimeProfilingPoint};
        }

        protected abstract Annotation getEndAnnotation();

        protected abstract Annotation getStartAnnotation();

        protected abstract boolean usesEndLocation();

        protected void timeAdjust(int n, long l, long l2) {
        }

        Annotation[] getAnnotations() {
            Annotation[] annotationArray;
            if (this.usesEndLocation()) {
                Annotation[] annotationArray2 = new Annotation[2];
                annotationArray2[0] = this.getStartAnnotation();
                annotationArray = annotationArray2;
                annotationArray2[1] = this.getEndAnnotation();
            } else {
                Annotation[] annotationArray3 = new Annotation[1];
                annotationArray = annotationArray3;
                annotationArray3[0] = this.getStartAnnotation();
            }
            return annotationArray;
        }

        public void setLocation(Annotation annotation, Location location) {
            if (((Object)((Object)annotation)).equals((Object)this.getStartAnnotation())) {
                this.setStartLocation(location);
            } else if (((Object)((Object)annotation)).equals((Object)this.getEndAnnotation())) {
                this.setEndLocation(location);
            }
        }

        Location getLocation(Annotation annotation) {
            if (((Object)((Object)annotation)).equals((Object)this.getStartAnnotation())) {
                return this.getStartLocation();
            }
            if (((Object)((Object)annotation)).equals((Object)this.getEndAnnotation())) {
                return this.getEndLocation();
            }
            return null;
        }
    }
}

