/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotReverseMemCallGraphPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.actions.FindAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class MemorySnapshotPanel
extends SnapshotPanel
implements ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final String MEMORY_RESULTS_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_MemoryResultsTabName");
    private static final String STACK_TRACES_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StackTracesTabName");
    private static final String INFO_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_InfoTabName");
    private static final String MEMORY_RESULTS_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_MemoryResultsTabDescr");
    private static final String STACK_TRACES_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StackTracesTabDescr");
    private static final String INFO_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_InfoTabDescr");
    private static final String PANEL_TITLE = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_PanelTitle");
    private static final String STRING_NOT_FOUND_MSG = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StringNotFoundMsg");
    private static final String FIND_ACTION_TOOLTIP = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_FindActionTooltip");
    private static final ImageIcon MEMORY_RESULTS_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/memoryResultsTab.png", (boolean)false);
    private static final ImageIcon INFO_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/infoTab.png", (boolean)false);
    private static final ImageIcon STACK_TRACES_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/stackTracesTab.png", (boolean)false);
    private JButton findActionPresenter;
    private JButton findNextPresenter;
    private JButton findPreviousPresenter;
    private JTabbedPane tabs = new JTabbedPane(3);
    private MemoryResultsPanel memoryPanel;
    private MemoryResultsSnapshot snapshot;
    private Project project;
    private SaveSnapshotAction saveAction;
    private SnapshotInfoPanel infoPanel;
    private SnapshotReverseMemCallGraphPanel reversePanel;

    public MemorySnapshotPanel(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        Object object;
        this.snapshot = (MemoryResultsSnapshot)loadedSnapshot.getSnapshot();
        this.project = loadedSnapshot.getProject();
        this.setLayout(new BorderLayout());
        SnapshotActionsHandler snapshotActionsHandler = new SnapshotActionsHandler();
        this.infoPanel = new SnapshotInfoPanel(loadedSnapshot);
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            this.memoryPanel = new SnapshotLivenessResultsPanel((LivenessMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)snapshotActionsHandler, loadedSnapshot.getSettings().getAllocTrackEvery());
            object = (SnapshotLivenessResultsPanel)this.memoryPanel;
            object.setSorting(n, bl);
            object.prepareResults();
        } else {
            this.memoryPanel = new SnapshotAllocResultsPanel((AllocMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)snapshotActionsHandler);
            object = (SnapshotAllocResultsPanel)this.memoryPanel;
            object.setSorting(n, bl);
            object.prepareResults();
        }
        this.infoPanel.updateInfo();
        this.tabs.addTab(MEMORY_RESULTS_TAB_NAME, MEMORY_RESULTS_TAB_ICON, (Component)this.memoryPanel, MEMORY_RESULTS_TAB_DESCR);
        if (this.snapshot.containsStacks()) {
            this.reversePanel = new SnapshotReverseMemCallGraphPanel(this.snapshot, (MemoryResUserActionsHandler)snapshotActionsHandler);
            this.reversePanel.prepareResults();
            this.tabs.addTab(STACK_TRACES_TAB_NAME, STACK_TRACES_TAB_ICON, (Component)this.reversePanel, STACK_TRACES_TAB_DESCR);
            this.tabs.setEnabledAt(this.tabs.getTabCount() - 1, false);
        }
        this.tabs.addTab(INFO_TAB_NAME, INFO_TAB_ICON, this.infoPanel, INFO_TAB_DESCR);
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        object = new JToolBar(){

            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                }
                return super.add(component);
            }
        };
        ((JToolBar)object).setFloatable(false);
        ((JComponent)object).putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.saveAction = new SaveSnapshotAction(loadedSnapshot);
        ((JToolBar)object).add(this.saveAction);
        ((JToolBar)object).add(new ExportAction(this, loadedSnapshot));
        ((JToolBar)object).add(new SaveViewAction(this));
        ((JToolBar)object).addSeparator();
        this.findActionPresenter = ((JToolBar)object).add((Action)SystemAction.get(FindAction.class));
        this.findPreviousPresenter = ((JToolBar)object).add(new FindPreviousAction(this));
        this.findNextPresenter = ((JToolBar)object).add(new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            JButton jButton = this.findActionPresenter;
            jButton.setIcon(Utils.FIND_ACTION_ICON);
            jButton.setText("");
            jButton.setToolTipText(FIND_ACTION_TOOLTIP);
        }
        ((JToolBar)object).addSeparator();
        ((JToolBar)object).add(new CompareSnapshotsAction(loadedSnapshot));
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        this.updateToolbar();
        this.add((Component)object, "North");
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemorySnapshotPanel.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemorySnapshotPanel.this.moveToNextSubTab();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemorySnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemorySnapshotPanel.this.performFindNext();
            }
        });
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }

    public BufferedImage getViewImage(boolean bl) {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.memoryPanel.getCurrentViewScreenshot(bl);
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.getCurrentViewScreenshot(bl);
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.infoPanel.getCurrentViewScreenshot(bl);
        }
        return null;
    }

    public String getViewName() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-memory_results";
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-allocation_stack_traces";
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-info";
        }
        return null;
    }

    public void displayStacksForClass(int n, int n2, boolean bl) {
        this.setReverseCallGraphClass(n, n2, bl);
        this.tabs.setSelectedComponent((Component)this.reversePanel);
    }

    public boolean fitsVisibleArea() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.memoryPanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.infoPanel.fitsVisibleArea();
        }
        return true;
    }

    public boolean hasView() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return true;
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    public void performFind() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
            if (this.reversePanel != null) {
                this.reversePanel.setFindString(string);
            }
            if (!this.memoryPanel.findFirst()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
            this.reversePanel.setFindString(string);
            if (!this.reversePanel.findFirst()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    public void performFindNext() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(string);
                }
            }
            if (!this.memoryPanel.findNext()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                this.reversePanel.setFindString(string);
            }
            if (!this.reversePanel.findNext()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    public void performFindPrevious() {
        String string;
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(string);
                }
            }
            if (!this.memoryPanel.findPrevious()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                this.reversePanel.setFindString(string);
            }
            if (!this.reversePanel.findPrevious()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    public void requestFocus() {
        if (this.memoryPanel != null) {
            this.memoryPanel.requestFocus();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateToolbar();
        if (this.tabs.getSelectedComponent() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MemorySnapshotPanel.this.tabs.getSelectedComponent().requestFocus();
                }
            });
        }
    }

    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot resultsSnapshot) {
        return "snapshot-" + resultsSnapshot.getTimeTaken();
    }

    private void setReverseCallGraphClass(int n, int n2, boolean bl) {
        this.reversePanel.setClassId(n);
        this.reversePanel.setSorting(n2, bl);
        this.reversePanel.prepareResults();
        this.tabs.setEnabledAt(this.tabs.indexOfTab(STACK_TRACES_TAB_NAME), true);
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void updateToolbar() {
        boolean bl = this.tabs.getSelectedComponent() != this.infoPanel && (this.tabs.getSelectedComponent() != this.reversePanel || !this.reversePanel.isEmpty());
        this.findActionPresenter.setEnabled(bl);
        this.findPreviousPresenter.setEnabled(bl);
        this.findNextPresenter.setEnabled(bl);
    }

    public void exportData(int n, ExportDataDumper exportDataDumper) {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (this.memoryPanel instanceof SnapshotAllocResultsPanel) {
                ((SnapshotAllocResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, MEMORY_RESULTS_TAB_NAME);
            } else if (this.memoryPanel instanceof SnapshotLivenessResultsPanel) {
                ((SnapshotLivenessResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, MEMORY_RESULTS_TAB_NAME);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            this.reversePanel.exportData(n, exportDataDumper, STACK_TRACES_TAB_NAME);
        }
    }

    public boolean hasLoadedSnapshot() {
        return this.snapshot != null;
    }

    public boolean hasExportableView() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return true;
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    private class SnapshotActionsHandler
    implements MemoryResUserActionsHandler {
        private SnapshotActionsHandler() {
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            if (string2 == null && string3 == null && (VMUtils.isVMPrimitiveType((String)string) || VMUtils.isPrimitiveType((String)string))) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(string) && "traceVMObjectAlloc".equals(string2)) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                NetBeansProfiler.getDefaultNB().openJavaSource(MemorySnapshotPanel.this.project, string, string2, string3);
            }
        }

        public void showStacksForClass(int n, int n2, boolean bl) {
            MemorySnapshotPanel.this.displayStacksForClass(n, n2, bl);
        }
    }
}

