/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.eecommon.api.XmlFileCreator;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.templates.SunDDWizardPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class SunDDWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new SunDDWizardPanel()};
            String[] stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        Set<FileObject> set = Collections.EMPTY_SET;
        SunDDWizardPanel sunDDWizardPanel = (SunDDWizardPanel)this.panels[0];
        File file = sunDDWizardPanel.getSelectedLocation();
        FileObject fileObject = FileUtil.createFolder((File)file);
        String string = sunDDWizardPanel.getFileName();
        if (fileObject != null) {
            String string2 = "org-netbeans-modules-j2ee-sun-ddui/" + string;
            FileObject fileObject2 = FileUtil.getConfigFile((String)string2);
            if (fileObject2 != null) {
                FileSystem fileSystem = fileObject.getFileSystem();
                XmlFileCreator xmlFileCreator = new XmlFileCreator(fileObject2, fileObject, fileObject2.getName(), fileObject2.getExt());
                fileSystem.runAtomicAction((FileSystem.AtomicAction)xmlFileCreator);
                FileObject fileObject3 = xmlFileCreator.getResult();
                if (fileObject3 != null) {
                    GlassfishConfiguration glassfishConfiguration = GlassfishConfiguration.getConfiguration((File)FileUtil.toFile((FileObject)fileObject3));
                    if (glassfishConfiguration != null) {
                        glassfishConfiguration.setAppServerVersion(glassfishConfiguration.getMaxASVersion());
                    } else {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SunDDWizardIterator.class, (String)"ERR_NoDeploymentConfiguration"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    set = Collections.singleton(xmlFileCreator.getResult());
                } else {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SunDDWizardIterator.class, (String)"ERR_FileCreationFailed", (Object)string), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            } else {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SunDDWizardIterator.class, (String)"ERR_TemplateNotFound", (Object)string2), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SunDDWizardIterator.class, (String)"ERR_LocationNotFound", (Object)file.getAbsolutePath()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return set;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }
}

