/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.Bitmask;
import org.netbeans.modules.vmd.midp.components.items.Constraints;
import org.netbeans.modules.vmd.midp.propertyeditors.Bundle;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorConstraints
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditorConstraints customEditor;
    private JRadioButton radioButton;
    private int bitMask;
    private Constraints constraints;
    private HashMap<Integer, Bitmask.BitmaskItem> bits;

    private PropertyEditorConstraints() {
        super(NbBundle.getMessage(PropertyEditorConstraints.class, (String)"LBL_CONSTR_UCLABEL"));
        this.initMap();
        this.initElements(Collections.singleton(this));
    }

    public static final PropertyEditorConstraints createInstance() {
        return new PropertyEditorConstraints();
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorConstraints.class, (String)"LBL_CONSTR_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorConstraints.class, (String)"ACSN_CONSTR_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorConstraints.class, (String)"ACSD_CONSTR_STR"));
        this.customEditor = new CustomEditorConstraints();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.customEditor = null;
        this.radioButton = null;
    }

    private void combineMaskWithGuiName(Integer n, Bitmask.BitmaskItem bitmaskItem) {
        this.bits.put(n, bitmaskItem);
    }

    void initMap() {
        this.bits = new HashMap();
        this.constraints = new Constraints(0);
        this.combineMaskWithGuiName(0, this.constraints.getBitmaskItem(0));
        this.combineMaskWithGuiName(65536, this.constraints.getBitmaskItem(65536));
        this.combineMaskWithGuiName(2, this.constraints.getBitmaskItem(2));
        this.combineMaskWithGuiName(131072, this.constraints.getBitmaskItem(131072));
        this.combineMaskWithGuiName(1, this.constraints.getBitmaskItem(1));
        this.combineMaskWithGuiName(262144, this.constraints.getBitmaskItem(262144));
        this.combineMaskWithGuiName(3, this.constraints.getBitmaskItem(3));
        this.combineMaskWithGuiName(524288, this.constraints.getBitmaskItem(524288));
        this.combineMaskWithGuiName(4, this.constraints.getBitmaskItem(4));
        this.combineMaskWithGuiName(0x100000, this.constraints.getBitmaskItem(0x100000));
        this.combineMaskWithGuiName(524288, this.constraints.getBitmaskItem(524288));
        this.combineMaskWithGuiName(5, this.constraints.getBitmaskItem(5));
        this.combineMaskWithGuiName(0x200000, this.constraints.getBitmaskItem(0x200000));
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        if (this.constraints == null) {
            return null;
        }
        this.setConstant(MidpTypes.getInteger((PropertyValue)super.getValue()));
        return this.getBitmaskAsText();
    }

    private void setConstant(int n) {
        this.constraints.setBitmask(n);
        this.bitMask = n;
    }

    private String getBitmaskAsText() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(" | ");
        for (int i = 0; i <= 5; ++i) {
            if (!this.constraints.isSet(this.bits.get(i)) || this.bits.get(i).getAffectedBits() > 5) continue;
            stringBuffer = new StringBuffer(this.bits.get(i).getName());
            stringBuffer.append(stringBuffer2);
        }
        for (int n : this.bits.keySet()) {
            if (!this.constraints.isSet(this.bits.get(n)) || this.bits.get(n).getAffectedBits() <= 5) continue;
            stringBuffer.append(this.bits.get(n).getName());
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(stringBuffer2.toString().trim()));
        return stringBuffer.toString();
    }

    public void setTextForPropertyValue(String string) {
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setBitmask(0);
        } else {
            this.customEditor.setBitmask(MidpTypes.getInteger(propertyValue));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue() {
        super.setValue((Object)MidpTypes.createIntegerValue(this.bitMask));
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
            this.customEditor = new CustomEditorConstraints();
        }
        return super.getCustomEditor();
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue();
        }
    }

    public Boolean canEditAsText() {
        return false;
    }

    private class CustomEditorConstraints
    extends JPanel
    implements ItemListener {
        private Map<JToggleButton, Bitmask.BitmaskItem> radioButtonsMap = new HashMap<JToggleButton, Bitmask.BitmaskItem>();
        private Map<JToggleButton, Bitmask.BitmaskItem> checkBoxesMap = new HashMap<JToggleButton, Bitmask.BitmaskItem>();
        private List<JToggleButton> guiItems = new ArrayList<JToggleButton>();
        private JRadioButton anyRadioButton;
        private JCheckBox passwordCheckBox;

        public CustomEditorConstraints() {
            this.initComponents();
        }

        void cleanUp() {
            PropertyEditorConstraints.this.constraints = null;
            this.radioButtonsMap.clear();
            this.radioButtonsMap = null;
            this.checkBoxesMap.clear();
            this.checkBoxesMap = null;
            this.guiItems.clear();
            this.guiItems = null;
            this.anyRadioButton = null;
            this.passwordCheckBox = null;
            this.removeAll();
        }

        private void initComponents() {
            ButtonGroup buttonGroup = new ButtonGroup();
            this.setLayout(new GridLayout(6, 2));
            this.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_TEXTFIELDPE_NAME")));
            this.anyRadioButton = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(0).getDisplayName());
            this.anyRadioButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_ANY"));
            buttonGroup.add(this.anyRadioButton);
            this.radioButtonsMap.put(this.anyRadioButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(0));
            this.guiItems.add(this.anyRadioButton);
            this.add(this.anyRadioButton);
            this.anyRadioButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintAny"));
            this.anyRadioButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintAny"));
            this.passwordCheckBox = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(65536).getDisplayName());
            this.passwordCheckBox.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_PASSWORD"));
            this.checkBoxesMap.put(this.passwordCheckBox, PropertyEditorConstraints.this.constraints.getBitmaskItem(65536));
            this.guiItems.add(this.passwordCheckBox);
            this.add(this.passwordCheckBox);
            this.passwordCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintPasswd"));
            this.passwordCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintPasswd"));
            JToggleButton jToggleButton = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(2).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_NUMERIC"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(2));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintNum"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintNum"));
            jToggleButton = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(131072).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_UNEDITABLE"));
            this.checkBoxesMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(131072));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintUnedit"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintUnedit"));
            jToggleButton = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(1).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_EMAIL"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(1));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintEmail"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintEmail"));
            jToggleButton = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(262144).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_SENSITIVE"));
            this.checkBoxesMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(262144));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintSensetive"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintSensetive"));
            jToggleButton = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(3).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_PHONE"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(3));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintPhone"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintPhone"));
            jToggleButton = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(524288).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_NONPREDICTIVE"));
            this.checkBoxesMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(524288));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintNonPredictive"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintNonPredictive"));
            jToggleButton = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(4).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_URL"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(4));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintUrl"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintUrl"));
            jToggleButton = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(0x100000).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_CAPS_WORD"));
            this.checkBoxesMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(0x100000));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintInitial_CAPS_WORD"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintInitial_CAPS_WORD"));
            jToggleButton = new JRadioButton(PropertyEditorConstraints.this.constraints.getBitmaskItem(5).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_DECIMAL"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(5));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintDec"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintDec"));
            jToggleButton = new JCheckBox(PropertyEditorConstraints.this.constraints.getBitmaskItem(0x200000).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_CAPS_SENTENCE"));
            this.checkBoxesMap.put(jToggleButton, PropertyEditorConstraints.this.constraints.getBitmaskItem(0x200000));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ContraintInitial_CAPS_SENTENCE"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ContraintInitial_CAPS_SENTENCE"));
            this.setGui();
            for (JToggleButton jToggleButton2 : this.guiItems) {
                jToggleButton2.addItemListener(this);
            }
        }

        public void setBitmask(int n) {
            for (JToggleButton jToggleButton : this.guiItems) {
                jToggleButton.removeItemListener(this);
            }
            PropertyEditorConstraints.this.constraints.setBitmask(n);
            this.setGui();
            for (JToggleButton jToggleButton : this.guiItems) {
                jToggleButton.addItemListener(this);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            PropertyEditorConstraints.this.constraints.setBitmask(0);
            for (JToggleButton jToggleButton : this.radioButtonsMap.keySet()) {
                if (!jToggleButton.isSelected()) continue;
                PropertyEditorConstraints.this.constraints.addToBitmask(this.radioButtonsMap.get(jToggleButton), true);
            }
            for (JToggleButton jToggleButton : this.checkBoxesMap.keySet()) {
                if (!jToggleButton.isSelected()) continue;
                PropertyEditorConstraints.this.constraints.addToBitmask(this.checkBoxesMap.get(jToggleButton), true);
            }
            PropertyEditorConstraints.this.bitMask = PropertyEditorConstraints.this.constraints.getBitmask();
        }

        private void setGui() {
            int n = 0;
            for (JToggleButton jToggleButton : this.radioButtonsMap.keySet()) {
                if (!PropertyEditorConstraints.this.constraints.isSet(this.radioButtonsMap.get(jToggleButton)) || n > this.radioButtonsMap.get(jToggleButton).getAffectedBits()) continue;
                n = this.radioButtonsMap.get(jToggleButton).getAffectedBits();
                jToggleButton.setSelected(true);
            }
            for (JToggleButton jToggleButton : this.checkBoxesMap.keySet()) {
                if (!PropertyEditorConstraints.this.constraints.isSet(this.checkBoxesMap.get(jToggleButton))) continue;
                jToggleButton.setSelected(true);
            }
        }
    }
}

