/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.elements;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ElementSupport {
    private static final InfoPresenter.Resolver LIST_ELEMENT_RESOLVER = new ElementResolver("string", "org/netbeans/modules/vmd/midp/resources/components/element_16.png");
    private static final InfoPresenter.Resolver CHOICE_ELEMENT_RESOLVER = new ElementResolver("string", "org/netbeans/modules/vmd/midp/resources/components/element_16.png");

    public static InfoPresenter.Resolver createListElementInfoResolver() {
        return LIST_ELEMENT_RESOLVER;
    }

    static InfoPresenter.Resolver createChoiceElementInfoResolver() {
        return CHOICE_ELEMENT_RESOLVER;
    }

    private static class ElementResolver
    implements InfoPresenter.Resolver {
        private String propertyName;
        private Image icon;

        private ElementResolver(String string, String string2) {
            this.propertyName = string;
            this.icon = ImageUtilities.loadImage((String)string2);
        }

        public DesignEventFilter getEventFilter(DesignComponent designComponent) {
            return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(designComponent, false);
        }

        public String getDisplayName(DesignComponent designComponent, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return this.resolveName(designComponent);
                }
                case SECONDARY: {
                    return NbBundle.getMessage(ElementSupport.class, (String)"TYPE_Element");
                }
                case TERTIARY: {
                    return null;
                }
            }
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private String resolveName(DesignComponent designComponent) {
            return MidpValueSupport.getHumanReadableString(designComponent.readProperty(this.propertyName));
        }

        public boolean isEditable(DesignComponent designComponent) {
            return true;
        }

        public String getEditableName(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty(this.propertyName);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                return MidpTypes.getString(propertyValue);
            }
            return "";
        }

        public void setEditableName(DesignComponent designComponent, String string) {
            assert (string != null);
            designComponent.writeProperty(this.propertyName, MidpTypes.createStringValue(string));
        }

        public Image getIcon(DesignComponent designComponent, InfoPresenter.IconType iconType) {
            return iconType == InfoPresenter.IconType.COLOR_16x16 ? this.icon : null;
        }
    }
}

