/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.analyzer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesAnalyzerPanel
extends JPanel {
    private DesignDocument document;
    private Map<Long, String> resourceNames;
    private Map<Long, Icon> resourceIcons;
    private List<Long> resourceIDs;
    private Icon resourceIcon = new ImageIcon("org/netbeans/modules/vmd/midp/resources/components/resource_16.png");
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JList resourcesList;

    ResourcesAnalyzerPanel() {
        this.initComponents();
        this.resourceIDs = new ArrayList<Long>();
        this.resourceNames = new HashMap<Long, String>();
        this.resourceIcons = new HashMap<Long, Icon>();
        this.resourcesList.setCellRenderer(new ResourcesListRenderer());
    }

    void setUnusedResources(DesignDocument designDocument, List<DesignComponent> list) {
        Collections.sort(list, new Comparator<DesignComponent>(){

            @Override
            public int compare(DesignComponent designComponent, DesignComponent designComponent2) {
                int n = designComponent.getType().toString().compareToIgnoreCase(designComponent2.getType().toString());
                if (n != 0) {
                    return n;
                }
                String string = InfoPresenter.getDisplayName((DesignComponent)designComponent);
                String string2 = InfoPresenter.getDisplayName((DesignComponent)designComponent2);
                if (string != null) {
                    n = string.compareToIgnoreCase(string2);
                    if (n != 0) {
                        return n;
                    }
                    return string.compareTo(string2);
                }
                return string2 != null ? 1 : 0;
            }
        });
        if (list.size() == this.resourceIDs.size()) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getComponentID() != this.resourceIDs.get(i).longValue()) continue;
                return;
            }
        }
        this.resourceIDs.clear();
        this.resourceNames.clear();
        this.resourceIcons.clear();
        this.document = designDocument;
        ((DefaultListModel)this.resourcesList.getModel()).removeAllElements();
        if (list.isEmpty()) {
            ((DefaultListModel)this.resourcesList.getModel()).addElement(NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzer.nothing-found"));
            this.resourcesList.clearSelection();
        } else {
            for (DesignComponent designComponent : list) {
                Image image;
                String string;
                this.resourceIDs.add(designComponent.getComponentID());
                InfoPresenter infoPresenter = (InfoPresenter)designComponent.getPresenter(InfoPresenter.class);
                if (infoPresenter != null) {
                    string = infoPresenter.getDisplayName(InfoPresenter.NameType.PRIMARY);
                    image = infoPresenter.getIcon(InfoPresenter.IconType.COLOR_16x16);
                } else {
                    Debug.warning((Object[])new Object[]{"Missing InfoPresenter for", designComponent});
                    string = NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzer.no-label");
                    image = null;
                }
                this.resourceNames.put(designComponent.getComponentID(), string);
                this.resourceIcons.put(designComponent.getComponentID(), image != null ? new ImageIcon(image) : this.resourceIcon);
                ((DefaultListModel)this.resourcesList.getModel()).addElement(designComponent.getComponentID());
            }
            int n = this.resourcesList.getModel().getSize();
            if (n > 0) {
                this.resourcesList.setSelectionInterval(0, n - 1);
            }
        }
    }

    private void removeUnusedResources(final Object[] objectArray) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                for (Object object : objectArray) {
                    if (!(object instanceof Long)) continue;
                    DesignComponent designComponent = ResourcesAnalyzerPanel.this.document.getComponentByUID(((Long)object).longValue());
                    if (designComponent != null) {
                        DeleteSupport.invokeDirectUserDeletion((DesignDocument)ResourcesAnalyzerPanel.this.document, Collections.singleton(designComponent), (boolean)false);
                    }
                    ((DefaultListModel)ResourcesAnalyzerPanel.this.resourcesList.getModel()).removeElement(object);
                }
            }
        });
        if (this.resourcesList.getModel().getSize() == 0) {
            ((DefaultListModel)this.resourcesList.getModel()).addElement(NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzer.nothing-found"));
        }
    }

    private void initComponents() {
        this.removeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.resourcesList = new JList();
        this.setPreferredSize(new Dimension(400, 150));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzerPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesAnalyzerPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.resourcesList.setModel(new DefaultListModel());
        this.jScrollPane1.setViewportView(this.resourcesList);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 279, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.removeButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.removeButton).addContainerGap(127, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 150, Short.MAX_VALUE));
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.removeUnusedResources(this.resourcesList.getSelectedValues());
    }

    private class ResourcesListRenderer
    extends DefaultListCellRenderer {
        private ResourcesListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (ResourcesAnalyzerPanel.this.document != null && object instanceof Long) {
                jLabel.setText((String)ResourcesAnalyzerPanel.this.resourceNames.get((Long)object));
                jLabel.setIcon((Icon)ResourcesAnalyzerPanel.this.resourceIcons.get((Long)object));
            }
            return jLabel;
        }
    }
}

