/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.introduce.ErrorLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceVariablePanel
extends JPanel {
    private boolean introduceConstant;
    private Set<String> takenNames;
    private JButton btnOk;
    private ButtonGroup accessGroup;
    private JLabel errorLabel;
    private JLabel lblName;
    private JTextField name;
    private JCheckBox replaceAll;

    public IntroduceVariablePanel(int n, String string, boolean bl, JButton jButton, Set<String> set) {
        this.btnOk = jButton;
        this.takenNames = set;
        this.initComponents();
        this.introduceConstant = bl;
        Preferences preferences = this.getPreferences(bl);
        if (n == 1) {
            this.replaceAll.setEnabled(false);
            this.replaceAll.setSelected(false);
        } else {
            this.replaceAll.setEnabled(true);
            this.replaceAll.setText(this.replaceAll.getText() + " (" + n + ")");
            this.replaceAll.setSelected(preferences.getBoolean("replaceAll", true));
        }
        this.replaceAll.setVisible(n > 1);
        this.name.setText(string);
        if (this.name != null && string.trim().length() > 0) {
            this.name.setCaretPosition(string.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(string.length());
        }
    }

    private Preferences getPreferences(boolean bl) {
        return NbPreferences.forModule(IntroduceVariablePanel.class).node(bl ? "introduceConstant" : "introduceVariable");
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            public String validate(String string) {
                if (null == string || string.length() == 0) {
                    return "";
                }
                if (!RubyUtils.isValidRubyIdentifier((String)string)) {
                    return IntroduceVariablePanel.this.getDefaultErrorMessage(string);
                }
                if (IntroduceVariablePanel.this.takenNames.contains(string)) {
                    return NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LocalAlreadyExists", (Object)string);
                }
                return null;
            }
        };
        final ErrorLabel errorLabel = new ErrorLabel(this.name.getDocument(), validator);
        errorLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntroduceVariablePanel.this.btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        this.btnOk.setEnabled(errorLabel.isInputTextValid());
        return errorLabel;
    }

    String getDefaultErrorMessage(String string) {
        return NbBundle.getMessage(IntroduceVariablePanel.class, (String)(this.introduceConstant ? "ConstantAlreadyExists" : "NotValidIdentifier"), (Object)string);
    }

    private void initComponents() {
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.replaceAll = new JCheckBox();
        this.errorLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAll, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_ReplaceAll"));
        this.replaceAll.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel, -1, 483, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblName).add(18, 18, 18).add((Component)this.name, -1, 425, Short.MAX_VALUE)).add((Component)this.replaceAll)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.name, -2, -1, -2)).addPreferredGap(1).add((Component)this.replaceAll).addPreferredGap(0, 64, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Name"));
        this.replaceAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_ReplaceAllOccurences"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Dialog"));
    }

    public String getVariableName() {
        return this.name.getText();
    }

    public boolean isReplaceAll() {
        boolean bl = this.replaceAll.isSelected();
        this.getPreferences(this.introduceConstant).putBoolean("replaceAll", bl);
        return bl;
    }

    void setVariableName(String string) {
        this.name.setText(string);
    }

    void setReplaceAll(boolean bl) {
        this.replaceAll.setSelected(bl);
    }
}

