/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

public final class MacroExpansionTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(MacroExpansionTopComponent.class.getName());
    private static MacroExpansionTopComponent instance;
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/macroview/resources/macroexpansion.png";
    private static final String PREFERRED_ID = "MacroExpansionTopComponent";
    private MacroExpansionPanel panel = null;
    private int lastDividerLocation = -1;
    private boolean lastSyncCaretAndContext = true;
    private boolean lastLocalContext = true;
    private Document lastExpandedContextDoc = null;
    private JButton jButton1;

    private MacroExpansionTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"HINT_MacroExpansionTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    public void setDocuments(Document document, Document document2) {
        this.lastExpandedContextDoc = document;
        if (this.panel != null) {
            this.lastDividerLocation = this.panel.getDividerLocation();
            this.lastSyncCaretAndContext = this.panel.isSyncCaretAndContext();
            this.lastLocalContext = this.panel.isLocalContext();
        }
        this.panel = new MacroExpansionPanel(true);
        this.panel.setContextExpansionDocument(document);
        this.panel.setMacroExpansionDocument(document2);
        if (this.lastDividerLocation != -1) {
            this.panel.setDividerLocation(this.lastDividerLocation);
        }
        this.panel.setLocalContext(MacroExpansionTopComponent.isLocalContext());
        this.panel.setSyncCaretAndContext(this.lastSyncCaretAndContext);
        this.panel.setLocalContext(this.lastLocalContext);
        if (this.panel.isSyncCaretAndContext()) {
            this.panel.updateCaretPosition();
        }
        this.removeAll();
        this.add(this.panel, "Center");
        this.validate();
        OpenedEditors.getDefault().fireStateChanged();
    }

    public void updateCaretPosition() {
        if (this.panel != null) {
            this.panel.updateCaretPosition();
        }
    }

    public static boolean isLocalContext() {
        return NbPreferences.forModule(MacroExpansionTopComponent.class).getBoolean("show-local-context", true);
    }

    public static void setLocalContext(boolean bl) {
        NbPreferences.forModule(MacroExpansionTopComponent.class).putBoolean("show-local-context", bl);
    }

    public Document getExpandedContextDoc() {
        return this.lastExpandedContextDoc;
    }

    public void setStatusBarText(String string) {
        if (this.panel != null) {
            this.panel.setStatusBarText(string);
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"NoViewAvailable"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setEnabled(false);
        this.add(this.jButton1, "Center");
    }

    public static synchronized MacroExpansionTopComponent getDefault() {
        if (instance == null) {
            instance = new MacroExpansionTopComponent();
        }
        return instance;
    }

    public static synchronized MacroExpansionTopComponent findInstance() {
        TopComponent topComponent = CsmUtilities.getTopComponentInEQ((String)PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(MacroExpansionTopComponent.class.getName()).warning("Cannot find MacroExpansionTopComponent component. It will not be located properly in the window system.");
            return MacroExpansionTopComponent.getDefault();
        }
        if (topComponent instanceof MacroExpansionTopComponent) {
            return (MacroExpansionTopComponent)topComponent;
        }
        Logger.getLogger(MacroExpansionTopComponent.class.getName()).warning("There seem to be multiple components with the 'MacroExpansionTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return MacroExpansionTopComponent.getDefault();
    }

    public void requestActive() {
        super.requestActive();
        if (this.panel != null) {
            this.panel.requestFocusInWindow();
        }
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentClosed() {
        this.removeAll();
        this.initComponents();
        if (this.panel != null) {
            Document document;
            this.lastDividerLocation = this.panel.getDividerLocation();
            this.lastSyncCaretAndContext = this.panel.isSyncCaretAndContext();
            this.lastLocalContext = this.panel.isLocalContext();
            Document document2 = this.getExpandedContextDoc();
            if (document2 != null && (document = (Document)document2.getProperty(Document.class)) != null) {
                document.putProperty(Document.class, null);
            }
            this.panel = null;
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return MacroExpansionTopComponent.getDefault();
        }
    }
}

