/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.jsf.refactoring.Modifications;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class DiffElement
extends SimpleRefactoringElementImplementation {
    private final Modifications.Difference diff;
    private final Modifications modification;
    private WeakReference<String> newFileContent;
    private final FileObject parentFile;

    public DiffElement(Modifications.Difference difference, FileObject fileObject, Modifications modifications) {
        this.diff = difference;
        this.modification = modifications;
        this.parentFile = fileObject;
    }

    public String getDisplayText() {
        return this.diff.getDesription();
    }

    public String getText() {
        return this.diff.getDesription();
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this.parentFile, this.diff});
    }

    public void setEnabled(boolean bl) {
        this.diff.setExclude(!bl);
        this.newFileContent = null;
        super.setEnabled(bl);
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    protected String getNewFileContent() {
        String string;
        if (this.newFileContent != null && (string = (String)this.newFileContent.get()) != null) {
            return string;
        }
        try {
            string = this.modification.getResultingSource(this.parentFile);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
        this.newFileContent = new WeakReference<String>(string);
        return string;
    }

    public static class ChangeFQCNElement
    extends DiffElement {
        private final Occurrences.OccurrenceItem occurence;

        public ChangeFQCNElement(Modifications.Difference difference, Occurrences.OccurrenceItem occurrenceItem, Modifications modifications) {
            super(difference, occurrenceItem.getFacesConfig(), modifications);
            this.occurence = occurrenceItem;
        }

        public void performChange() {
            this.occurence.performChange();
        }

        public void undoChange() {
            this.occurence.undoChange();
        }

        public PositionBounds getPosition() {
            return this.occurence.getChangePosition();
        }
    }
}

