/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.netbeans.modules.kenai.ui.treelist.TreeList;

public class TreeListUI
extends BasicListUI {
    protected MouseInputListener createMouseInputListener() {
        final MouseInputListener mouseInputListener = super.createMouseInputListener();
        return new MouseInputListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!TreeListUI.this.redispatchComponent(mouseEvent)) {
                    mouseInputListener.mouseClicked(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!TreeListUI.this.redispatchComponent(mouseEvent)) {
                    if (TreeListUI.this.showPopup(mouseEvent)) {
                        return;
                    }
                    mouseInputListener.mousePressed(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!TreeListUI.this.redispatchComponent(mouseEvent)) {
                    if (TreeListUI.this.showPopup(mouseEvent)) {
                        return;
                    }
                    mouseInputListener.mouseReleased(mouseEvent);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (!TreeListUI.this.redispatchComponent(mouseEvent)) {
                    mouseInputListener.mouseEntered(mouseEvent);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (!TreeListUI.this.redispatchComponent(mouseEvent)) {
                    mouseInputListener.mouseExited(mouseEvent);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!TreeListUI.this.redispatchComponent(mouseEvent)) {
                    mouseInputListener.mouseDragged(mouseEvent);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (!TreeListUI.this.redispatchComponent(mouseEvent)) {
                    TreeListUI.this.list.setCursor(Cursor.getDefaultCursor());
                    mouseInputListener.mouseMoved(mouseEvent);
                } else {
                    TreeListUI.this.list.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        };
    }

    private boolean redispatchComponent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.list.locationToIndex(point);
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return false;
        }
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        if (null == listCellRenderer) {
            return false;
        }
        Component component = listCellRenderer.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(n), n, false, false);
        if (null == component) {
            return false;
        }
        Rectangle rectangle = this.list.getCellBounds(n, n);
        if (null == rectangle) {
            return false;
        }
        component.setBounds(0, 0, rectangle.width, rectangle.height);
        component.doLayout();
        Point point2 = rectangle.getLocation();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        Component component2 = SwingUtilities.getDeepestComponentAt(component, point3.x, point3.y);
        if (component2 instanceof AbstractButton) {
            if (!((AbstractButton)component2).isEnabled()) {
                return false;
            }
            Point point4 = SwingUtilities.convertPoint(component, point3, component2);
            MouseEvent mouseEvent2 = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point4.x, point4.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
            component2.dispatchEvent(mouseEvent2);
            this.list.repaint(rectangle);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    private boolean showPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return false;
        }
        if (!(this.list instanceof TreeList)) {
            return false;
        }
        int n = this.list.locationToIndex(mouseEvent.getPoint());
        Rectangle rectangle = this.list.getCellBounds(n, n);
        if (!rectangle.contains(mouseEvent.getPoint())) {
            return false;
        }
        ((TreeList)this.list).showPopupMenuAt(n, mouseEvent.getPoint());
        return true;
    }
}

