/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.favorites.api.Favorites;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.GetSourcesFromKenaiAction;
import org.netbeans.modules.kenai.ui.NbProjectHandleImpl;
import org.netbeans.modules.kenai.ui.SourceHandleImpl;
import org.netbeans.modules.kenai.ui.spi.NbProjectHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.SourceAccessor;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAccessorImpl
extends SourceAccessor {
    private Kenai kenai = Kenai.getDefault();
    private Map<SourceHandle, ProjectAndFeature> handlesMap = new HashMap<SourceHandle, ProjectAndFeature>();

    @Override
    public List<SourceHandle> getSources(ProjectHandle projectHandle) {
        KenaiProject kenaiProject = null;
        ArrayList arrayList = new ArrayList();
        try {
            kenaiProject = this.kenai.getProject(projectHandle.getId());
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (kenaiProject != null) {
            try {
                for (KenaiFeature kenaiFeature : kenaiProject.getFeatures(KenaiService.Type.SOURCE)) {
                    SourceHandleImpl sourceHandleImpl = new SourceHandleImpl(projectHandle, kenaiFeature);
                    arrayList.add(sourceHandleImpl);
                    this.handlesMap.put(sourceHandleImpl, new ProjectAndFeature(projectHandle.getId(), kenaiFeature, sourceHandleImpl.getExternalScmType()));
                }
            }
            catch (KenaiException kenaiException) {
                Exceptions.printStackTrace((Throwable)kenaiException);
            }
        }
        return arrayList.isEmpty() ? Collections.emptyList() : arrayList;
    }

    @Override
    public Action getOpenSourcesAction(SourceHandle sourceHandle) {
        return new GetSourcesFromKenaiAction(this.handlesMap.get(sourceHandle), sourceHandle);
    }

    @Override
    public Action getDefaultAction(SourceHandle sourceHandle) {
        return new GetSourcesFromKenaiAction(this.handlesMap.get(sourceHandle), sourceHandle);
    }

    @Override
    public Action getDefaultAction(final NbProjectHandle nbProjectHandle) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Project project = ((NbProjectHandleImpl)nbProjectHandle).getProject();
                if (project == null) {
                    ((NbProjectHandleImpl)nbProjectHandle).remove();
                } else {
                    OpenProjects.getDefault().open(new Project[]{project}, false);
                    WindowManager.getDefault().findTopComponent("projectTabLogical_tc").requestActive();
                    this.selectProject(project);
                }
            }

            private void selectProject(Project project) {
                ExplorerManager explorerManager = ((ExplorerManager.Provider)WindowManager.getDefault().findTopComponent("projectTabLogical_tc")).getExplorerManager();
                Node node = explorerManager.getRootContext();
                Node node2 = null;
                for (Node node3 : node.getChildren().getNodes()) {
                    Project project2 = (Project)node3.getLookup().lookup(Project.class);
                    if (project2 == null || !project2.getProjectDirectory().equals(project.getProjectDirectory())) continue;
                    node2 = node3;
                    break;
                }
                if (node2 == null) {
                    node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                }
                if (node2 != null) {
                    try {
                        explorerManager.setSelectedNodes(new Node[]{node2});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
    }

    @Override
    public Action getOpenOtherAction(final SourceHandle sourceHandle) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectChooser.setProjectsFolder((File)sourceHandle.getWorkingDirectory());
                JFileChooser jFileChooser = ProjectChooser.projectChooser();
                jFileChooser.setMultiSelectionEnabled(true);
                int n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
                if (n == 0) {
                    File[] fileArray = jFileChooser.isMultiSelectionEnabled() ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
                    ArrayList<Project> arrayList = new ArrayList<Project>(fileArray.length);
                    for (File file : fileArray) {
                        try {
                            Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
                            arrayList.add(project);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Exceptions.printStackTrace((Throwable)illegalArgumentException);
                        }
                    }
                    File[] fileArray2 = new Project[arrayList.size()];
                    arrayList.toArray(fileArray2);
                    OpenProjects.getDefault().open((Project[])fileArray2, false);
                    WindowManager.getDefault().findTopComponent("projectTabLogical_tc").requestActive();
                }
            }
        };
    }

    @Override
    public Action getOpenFavorites(final SourceHandle sourceHandle) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowManager.getDefault().findTopComponent("favorites").requestActive();
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)sourceHandle.getWorkingDirectory());
                    Favorites.getDefault().selectWithAddition(fileObject);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Exceptions.printStackTrace((Throwable)illegalArgumentException);
                }
                catch (NullPointerException nullPointerException) {
                    Exceptions.printStackTrace((Throwable)nullPointerException);
                }
            }
        };
    }

    public static class ProjectAndFeature {
        public String projectName;
        public KenaiFeature feature;
        public String externalScmType;

        public ProjectAndFeature(String string, KenaiFeature kenaiFeature, String string2) {
            this.projectName = string;
            this.feature = kenaiFeature;
            this.externalScmType = string2;
        }
    }
}

