/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.impl.SunStudioDCConfigurationAccessor;
import org.netbeans.modules.dlight.perfan.spi.MonitorsUpdateService;
import org.netbeans.modules.dlight.perfan.spi.datafilter.CollectedObjectsFilter;
import org.netbeans.modules.dlight.perfan.spi.datafilter.SunStudioFiltersProvider;
import org.netbeans.modules.dlight.perfan.spi.datafilter.THAFilter;
import org.netbeans.modules.dlight.perfan.spi.datafilter.THAStartupFilter;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorage;
import org.netbeans.modules.dlight.spi.SunStudioLocator;
import org.netbeans.modules.dlight.spi.SunStudioLocatorFactory;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunStudioDataCollector
extends IndicatorDataProvider<SunStudioDCConfiguration>
implements DataCollector<SunStudioDCConfiguration>,
SunStudioFiltersProvider {
    private static final String COLLECTOR_NAME = "SunStudio";
    private static final DataStorageType supportedStorageType;
    private static final AtomicInteger uid;
    private static final Logger log;
    private static final DataTableMetadata cpuInfoTable;
    private static final DataTableMetadata syncInfoTable;
    private static final DataTableMetadata memInfoTable;
    private static final DataTableMetadata summaryInfoTable;
    private static final DataTableMetadata memSummaryInfoTable;
    private static final DataTableMetadata deadlocksSummaryInfoTable;
    private static final DataTableMetadata dataracesSummaryInfoTable;
    private final Object lock = SunStudioDataCollector.class.getName() + "Lock";
    private final Collection<DataTableMetadata> dataTablesMetadata;
    private final Collection<ValidationListener> validationListeners;
    private final Set<SunStudioDCConfiguration.CollectedInfo> collectedInfo;
    private final List<DataFilter> dataFilters;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private CollectorConfiguration config = null;
    private DLightTarget validatedTarget;
    private Future<Integer> collectTaskResult = null;
    private MonitorsUpdateService monitorsUpdater = null;
    private String cmd;
    private String sproHome;
    private boolean isAttachable = true;
    private HostInfo hostInfo = null;

    public SunStudioDataCollector(Set<SunStudioDCConfiguration.CollectedInfo> set) {
        this.collectedInfo = EnumSet.noneOf(SunStudioDCConfiguration.CollectedInfo.class);
        this.dataTablesMetadata = new HashSet<DataTableMetadata>();
        this.validationListeners = new CopyOnWriteArraySet<ValidationListener>();
        this.dataFilters = new ArrayList<DataFilter>();
        this.addCollectedInfo(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCollectedInfo(Set<SunStudioDCConfiguration.CollectedInfo> set) {
        Object object = this.lock;
        synchronized (object) {
            this.collectedInfo.addAll(set);
        }
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case STARTING: {
                return;
            }
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                return;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus validate(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            if (this.validationStatus.isKnown()) {
                return this.validationStatus;
            }
            ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
            String string = null;
            String string2 = null;
            try {
                this.hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
                switch (this.hostInfo.getOSFamily()) {
                    case LINUX: 
                    case SUNOS: {
                        break;
                    }
                    default: {
                        this.validationStatus = ValidationStatus.invalidStatus((String)SunStudioDataCollector.loc("ValidationStatus.UnsupportedPlatform", new String[0]));
                        return this.validationStatus;
                    }
                }
                Collection collection = Lookup.getDefault().lookupAll(SunStudioLocatorFactory.class);
                boolean bl = true;
                block8: for (SunStudioLocatorFactory sunStudioLocatorFactory : collection) {
                    Collection collection2 = sunStudioLocatorFactory.getInstance(executionEnvironment).getSunStudioLocations();
                    for (SunStudioLocator.SunStudioDescription sunStudioDescription : collection2) {
                        string2 = sunStudioDescription.getPath();
                        string = string2 + "/bin/collect";
                        if (!HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)string)) continue;
                        bl = false;
                        continue block8;
                    }
                }
                if (bl) {
                    this.validationStatus = ValidationStatus.invalidStatus((String)SunStudioDataCollector.loc("ValidationStatus.NoSunStudioFound.html", new String[0]));
                    return this.validationStatus;
                }
            }
            catch (IOException iOException) {
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                Runnable runnable = new Runnable(){

                    public void run() {
                        DLightManager.getDefault().revalidateSessions();
                    }
                };
                AsynchronousAction asynchronousAction = connectionManager.getConnectToAction(executionEnvironment, runnable);
                this.validationStatus = ValidationStatus.unknownStatus((String)SunStudioDataCollector.loc("ValidationStatus.ErrorWhileValidation", iOException.getMessage()), (AsynchronousAction)asynchronousAction);
                return this.validationStatus;
            }
            this.validateCollectedInfo();
            this.validationStatus = ValidationStatus.validStatus();
            this.cmd = string;
            this.sproHome = string2;
            this.validatedTarget = dLightTarget;
            SunStudioUserCounter.countGizmo(string2, (ExecutionEnvironment)executionEnvironment);
            return this.validationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.validationStatus = ValidationStatus.initialStatus();
            this.validatedTarget = null;
            this.config = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus getValidationStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.validationStatus;
        }
    }

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        return Collections.singletonList(supportedStorageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataTableMetadata> getDataTablesMetadata() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<DataTableMetadata>(this.dataTablesMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCollectedInfo() {
        Object object = this.lock;
        synchronized (object) {
            EnumSet<SunStudioDCConfiguration.CollectedInfo> enumSet = EnumSet.copyOf(this.collectedInfo);
            HashSet<DataTableMetadata> hashSet = new HashSet<DataTableMetadata>();
            boolean bl = true;
            boolean bl2 = false;
            if (enumSet.contains((Object)SunStudioDCConfiguration.CollectedInfo.DEADLOCKS) || enumSet.contains((Object)SunStudioDCConfiguration.CollectedInfo.DATARACES)) {
                bl2 = enumSet.retainAll(EnumSet.of(SunStudioDCConfiguration.CollectedInfo.DEADLOCKS, SunStudioDCConfiguration.CollectedInfo.DATARACES));
            }
            if (!bl2) {
                for (SunStudioDCConfiguration.CollectedInfo collectedInfo : this.collectedInfo) {
                    enumSet.add(collectedInfo);
                    switch (collectedInfo) {
                        case FUNCTIONS_LIST: {
                            hashSet.add(cpuInfoTable);
                            break;
                        }
                        case MEMORY: {
                            hashSet.add(memInfoTable);
                            bl = false;
                            break;
                        }
                        case MEMSUMMARY: {
                            hashSet.add(memSummaryInfoTable);
                            bl = false;
                            break;
                        }
                        case SYNCHRONIZATION: {
                            hashSet.add(syncInfoTable);
                            bl = false;
                            break;
                        }
                        case SYNCSUMMARY: {
                            hashSet.add(summaryInfoTable);
                            bl = false;
                            break;
                        }
                        case DEADLOCKS: {
                            hashSet.add(deadlocksSummaryInfoTable);
                            bl = false;
                            break;
                        }
                        case DATARACES: {
                            hashSet.add(dataracesSummaryInfoTable);
                            bl = false;
                        }
                    }
                }
            } else {
                for (SunStudioDCConfiguration.CollectedInfo collectedInfo : enumSet) {
                    switch (collectedInfo) {
                        case DEADLOCKS: {
                            hashSet.add(deadlocksSummaryInfoTable);
                            bl = false;
                            break;
                        }
                        case DATARACES: {
                            hashSet.add(dataracesSummaryInfoTable);
                            bl = false;
                        }
                    }
                }
            }
            this.collectedInfo.clear();
            this.collectedInfo.addAll(enumSet);
            this.dataTablesMetadata.clear();
            this.dataTablesMetadata.addAll(hashSet);
            this.isAttachable = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map<DataStorageType, DataStorage> map, DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            DataStorage dataStorage = map.get(supportedStorageType);
            if (!(dataStorage instanceof PerfanDataStorage)) {
                throw new IllegalArgumentException("Storage " + dataStorage + " cannot be used for PerfanDataCollector!");
            }
            DLightLogger.assertTrue((this.validatedTarget == dLightTarget ? 1 : 0) != 0, (String)"Validation was performed against another target");
            String string = this.hostInfo.getTempDir() + "/experiment_" + uid.incrementAndGet() + ".er";
            this.config = new CollectorConfiguration((PerfanDataStorage)dataStorage, dLightTarget, dLightTarget.getExecEnv(), string, this.sproHome, this.collectedInfo);
            this.reinit();
        }
    }

    @Override
    public List<DataFilter> getDataFilters() {
        return this.dataFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        boolean bl = true;
        Object object = this.lock;
        synchronized (object) {
            try {
                bl = this.prepareExperimentDirectory(this.config.execEnv, this.config.experimentDirectory);
                if (bl) {
                    this.config.dataStorage.init(this.config.execEnv, this.config.sproHome, this.config.experimentDirectory, this);
                    this.monitorsUpdater = new MonitorsUpdateService(this, this.config.execEnv, this.config.sproHome, this.config.experimentDirectory, this.config.collectedInfo);
                }
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttachable() {
        Object object = this.lock;
        synchronized (object) {
            return this.isAttachable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCmd() {
        Object object = this.lock;
        synchronized (object) {
            return this.cmd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getArgs() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            if (this.cmd == null) {
                throw new IllegalStateException("Args can be retrieved for validated and valid collector only");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!log.isLoggable(Level.FINEST)) {
                arrayList.add("-O");
                arrayList.add("/dev/null");
            }
            boolean bl2 = this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.DEADLOCKS);
            THAFilter tHAFilter = null;
            THAStartupFilter tHAStartupFilter = null;
            for (DataFilter dataFilter : this.dataFilters) {
                if (dataFilter instanceof THAFilter) {
                    tHAFilter = (THAFilter)dataFilter;
                    continue;
                }
                if (!(dataFilter instanceof THAStartupFilter)) continue;
                tHAStartupFilter = (THAStartupFilter)dataFilter;
            }
            boolean bl3 = bl = this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.DATARACES) && (tHAFilter == null || tHAFilter.getType().equals((Object)THAFilter.CollectedDataType.DATARACES));
            if (bl2 || bl) {
                arrayList.add("-r");
                if (bl2 && bl) {
                    arrayList.add("deadlocks,races");
                } else if (bl2) {
                    arrayList.add("deadlocks");
                } else if (bl) {
                    arrayList.add("races");
                }
                arrayList.add("-y");
                if (tHAStartupFilter != null && tHAStartupFilter.getStartMode() == THAStartupFilter.StartMode.STARTUP) {
                    arrayList.add("USR1,r");
                } else {
                    arrayList.add("USR1");
                }
            } else {
                if (this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.SYNCHRONIZATION) || this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.SYNCSUMMARY)) {
                    arrayList.add("-s");
                    arrayList.add("1000");
                }
                if (this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.MEMORY) || this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY)) {
                    arrayList.add("-H");
                    arrayList.add("on");
                }
            }
            arrayList.add("-o");
            arrayList.add(this.config.experimentDirectory);
            return arrayList.toArray(new String[0]);
        }
    }

    public String getName() {
        return COLLECTOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            log.fine("Stopping PerfanDataCollector: " + this.cmd);
            if (this.isAttachable() && this.collectTaskResult != null) {
                this.collectTaskResult.cancel(true);
            }
            this.collectTaskResult = null;
            if (this.monitorsUpdater != null) {
                this.monitorsUpdater.stop();
            }
        }
    }

    protected void updateIndicators(List<DataRow> list) {
        this.notifyIndicators(list);
    }

    void notifyIndicatorsThatProviderFinished() {
        super.suggestIndicatorsRepaint();
        this.notifyIndicators(Arrays.asList(new DataRow(Arrays.asList("sunstudio.finished"), Arrays.asList(Boolean.TRUE))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetStarted(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            if (dLightTarget != this.config.target) {
                return;
            }
            if (this.isAttachable()) {
                AttachableTarget attachableTarget = (AttachableTarget)this.config.target;
                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.config.execEnv);
                nativeProcessBuilder.setExecutable(this.cmd);
                nativeProcessBuilder.setArguments(new String[]{"-P", "" + attachableTarget.getPID(), "-o", this.config.experimentDirectory});
                ExecutionDescriptor executionDescriptor = new ExecutionDescriptor();
                if (log.isLoggable(Level.FINEST)) {
                    executionDescriptor = executionDescriptor.errProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new StdErrRedirectorFactory());
                    executionDescriptor = executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new StdErrRedirectorFactory());
                }
                executionDescriptor = executionDescriptor.inputOutput(InputOutput.NULL);
                ExecutionService executionService = ExecutionService.newService((Callable)nativeProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)"collect");
                this.collectTaskResult = executionService.run();
            }
            if (this.monitorsUpdater != null) {
                this.monitorsUpdater.start();
            }
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(SunStudioDataCollector.class, (String)string, (Object[])stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        List<DataFilter> list2 = this.dataFilters;
        synchronized (list2) {
            this.dataFilters.clear();
            for (DataFilter dataFilter : list) {
                if (dataFilter instanceof CollectedObjectsFilter) {
                    this.dataFilters.add(dataFilter);
                    continue;
                }
                if (dataFilter instanceof THAFilter) {
                    this.dataFilters.add(dataFilter);
                    continue;
                }
                if (!(dataFilter instanceof THAStartupFilter)) continue;
                this.dataFilters.add(dataFilter);
            }
        }
    }

    private boolean prepareExperimentDirectory(ExecutionEnvironment executionEnvironment, String string) {
        log.fine("Prepare PerfanDataCollector. Clean directory " + string);
        boolean bl = true;
        try {
            Integer n = null;
            Future future = CommonTasksSupport.rmDir((ExecutionEnvironment)executionEnvironment, (String)string, (boolean)true, null);
            n = (Integer)future.get();
            if (n == null || n != 0) {
                log.info("SunStudioDataCollector: unable to delete directory " + executionEnvironment.toString() + ":" + string);
                bl = false;
            }
            if (bl) {
                File file = new File(new File(string).getParentFile(), "_collector_directory_lock");
                future = CommonTasksSupport.rmFile((ExecutionEnvironment)executionEnvironment, (String)file.getPath(), null);
                n = (Integer)future.get();
            }
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (!bl) {
            log.severe("Unable to prepare an experiment directory!");
        }
        return bl;
    }

    static {
        uid = new AtomicInteger(0);
        log = DLightLogger.getLogger(SunStudioDataCollector.class);
        SunStudioDCConfigurationAccessor sunStudioDCConfigurationAccessor = SunStudioDCConfigurationAccessor.getDefault();
        supportedStorageType = PerfanDataStorage.storageType;
        cpuInfoTable = new DataTableMetadata(sunStudioDCConfigurationAccessor.getCPUTableName(), Arrays.asList(SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_iUser, SunStudioDCConfiguration.c_eUser), null);
        syncInfoTable = new DataTableMetadata(sunStudioDCConfigurationAccessor.getSyncTableName(), Arrays.asList(SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_eSync, SunStudioDCConfiguration.c_eSyncn), null);
        memInfoTable = new DataTableMetadata(sunStudioDCConfigurationAccessor.getMemTableName(), Arrays.asList(SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_leakCount, SunStudioDCConfiguration.c_leakSize), null);
        summaryInfoTable = new DataTableMetadata("SunStudioSummaryData", Arrays.asList(SunStudioDCConfiguration.c_ulockSummary), null);
        memSummaryInfoTable = new DataTableMetadata("SunStudioMemorySummaryData", Arrays.asList(SunStudioDCConfiguration.c_leakSize), null);
        deadlocksSummaryInfoTable = new DataTableMetadata(sunStudioDCConfigurationAccessor.getDeadlockTableName(), Arrays.asList(SunStudioDCConfiguration.c_Deadlocks), null);
        dataracesSummaryInfoTable = new DataTableMetadata(sunStudioDCConfigurationAccessor.getDataraceTableName(), Arrays.asList(SunStudioDCConfiguration.c_Datarace), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectorConfiguration {
        final PerfanDataStorage dataStorage;
        final DLightTarget target;
        final ExecutionEnvironment execEnv;
        final String experimentDirectory;
        final String sproHome;
        final Set<SunStudioDCConfiguration.CollectedInfo> collectedInfo;

        public CollectorConfiguration(PerfanDataStorage perfanDataStorage, DLightTarget dLightTarget, ExecutionEnvironment executionEnvironment, String string, String string2, Set<SunStudioDCConfiguration.CollectedInfo> set) {
            this.target = dLightTarget;
            this.dataStorage = perfanDataStorage;
            this.execEnv = executionEnvironment;
            this.experimentDirectory = string;
            this.sproHome = string2;
            this.collectedInfo = Collections.unmodifiableSet(EnumSet.copyOf(set));
        }
    }

    private static class StdErrRedirectorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private StdErrRedirectorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            return InputProcessors.copying((Writer)new OutputStreamWriter(System.err){
                final StringBuilder sb;
                static final String prefix = "!!!!! COLLECTOR SAYS !!!! : ";
                {
                    this.sb = new StringBuilder();
                }

                public void write(char[] cArray) throws IOException {
                    this.sb.setLength(0);
                    this.sb.append(prefix);
                    for (int i = 0; i < cArray.length; ++i) {
                        this.sb.append(cArray[i]);
                        if (i >= cArray.length - 1 || cArray[i] != '\n') continue;
                        this.sb.append(prefix);
                    }
                    super.write(this.sb.toString().toCharArray());
                }
            });
        }
    }
}

