/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModelEditor;

public class SortableDDTableModel
extends AbstractTableModel
implements DDTableModel {
    private DDTableModel modelDelegate;
    private boolean needsSorting;
    private List modelIndex;
    private Comparator comp;
    private int sortColumn;

    public SortableDDTableModel(DDTableModel dDTableModel) {
        this.modelDelegate = dDTableModel;
        this.modelIndex = new ArrayList(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.modelIndex.add(new DelegateReference(i));
        }
        this.comp = new Comparator(){

            public boolean equals(Object object) {
                return this == object;
            }

            public int compare(Object object, Object object2) {
                if (!(object instanceof DelegateReference) || !(object2 instanceof DelegateReference)) {
                    throw new ClassCastException();
                }
                DelegateReference delegateReference = (DelegateReference)object;
                DelegateReference delegateReference2 = (DelegateReference)object2;
                Comparable comparable = (Comparable)SortableDDTableModel.this.modelDelegate.getValueAt(delegateReference.ref, SortableDDTableModel.this.getSortColumn());
                Object object3 = SortableDDTableModel.this.modelDelegate.getValueAt(delegateReference2.ref, SortableDDTableModel.this.getSortColumn());
                if (comparable == null && object3 == null) {
                    return 0;
                }
                if (comparable == null) {
                    return -1;
                }
                if (object3 == null) {
                    return 1;
                }
                return comparable.compareTo(object3);
            }
        };
        this.setSortColumn(-1);
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public boolean isSortable() {
        return Comparable.class.isAssignableFrom(this.getColumnClass(this.getSortColumn()));
    }

    public void setSortColumn(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            this.sortColumn = n;
            return;
        }
        if (this.sortColumn != n || this.needsSorting) {
            this.sortColumn = n;
            this.sort();
            this.needsSorting = false;
        }
    }

    private void sort() {
        Collections.sort(this.modelIndex, this.comp);
        this.fireTableDataChanged();
    }

    private int getInd(int n) {
        return ((DelegateReference)this.modelIndex.get((int)n)).ref;
    }

    public int getColumnCount() {
        return this.modelDelegate.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.modelDelegate.getColumnName(n);
    }

    public DDTableModelEditor getEditor() {
        return this.modelDelegate.getEditor();
    }

    public boolean isEditValid(Object object, int n) {
        return this.modelDelegate.isEditValid(object, n);
    }

    public List canRemoveRow(int n) {
        return this.modelDelegate.canRemoveRow(n);
    }

    public List isValueValid(Object object, int n) {
        return this.modelDelegate.isValueValid(object, n == -1 ? -1 : this.getInd(n));
    }

    public Object getValueAt(int n, int n2) {
        return this.modelDelegate.getValueAt(this.getInd(n), n2);
    }

    public String getModelName() {
        return this.modelDelegate.getModelName();
    }

    public Object[] getValue() {
        Object[] objectArray = this.modelDelegate.getValue();
        return objectArray;
    }

    public int getRowCount() {
        return this.modelDelegate.getRowCount();
    }

    public Class getColumnClass(int n) {
        return this.modelDelegate.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.modelDelegate.isCellEditable(this.getInd(n), n2);
    }

    public Object getValueAt(int n) {
        return this.modelDelegate.getValueAt(this.getInd(n));
    }

    public void setValueAt(int n, Object object) {
        this.modelDelegate.setValueAt(this.getInd(n), object);
        this.needsSorting = true;
        this.setSortColumn(this.getSortColumn());
    }

    public void setValueAt(Object object, int n, int n2) {
        this.modelDelegate.setValueAt(object, this.getInd(n), n2);
        this.needsSorting = true;
        this.setSortColumn(this.getSortColumn());
    }

    public Object makeNewElement() {
        return this.modelDelegate.makeNewElement();
    }

    public void newElementCancelled(Object object) {
        this.modelDelegate.newElementCancelled(object);
    }

    public void editsCancelled() {
        this.modelDelegate.editsCancelled();
    }

    public void addRowAt(int n, Object object, Object object2) {
        n = n == -1 ? this.getRowCount() : ++n;
        this.modelIndex.add(n, new DelegateReference(this.getRowCount()));
        this.modelDelegate.addRowAt(-1, object, object2);
        this.fireTableRowsInserted(n, n);
        this.needsSorting = true;
        this.setSortColumn(this.getSortColumn());
    }

    public void removeRowAt(int n) {
        int n2 = this.getInd(n);
        this.modelDelegate.removeRowAt(n2);
        this.modelIndex.remove(n);
        for (DelegateReference delegateReference : this.modelIndex) {
            if (delegateReference.ref >= n2) {
                --delegateReference.ref;
            }
            this.fireTableRowsDeleted(n, n);
        }
    }

    private static class DelegateReference {
        public int ref;

        public DelegateReference(int n) {
            this.ref = n;
        }
    }
}

