/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.swing.JToolTip;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.ModelNode;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractModelNode;
import org.netbeans.modules.php.dbgp.models.nodes.VariableNode;
import org.netbeans.modules.php.dbgp.packets.ContextNamesResponse;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.modules.php.dbgp.packets.PropertyGetCommand;
import org.netbeans.modules.php.dbgp.packets.PropertySetCommand;
import org.netbeans.modules.php.dbgp.packets.PropertyValueCommand;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariablesModel
extends ViewModelSupport
implements TreeModel,
TableModel,
NodeModel {
    private static final String EVALUATING = "TXT_Evaluating";
    static final String GET_SHORT_DESCRIPTION = "getShortDescription";
    static final String NULL = "null";
    private final ContextProvider myContextProvider;
    private List<ModelNode> myNodes;
    private ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock myReadlock = this.myLock.readLock();
    private ReentrantReadWriteLock.WriteLock myWritelock = this.myLock.writeLock();

    public VariablesModel(ContextProvider contextProvider) {
        this.myContextProvider = contextProvider;
        this.myNodes = new LinkedList<ModelNode>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearModel() {
        this.myWritelock.lock();
        try {
            this.myNodes.clear();
            Object var2_1 = null;
            this.myWritelock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.myWritelock.unlock();
            throw throwable;
        }
        this.fireTreeChanged();
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        block9: {
            int n3;
            block10: {
                ModelNode modelNode;
                block7: {
                    List<ModelNode> list;
                    block8: {
                        this.myReadlock.lock();
                        try {
                            modelNode = null;
                            if (object != "Root") break block7;
                            list = this.getTopLevelElements();
                            if (n < list.size()) break block8;
                            Object[] objectArray = new Object[]{};
                            Object var10_11 = null;
                            this.myReadlock.unlock();
                            return objectArray;
                        }
                        catch (Throwable throwable) {
                            Object var10_16 = null;
                            this.myReadlock.unlock();
                            throw throwable;
                        }
                    }
                    int n4 = Math.min(list.size(), n2);
                    List<ModelNode> list2 = list.subList(n, n4);
                    Object[] objectArray = list2.toArray(new Object[list2.size()]);
                    Object var10_12 = null;
                    this.myReadlock.unlock();
                    return objectArray;
                }
                if (object instanceof ModelNode) {
                    modelNode = (ModelNode)object;
                }
                if (modelNode == null) break block9;
                n3 = ((ModelNode)object).getChildrenSize();
                if (n < n3) break block10;
                Object[] objectArray = new Object[]{};
                Object var10_13 = null;
                this.myReadlock.unlock();
                return objectArray;
            }
            int n5 = Math.min(n3, n2);
            Object[] objectArray = ((ModelNode)object).getChildren(n, n5);
            Object var10_14 = null;
            this.myReadlock.unlock();
            return objectArray;
        }
        Object var10_15 = null;
        this.myReadlock.unlock();
        throw new UnknownTypeException((Object)(object + " " + object.getClass().getName()));
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == null) {
            return true;
        }
        if (object == "Root") {
            return this.myNodes.size() == 0;
        }
        if (object instanceof ModelNode) {
            ModelNode modelNode = (ModelNode)object;
            DebugSession debugSession = this.getSession();
            if (debugSession != null) {
                this.childrenRequest(modelNode, debugSession);
                this.fillChildrenList(modelNode, debugSession);
            }
            return modelNode.isLeaf();
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        block5: {
            block4: {
                this.myReadlock.lock();
                try {
                    if (object != "Root") break block4;
                    int n = this.getTopLevelElements().size();
                    Object var4_4 = null;
                    this.myReadlock.unlock();
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.myReadlock.unlock();
                    throw throwable;
                }
            }
            if (!(object instanceof ModelNode)) break block5;
            int n = ((ModelNode)object).getChildrenSize();
            Object var4_5 = null;
            this.myReadlock.unlock();
            return n;
        }
        throw new UnknownTypeException(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof JToolTip) {
            return this.getTooltip((JToolTip)object, string);
        }
        String string2 = "";
        if ("LocalsType".equals(string)) {
            if (object instanceof ModelNode) {
                String string3 = ((ModelNode)object).getType();
                assert (string3 != null);
                string2 = string3;
            } else {
                string2 = object != null ? object.getClass().getName() : "";
            }
        } else if ("LocalsValue".equals(string)) {
            if (object instanceof ModelNode) {
                ModelNode modelNode = (ModelNode)object;
                try {
                    string2 = modelNode.getValue();
                }
                catch (UnsufficientValueException unsufficientValueException) {
                    this.sendValueCommand(modelNode);
                    return NbBundle.getMessage(VariablesModel.class, (String)EVALUATING);
                }
            } else if (object == null) {
                string2 = "";
            }
        }
        return string2;
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof ModelNode && "LocalsValue".equals(string)) {
            return ((ModelNode)object).isReadOnly();
        }
        return true;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        assert (object2 instanceof String);
        if (!"LocalsValue".equals(string)) {
            throw new UnknownTypeException(object);
        }
        if (!(object instanceof VariableNode)) {
            throw new UnknownTypeException(object);
        }
        ModelNode modelNode = (ModelNode)object;
        if (modelNode.isReadOnly()) {
            throw new UnknownTypeException(object);
        }
        DebugSession debugSession = this.getSession();
        if (debugSession == null) {
            return;
        }
        PropertySetCommand propertySetCommand = new PropertySetCommand(debugSession.getTransactionId());
        propertySetCommand.setData((String)object2);
        assert (object instanceof AbstractVariableNode);
        ((AbstractVariableNode)object).setupCommand(propertySetCommand);
        debugSession.sendCommandLater(propertySetCommand);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        String string = null;
        if (object == "Root") {
            string = "Root";
        } else if (object instanceof ModelNode) {
            string = ((ModelNode)object).getName();
        } else if (object != null) {
            throw new UnknownTypeException(object);
        }
        if (string == null && object != null) {
            Logger.getLogger(VariablesModel.class.getName()).warning("display name isn't expected to be null: " + object.getClass().getName());
        }
        return string != null ? string : NULL;
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == null || object == "Root") {
            return "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getIconBase();
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == null || object == "Root") {
            return null;
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getShortDescription();
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContext(ContextNode contextNode) {
        this.myWritelock.lock();
        try {
            if (this.myNodes.size() == 0) {
                this.myNodes.add(contextNode);
            } else {
                boolean bl = false;
                for (ModelNode modelNode : this.myNodes) {
                    if (!(modelNode instanceof ContextNode) || !contextNode.equalsTo((ContextNode)modelNode)) continue;
                    this.updateContext((ContextNode)modelNode, contextNode);
                    bl = true;
                }
                if (!bl) {
                    this.myNodes.add(contextNode);
                }
            }
            this.fireTreeChanged();
            Object var6_5 = null;
            this.myWritelock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.myWritelock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(Property property) {
        this.myWritelock.lock();
        try {
            for (ModelNode modelNode : this.myNodes) {
                if (!this.updateVariable(modelNode, property)) continue;
                Object var5_4 = null;
                this.myWritelock.unlock();
                return;
            }
            Object var5_5 = null;
            this.myWritelock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.myWritelock.unlock();
            throw throwable;
        }
    }

    private boolean updateVariable(ModelNode modelNode, Property property) {
        if (modelNode instanceof AbstractVariableNode) {
            ModelNode[] modelNodeArray = (ModelNode[])modelNode;
            String string = modelNodeArray.getFullName();
            if (property.getFullName().equals(string)) {
                ArrayList<ModelEvent> arrayList = new ArrayList<ModelEvent>();
                modelNodeArray.collectUpdates(this, AbstractModelNode.createVariable(property, modelNodeArray.getParent()), arrayList);
                this.fireTableUpdate(arrayList);
                return true;
            }
        }
        for (ModelNode modelNode2 : modelNode.getChildren(0, modelNode.getChildrenSize())) {
            if (!this.updateVariable(modelNode2, property)) continue;
            return true;
        }
        return false;
    }

    private List<ModelNode> getTopLevelElements() {
        LinkedList<ModelNode> linkedList = new LinkedList<ModelNode>();
        for (ModelNode modelNode : this.myNodes) {
            if (modelNode instanceof ContextNode && !((ContextNode)modelNode).isGlobal()) {
                linkedList.addAll(Arrays.asList(modelNode.getChildren(0, modelNode.getChildrenSize())));
                continue;
            }
            linkedList.add(0, modelNode);
        }
        return linkedList;
    }

    private String getTooltip(JToolTip jToolTip, String string) throws UnknownTypeException {
        Object object = jToolTip.getClientProperty(GET_SHORT_DESCRIPTION);
        if (object instanceof ModelNode) {
            return this.getValueAt(object, string).toString();
        }
        throw new UnknownTypeException((Object)jToolTip);
    }

    private void sendValueCommand(ModelNode modelNode) {
        if (modelNode instanceof AbstractVariableNode) {
            AbstractVariableNode abstractVariableNode = (AbstractVariableNode)modelNode;
            DebugSession debugSession = this.getSession();
            PropertyValueCommand propertyValueCommand = new PropertyValueCommand(debugSession.getTransactionId());
            abstractVariableNode.setupCommand(propertyValueCommand);
            debugSession.sendCommandLater(propertyValueCommand);
        }
    }

    private void updateContext(ContextNode contextNode, ContextNode contextNode2) {
        LinkedList<ModelEvent> linkedList = new LinkedList<ModelEvent>();
        contextNode.collectUpdates(this, contextNode2, linkedList);
        this.fireTableUpdate(linkedList);
    }

    private void fireTreeChanged() {
        this.refresh();
    }

    private void fireTreeChanged(ModelEvent modelEvent) {
        this.fireChangeEvents(new ModelEvent[]{modelEvent});
    }

    private void fireTableUpdate(Collection<ModelEvent> collection) {
        this.fireChangeEvents(collection);
    }

    private DebugSession getSession() {
        ContextProvider contextProvider = this.getContextProvider();
        if (contextProvider == null) {
            return null;
        }
        SessionId sessionId = (SessionId)contextProvider.lookupFirst(null, SessionId.class);
        if (sessionId == null) {
            return null;
        }
        return SessionManager.getInstance().getCurrentSession(sessionId);
    }

    private ContextProvider getContextProvider() {
        return this.myContextProvider;
    }

    private void childrenRequest(ModelNode modelNode, DebugSession debugSession) {
        int n = modelNode.getChildrenSize();
        if (!modelNode.isLeaf() && n == 0) {
            assert (modelNode instanceof AbstractVariableNode);
            PropertyGetCommand propertyGetCommand = new PropertyGetCommand(debugSession.getTransactionId());
            ((AbstractVariableNode)modelNode).setupCommand(propertyGetCommand);
            debugSession.sendCommandLater(propertyGetCommand);
        }
    }

    private void fillChildrenList(ModelNode modelNode, DebugSession debugSession) {
        if (!(modelNode instanceof AbstractVariableNode)) {
            return;
        }
        AbstractVariableNode abstractVariableNode = (AbstractVariableNode)modelNode;
        if (debugSession != null && !abstractVariableNode.isChildrenFilled()) {
            PropertyGetCommand propertyGetCommand = new PropertyGetCommand(debugSession.getTransactionId());
            abstractVariableNode.setupFillChildrenCommand(propertyGetCommand);
            debugSession.sendCommandLater(propertyGetCommand);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractVariableNode
    extends org.netbeans.modules.php.dbgp.models.nodes.AbstractVariableNode {
        protected AbstractVariableNode(Property property, AbstractModelNode abstractModelNode) {
            super(property, abstractModelNode);
        }

        @Override
        protected void collectUpdates(VariablesModel variablesModel, VariableNode variableNode, Collection<ModelEvent> collection) {
            AbstractVariableNode abstractVariableNode = (AbstractVariableNode)variableNode;
            boolean bl = false;
            assert (this.getFullName().equals(variableNode.getFullName()));
            this.setProperty(abstractVariableNode.getProperty());
            if (this.updatePage(abstractVariableNode)) {
                if (abstractVariableNode.getChildrenSize() > 0) {
                    collection.add((ModelEvent)new ModelEvent.NodeChanged((Object)variablesModel, (Object)this));
                }
                return;
            }
            if (!Property.equals(this.getProperty(), abstractVariableNode.getProperty())) {
                bl = true;
            }
            if ((this.getVariables() == null || this.getVariables().size() == 0) && abstractVariableNode.getVariables() != null) {
                this.initVariables(abstractVariableNode.getProperty().getChildren());
                bl = true;
            } else if (this.getVariables() != null) {
                bl = this.updateExistedChildren(variablesModel, abstractVariableNode, collection) || bl;
                boolean bl2 = bl = this.addAbsentChildren(abstractVariableNode) || bl;
            }
            if (bl) {
                collection.add((ModelEvent)new ModelEvent.NodeChanged((Object)variablesModel, (Object)this));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextNode
    extends org.netbeans.modules.php.dbgp.models.nodes.ContextNode {
        public ContextNode(ContextNamesResponse.Context context, List<Property> list) {
            super(context, list);
        }

        void collectUpdates(VariablesModel variablesModel, ContextNode contextNode, Collection<ModelEvent> collection) {
            boolean bl = false;
            if ((this.getVariables() == null || this.getVariables().size() == 0) && contextNode.getVariables() != null) {
                this.setVars(contextNode.getVariables());
                bl = true;
            } else if (this.getVariables() != null) {
                bl = this.updateExistedChildren(variablesModel, contextNode, collection);
                boolean bl2 = bl = this.addAbsentChildren(contextNode) || bl;
            }
            if (bl) {
                collection.add((ModelEvent)new ModelEvent.NodeChanged((Object)variablesModel, (Object)this));
            }
        }
    }
}

