/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.util;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public abstract class XWSSUtil {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static X509Certificate getCertificateFromTrustStore(byte[] ski, KeyStore trustStore) throws IOException {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = aliases.nextElement();
                Certificate cert = trustStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(ski, keyId)) continue;
                return x509Cert;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static X509Certificate getCertificateFromTrustStore(String issuerName, BigInteger serialNumber, KeyStore trustStore) throws IOException {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = trustStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return x509Cert;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static PrivateKey getPrivateKey(byte[] ski, KeyStore keyStore, String keyStorePassword) throws IOException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                Certificate cert;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (cert = keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(ski, keyId)) continue;
                return (PrivateKey)keyStore.getKey(alias, keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static PrivateKey getPrivateKey(String issuerName, BigInteger serialNumber, KeyStore keyStore, String keyStorePassword) throws IOException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (cert = keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return (PrivateKey)keyStore.getKey(alias, keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static PrivateKey getPrivateKey(X509Certificate certificate, KeyStore keyStore, String keyStorePassword) throws IOException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (cert = keyStore.getCertificate(alias)) == null || !cert.equals(certificate)) continue;
                return (PrivateKey)keyStore.getKey(alias, keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static SecretKey generateSymmetricKey(String algorithm) throws XWSSecurityException {
        return SecurityUtil.generateSymmetricKey(algorithm);
    }

    public static X509Certificate matchesProgrammaticInfo(Object obj, byte[] keyIdentifier, String valueType) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof X509Certificate) {
            try {
                X509Certificate cert = (X509Certificate)obj;
                byte[] keyId = null;
                if ("Identifier".equals(valueType)) {
                    keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(cert);
                } else if ("Thumbprint".equals(valueType)) {
                    keyId = XWSSUtil.getThumbprintIdentifier(cert);
                }
                if (keyId != null && Arrays.equals(keyIdentifier, keyId)) {
                    return cert;
                }
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, null, ex);
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        return null;
    }

    public static X509Certificate matchesProgrammaticInfo(Object obj, PublicKey publicKey) {
        X509Certificate cert;
        if (obj == null) {
            return null;
        }
        if (obj instanceof X509Certificate && (cert = (X509Certificate)obj).getPublicKey().equals(publicKey)) {
            return cert;
        }
        return null;
    }

    public static X509Certificate matchesProgrammaticInfo(Object obj, BigInteger serialNumber, String issuerName) {
        String thisIssuerName;
        X509Certificate cert;
        if (obj == null) {
            return null;
        }
        if (obj instanceof X509Certificate && (cert = (X509Certificate)obj).getSerialNumber().equals(serialNumber) && (thisIssuerName = RFC2253Parser.normalize(cert.getIssuerDN().getName())).equals(issuerName)) {
            return cert;
        }
        return null;
    }

    public static PrivateKey getProgrammaticPrivateKey(Map context) {
        if (context == null) {
            return null;
        }
        Object obj = context.get("privatekey");
        if (obj instanceof PrivateKey) {
            return (PrivateKey)obj;
        }
        if (obj != null) {
            log.log(Level.SEVERE, "value of PRIVATEKEY_PROPERTY is not a PrivateKey");
            throw new XWSSecurityRuntimeException("value of PRIVATEKEY_PROPERTY is not a PrivateKey");
        }
        return null;
    }

    public static byte[] getThumbprintIdentifier(X509Certificate cert) throws XWSSecurityException {
        byte[] thumbPrintIdentifier = null;
        try {
            thumbPrintIdentifier = MessageDigest.getInstance("SHA-1").digest(cert.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.SEVERE, "WSS0708.no.digest.algorithm");
            throw new XWSSecurityException("Digest algorithm SHA-1 not found");
        }
        catch (CertificateEncodingException ex) {
            log.log(Level.SEVERE, "WSS0709.error.getting.rawContent");
            throw new XWSSecurityException("Error while getting certificate's raw content");
        }
        return thumbPrintIdentifier;
    }

    public static CertSelector getCertSelector(Class certSelectorClass, Map context) {
        CertSelector selector = null;
        if (certSelectorClass != null) {
            Constructor ctor = null;
            try {
                ctor = certSelectorClass.getConstructor(Map.class);
            }
            catch (SecurityException ex) {
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (ctor != null) {
                try {
                    selector = (CertSelector)ctor.newInstance(context);
                    return selector;
                }
                catch (IllegalArgumentException ex) {
                    log.log(Level.SEVERE, "WSS0812.exception.instantiating.certselector", ex);
                    throw new RuntimeException(ex);
                }
                catch (InstantiationException ex) {
                    log.log(Level.SEVERE, "WSS0812.exception.instantiating.certselector", ex);
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    log.log(Level.SEVERE, "WSS0812.exception.instantiating.certselector", ex);
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    log.log(Level.SEVERE, "WSS0812.exception.instantiating.certselector", ex);
                    throw new RuntimeException(ex);
                }
            }
            try {
                selector = (CertSelector)certSelectorClass.newInstance();
                return selector;
            }
            catch (InstantiationException ex) {
                log.log(Level.SEVERE, "WSS0812.exception.instantiating.certselector", ex);
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                log.log(Level.SEVERE, "WSS0812.exception.instantiating.certselector", ex);
                throw new RuntimeException(ex);
            }
        }
        return null;
    }
}

