/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcknowledgementData {
    private final String ackedSequenceId;
    private final List<Sequence.AckRange> ackedRanges;
    private final String ackRequestedSequenceId;
    private final boolean isFinalAcknowledgement;

    public static Builder getBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(AcknowledgementData data) {
        return new Builder(data);
    }

    private AcknowledgementData(String ackedSequenceId, List<Sequence.AckRange> ackedRanges, String ackRequestedSequenceId, boolean isFinal) {
        this.ackedSequenceId = ackedSequenceId;
        this.ackedRanges = ackedRanges;
        this.ackRequestedSequenceId = ackRequestedSequenceId;
        this.isFinalAcknowledgement = isFinal;
    }

    public String getAcknowledgedSequenceId() {
        return this.ackedSequenceId;
    }

    @NotNull
    public List<Sequence.AckRange> getAcknowledgedRanges() {
        if (this.ackedRanges != null) {
            return this.ackedRanges;
        }
        return Collections.emptyList();
    }

    public String getAckReqestedSequenceId() {
        return this.ackRequestedSequenceId;
    }

    public boolean isFinalAcknowledgement() {
        return this.isFinalAcknowledgement;
    }

    public boolean containsSequenceAcknowledgementData() {
        return this.ackedSequenceId != null && this.ackedRanges != null && !this.ackedRanges.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private String ackedSequenceId;
        private List<Sequence.AckRange> ackedRanges;
        private String ackRequestedSequenceId;
        private boolean isFinalAcknowledgement;

        private Builder() {
        }

        private Builder(AcknowledgementData data) {
            this.ackRequestedSequenceId = data.ackRequestedSequenceId;
            this.ackedRanges = data.ackedRanges;
            this.ackedSequenceId = data.ackedSequenceId;
            this.isFinalAcknowledgement = data.isFinalAcknowledgement;
        }

        public Builder acknowledgements(@NotNull String ackedSequenceId, List<Sequence.AckRange> acknowledgedMessageIds, boolean isFinal) {
            assert (ackedSequenceId != null);
            this.ackedSequenceId = ackedSequenceId;
            this.ackedRanges = acknowledgedMessageIds;
            this.isFinalAcknowledgement = isFinal;
            return this;
        }

        public Builder ackReqestedSequenceId(@NotNull String ackRequestedSequenceId) {
            assert (ackRequestedSequenceId != null);
            this.ackRequestedSequenceId = ackRequestedSequenceId;
            return this;
        }

        public AcknowledgementData build() {
            return new AcknowledgementData(this.ackedSequenceId, this.ackedRanges, this.ackRequestedSequenceId, this.isFinalAcknowledgement);
        }
    }
}

