/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.util.List;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.TldRefactoring;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.netbeans.modules.web.refactoring.rename.TldRename;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.ListenerType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseTldRename
extends TldRefactoring {
    protected final WebModule webModule;

    public BaseTldRename(WebModule webModule) {
        this.webModule = webModule;
    }

    protected abstract List<RenameItem> getAffectedClasses();

    protected abstract AbstractRefactoring getRefactoring();

    /*
     * WARNING - void declaration
     */
    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = null;
        for (TldRefactoring.TaglibHandle taglibHandle : this.getTaglibs(this.webModule)) {
            if (!taglibHandle.isValid()) {
                problem = RefactoringUtil.addToEnd(new Problem(false, NbBundle.getMessage(BaseTldRename.class, (String)"TXT_TLdInvalidProblem", (Object)taglibHandle.getTldFile())), problem);
                continue;
            }
            Taglib taglib = taglibHandle.getTaglib();
            for (RenameItem renameItem : this.getAffectedClasses()) {
                void var13_14;
                String string = renameItem.getOldFqn();
                String string2 = renameItem.getNewFqn();
                for (TagType tagType : taglib.getTag()) {
                    if (string.equals(tagType.getTagClass())) {
                        refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new TagClassRenameElement(string, string2, tagType, taglib, taglibHandle.getTldFile()));
                    }
                    if (!string.equals(tagType.getTeiClass())) continue;
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new TeiClassRenameElement(string, string2, tagType, taglib, taglibHandle.getTldFile()));
                }
                for (TagType tagType : taglib.getFunction()) {
                    if (!string.equals(tagType.getFunctionClass())) continue;
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new FunctionTypeRenameElement(string, string2, (FunctionType)tagType, taglib, taglibHandle.getTldFile()));
                }
                ValidatorType validatorType = taglib.getValidator();
                if (validatorType != null && string.equals(validatorType.getValidatorClass())) {
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new ValidatorRenameElement(string, string2, validatorType, taglib, taglibHandle.getTldFile()));
                }
                ListenerType[] listenerTypeArray = taglib.getListener();
                int n = listenerTypeArray.length;
                boolean bl = false;
                while (var13_14 < n) {
                    ListenerType listenerType = listenerTypeArray[var13_14];
                    if (string.equals(listenerType.getListenerClass())) {
                        refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new ListenerRenameElement(string, string2, listenerType, taglib, taglibHandle.getTldFile()));
                    }
                    ++var13_14;
                }
            }
        }
        return problem;
    }

    private static class ListenerRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final ListenerType listenerType;

        public ListenerRenameElement(String string, String string2, ListenerType listenerType, Taglib taglib, FileObject fileObject) {
            super(string, taglib, fileObject);
            this.newName = string2;
            this.listenerType = listenerType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibListenerClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.listenerType.setListenerClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.listenerType.setListenerClass(this.clazz);
            this.write();
        }
    }

    private static class FunctionTypeRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final FunctionType functionType;

        public FunctionTypeRenameElement(String string, String string2, FunctionType functionType, Taglib taglib, FileObject fileObject) {
            super(string, taglib, fileObject);
            this.newName = string2;
            this.functionType = functionType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibFunctionClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.functionType.setFunctionClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.functionType.setFunctionClass(this.clazz);
            this.write();
        }
    }

    private static class ValidatorRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final ValidatorType validatorType;

        public ValidatorRenameElement(String string, String string2, ValidatorType validatorType, Taglib taglib, FileObject fileObject) {
            super(string, taglib, fileObject);
            this.newName = string2;
            this.validatorType = validatorType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibValidatorClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.validatorType.setValidatorClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.validatorType.setValidatorClass(this.clazz);
            this.write();
        }
    }

    private static class TeiClassRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final TagType tagType;

        public TeiClassRenameElement(String string, String string2, TagType tagType, Taglib taglib, FileObject fileObject) {
            super(string, taglib, fileObject);
            this.newName = string2;
            this.tagType = tagType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibTeiClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.tagType.setTeiClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.tagType.setTeiClass(this.clazz);
            this.write();
        }
    }

    private static class TagClassRenameElement
    extends TldRefactoring.TldRefactoringElement {
        private final String newName;
        private final TagType tagType;

        public TagClassRenameElement(String string, String string2, TagType tagType, Taglib taglib, FileObject fileObject) {
            super(string, taglib, fileObject);
            this.newName = string2;
            this.tagType = tagType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldRename.class, (String)"TXT_TaglibTagClassRename", (Object)this.clazz, (Object)this.newName);
        }

        public void performChange() {
            this.tagType.setTagClass(this.newName);
            this.write();
        }

        public void undoChange() {
            this.tagType.setTagClass(this.clazz);
            this.write();
        }
    }
}

