/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.ui.swing.wizard.SetupComponentDecorator;
import org.limewire.ui.swing.wizard.WizardPage;

public class Wizard
extends JPanel {
    @Resource
    private Dimension size;
    @Resource
    private Color background;
    @Resource
    private Color border;
    @Resource
    private Color titleBarBackground;
    @Resource
    private Color titleBarForeground;
    @Resource
    private Color titleBarBorder;
    @Resource
    private Font titleBarFont;
    @Resource
    private Font footerFont;
    @Resource
    private Color footerFontColor;
    private JDialog dialog;
    private final JLabel titleBarLabel;
    private final JLabel headerLine1;
    private final JLabel headerLine2;
    private final JLabel footer;
    private int currentPage;
    private final JXButton continueButton;
    private Action continueAction = new AbstractAction(I18n.tr("Continue")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.next();
        }
    };
    private JButton backButton;
    private Action backAction = new AbstractAction(I18n.tr("Go back")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.back();
        }
    };
    private JXButton finishButton;
    private Action finishAction = new AbstractAction(I18n.tr("Continue")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.finish();
        }
    };
    private List<WizardPage> pageList;
    private JPanel mainPanel;
    private CardLayout cardLayout;

    public Wizard(SetupComponentDecorator decorator) {
        super(new BorderLayout());
        GuiUtils.assignResources(this);
        this.setBackground(this.background);
        this.setBorder(new LineBorder(this.border, 3));
        this.pageList = new ArrayList<WizardPage>();
        this.continueButton = new JXButton(this.continueAction);
        decorator.decorateGreenButton(this.continueButton);
        this.backButton = new HyperlinkButton((String)this.backAction.getValue("Name"), this.backAction);
        decorator.decorateBackButton(this.backButton);
        this.finishButton = new JXButton(this.finishAction);
        decorator.decorateGreenButton(this.finishButton);
        this.cardLayout = new CardLayout();
        this.mainPanel = new JPanel(this.cardLayout);
        this.mainPanel.setBackground(this.getBackground());
        this.titleBarLabel = new JLabel();
        this.titleBarLabel.setOpaque(true);
        this.titleBarLabel.setFont(this.titleBarFont);
        this.titleBarLabel.setBackground(this.titleBarBackground);
        this.titleBarLabel.setForeground(this.titleBarForeground);
        this.titleBarLabel.setBorder(new LineBorder(this.titleBarBorder, 3));
        this.headerLine1 = new JLabel();
        decorator.decorateHeadingText(this.headerLine1);
        this.headerLine2 = new MultiLineLabel();
        decorator.decorateNormalText(this.headerLine2);
        this.footer = new JLabel();
        this.footer.setOpaque(false);
        this.footer.setForeground(this.footerFontColor);
        this.footer.setFont(this.footerFont);
        this.footer.setBorder(BorderFactory.createEmptyBorder(0, 14, 0, 0));
        JXPanel headerBar = new JXPanel(new MigLayout("insets 14, gap 0, fill"));
        decorator.decorateSetupHeader(headerBar);
        headerBar.add((Component)this.titleBarLabel, "dock north, growx");
        headerBar.add((Component)this.headerLine1, "growx, wrap");
        headerBar.add((Component)this.headerLine2, "growx");
        JPanel bottomBar = new JPanel(new BorderLayout());
        JPanel bottomBarInner = new JPanel(new MigLayout("gap 10, insets 0 0 10 10, nogrid, hidemode 3"));
        bottomBarInner.add(this.backButton);
        bottomBarInner.add(this.continueButton);
        bottomBarInner.add(this.finishButton);
        bottomBar.add((Component)bottomBarInner, "East");
        bottomBar.add((Component)this.footer, "West");
        this.add((Component)headerBar, "North");
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)bottomBar, "South");
    }

    public void addPage(WizardPage page) {
        this.pageList.add(page);
        this.mainPanel.add((Component)page, this.pageList.indexOf(page) + "");
    }

    public int getPageCount() {
        return this.pageList.size();
    }

    public void showDialog(Frame owner) {
        if (this.getPageCount() > 0) {
            this.setCurrentPage(0);
            this.dialog = new LimeJDialog(owner, true);
            ResizeUtils.forceSize(this.dialog, this.size);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    Wizard.this.setFocus();
                }
            });
            this.dialog.setUndecorated(true);
            this.dialog.add(this);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(owner);
            this.dialog.setVisible(true);
        }
    }

    protected void finish() {
        for (WizardPage page : this.pageList) {
            page.applySettings();
        }
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private void next() {
        this.setCurrentPage(this.currentPage + 1);
        this.setFocus();
    }

    private void back() {
        this.setCurrentPage(this.currentPage - 1);
        this.setFocus();
    }

    private void updateTitle(WizardPage page) {
        if (this.pageList.size() > 1) {
            this.titleBarLabel.setText(I18n.tr("Setup - step {0} of {1}", this.currentPage + 1, this.pageList.size()));
        } else {
            this.titleBarLabel.setText(I18n.tr("Setup"));
        }
        String line2 = page.getLine2();
        if (line2 != null) {
            this.headerLine1.setText(page.getLine1());
            this.headerLine2.setText(line2);
            this.headerLine1.setVisible(true);
        } else {
            this.headerLine1.setVisible(false);
            this.headerLine2.setText(page.getLine1());
        }
        this.footer.setText(page.getFooter());
    }

    public void setCurrentPage(int step) {
        if (step >= 0 && step < this.pageList.size()) {
            this.currentPage = step;
            this.cardLayout.show(this.mainPanel, this.currentPage + "");
            this.finishButton.setVisible(this.currentPage == this.pageList.size() - 1);
            this.continueButton.setVisible(!this.finishButton.isVisible());
            this.backButton.setVisible(this.currentPage != 0);
            this.updateTitle(this.pageList.get(this.currentPage));
        }
    }

    private void setFocus() {
        if (this.finishButton.isVisible()) {
            this.finishButton.requestFocusInWindow();
        } else {
            this.continueButton.requestFocusInWindow();
        }
    }
}

