/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.images.ImageCellEditor;
import org.limewire.ui.swing.images.ImageCellRenderer;
import org.limewire.ui.swing.images.ImageList;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.table.TablePopupHandler;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.SwingHacks;

@LazySingleton
public class LibraryImageTable
extends JPanel
implements Scrollable {
    @Resource
    private Color backgroundColor;
    private final ImageList imageList;
    private final JXLayer<JComponent> layer;
    private final ImageCellEditor imageEditor;

    @Inject
    public LibraryImageTable(final ImageList imageList, final ImageCellEditor imageEditor, final LibraryNavigatorPanel navigatorPanel) {
        super(new MigLayout("insets 0 0 0 0, fill"));
        this.imageEditor = imageEditor;
        imageEditor.setVisible(false);
        GuiUtils.assignResources(this);
        this.setBackground(this.backgroundColor);
        this.imageList = imageList;
        imageList.setDragEnabled(true);
        imageList.setDropMode(DropMode.ON);
        imageList.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
        JScrollPane imageScrollPane = new JScrollPane(imageList);
        imageScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.layer = new JXLayer<JScrollPane>(imageScrollPane, new AbstractLayerUI());
        this.layer.getGlassPane().setLayout(null);
        new MouseReaction(imageList, imageEditor, imageScrollPane);
        this.layer.getGlassPane().add(imageEditor);
        imageEditor.getRemoveButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p2 = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), imageList);
                int popupRow = imageList.locationToIndex(p2);
                if (popupRow < 0) {
                    return;
                }
                imageList.setSelectedIndex(popupRow);
                List<LocalFileItem> items = imageList.getSelectedItems();
                if (items.size() > 0) {
                    LibraryNavItem item = navigatorPanel.getSelectedNavItem();
                    item.getLocalFileList().removeFile(items.get(0).getFile());
                }
                imageEditor.setVisible(false);
            }
        });
        this.add(this.layer, "grow");
    }

    public void setShowButtons(boolean value) {
        this.imageList.getImageCellRenderer().setShowButtons(value);
        this.imageEditor.setShowButtons(value);
    }

    @Override
    public DropTarget getDropTarget() {
        return this.imageList.getDropTarget();
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        this.imageList.setTransferHandler(newHandler);
        SwingHacks.fixDnDforKDE(this.imageList);
    }

    public ImageList getImageList() {
        return this.imageList;
    }

    public void setEventList(EventList<LocalFileItem> localFileList) {
        SortedList<LocalFileItem> sortedList = GlazedListsFactory.sortedList(localFileList, new LocationComparator());
        this.imageList.setModel(sortedList);
    }

    public void setPopupHandler(TablePopupHandler popupHandler) {
        this.imageList.setPopupHandler(popupHandler);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getParent() == null) {
            return dimension;
        }
        if (dimension.height > this.getParent().getSize().height) {
            return new Dimension(this.getParent().getWidth(), dimension.height);
        }
        return this.getParent().getSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getPosition(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getPosition(visibleRect, orientation, direction);
    }

    private int getPosition(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        int height = this.imageList.getFixedCellHeight();
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / height * height;
            return newPosition == 0 ? height : newPosition;
        }
        return (currentPosition / height + 1) * height - currentPosition;
    }

    public List<LocalFileItem> getSelection() {
        return this.imageList.getSelectedItems();
    }

    private static class LocationComparator
    implements Comparator<LocalFileItem> {
        private LocationComparator() {
        }

        @Override
        public int compare(LocalFileItem item1, LocalFileItem item2) {
            String location2;
            String location1 = item1.getPropertyString(FilePropertyKey.LOCATION);
            int value = location1.compareToIgnoreCase(location2 = item2.getPropertyString(FilePropertyKey.LOCATION));
            if (value == 0) {
                return item1.getFileName().compareToIgnoreCase(item2.getFileName());
            }
            return value;
        }
    }

    public static class MouseReaction
    implements MouseListener,
    MouseMotionListener {
        private final ImageList imageList;
        private final JComponent editor;
        private final JScrollPane scrollPane;

        public MouseReaction(ImageList imageList, JComponent editor, JScrollPane scrollPane) {
            this.imageList = imageList;
            this.editor = editor;
            this.scrollPane = scrollPane;
            imageList.addMouseListener(this);
            imageList.addMouseMotionListener(this);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.update(e.getPoint());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.editor.getBounds().contains(e.getPoint())) {
                this.editor.setVisible(false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = this.imageList.locationToIndex(e.getPoint());
            if (!(e.isPopupTrigger() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || index <= -1)) {
                this.imageList.setSelectedIndex(index);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.update(e.getPoint());
        }

        private void update(Point point) {
            int index;
            if (this.imageList.getModel().getSize() > 0 && (index = this.imageList.locationToIndex(point)) > -1) {
                this.editor.setVisible(true);
                Rectangle bounds = this.imageList.getCellBounds(index, index);
                ImageCellRenderer renderer = this.imageList.getImageCellRenderer();
                Point convertedPoint = SwingUtilities.convertPoint(this.imageList, new Point(bounds.x, bounds.y), this.scrollPane);
                this.editor.setLocation(convertedPoint.x + renderer.getPaddingInsets().left, convertedPoint.y + renderer.getPaddingInsets().top);
            }
        }
    }
}

