/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.io.IOUtils;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.util.FileUtils;

class M3UList {
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";
    private final File file;
    private final LocalFileList localFileList;

    public M3UList(File file, LocalFileList localFileList) {
        this.file = file;
        this.localFileList = localFileList;
    }

    public void load() {
        BackgroundExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List m3uFileList = M3UList.this.loadInternalList();
                    for (File file : m3uFileList) {
                        M3UList.this.localFileList.addFile(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        ArrayList writeableList;
        this.localFileList.getModel().getReadWriteLock().readLock().lock();
        try {
            writeableList = new ArrayList(this.localFileList.getModel().subList(0, this.localFileList.getModel().size()));
        }
        finally {
            this.localFileList.getModel().getReadWriteLock().readLock().unlock();
        }
        BackgroundExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    M3UList.this.saveInternalList(writeableList);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInternalList(List<LocalFileItem> writeableList) throws Exception {
        PrintWriter m3uFile = null;
        try {
            m3uFile = new PrintWriter(new FileWriter(this.file.getCanonicalPath(), false));
            m3uFile.write(M3U_HEADER);
            m3uFile.println();
            for (LocalFileItem currFile : writeableList) {
                if (!currFile.getFile().isFile() || currFile.isIncomplete()) continue;
                File locFile = currFile.getFile();
                m3uFile.write(SONG_DELIM);
                m3uFile.write(SEC_DELIM);
                if (currFile.getPropertyString(FilePropertyKey.LENGTH) != null) {
                    m3uFile.write("" + currFile.getPropertyString(FilePropertyKey.LENGTH) + ",");
                } else {
                    m3uFile.write("-1,");
                }
                m3uFile.write(currFile.getName());
                m3uFile.println();
                m3uFile.write(locFile.getCanonicalPath());
                m3uFile.println();
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(m3uFile);
            throw throwable;
        }
        IOUtils.close(m3uFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<File> loadInternalList() throws Exception {
        ArrayList<File> m3uFileList = new ArrayList<File>();
        BufferedReader m3uFile = null;
        try {
            m3uFile = new BufferedReader(new FileReader(this.file));
            String currLine = null;
            currLine = m3uFile.readLine();
            if (currLine == null) throw new IOException();
            if (!currLine.startsWith(M3U_HEADER) && !currLine.startsWith(SONG_DELIM)) {
                throw new IOException();
            }
            if (currLine.startsWith(M3U_HEADER)) {
                currLine = m3uFile.readLine();
            }
            while (currLine != null) {
                if (currLine.startsWith(SONG_DELIM)) {
                    currLine = m3uFile.readLine();
                    if (currLine == null) break;
                    File currentFile = new File(currLine);
                    if (currentFile.exists() && !currentFile.isDirectory()) {
                        m3uFileList.add(currentFile);
                    } else {
                        currentFile = new File(this.file.getParentFile().getAbsolutePath(), currentFile.getPath());
                        if (currentFile.exists() && !currentFile.isDirectory() && FileUtils.isReallyInParentPath(this.file.getParentFile(), currentFile)) {
                            m3uFileList.add(currentFile);
                        }
                    }
                }
                currLine = m3uFile.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(m3uFile);
            throw throwable;
        }
        IOUtils.close(m3uFile);
        return m3uFileList;
    }
}

