/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.manager.StoreProcess;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.util.EntryImpl;
import org.limewire.security.SecurityToken;

public class StoreManager
extends AbstractManager<StoreResult> {
    public StoreManager(Context context) {
        super(context);
    }

    public DHTFuture<StoreResult> store(Collection<? extends DHTValueEntity> values) {
        StoreProcess task = new StoreProcess(this.context, values);
        StoreFuture future = new StoreFuture(task);
        this.context.getDHTExecutorService().execute(future);
        return future;
    }

    public DHTFuture<StoreResult> store(Contact node, SecurityToken securityToken, Collection<? extends DHTValueEntity> values) {
        EntryImpl<Contact, SecurityToken> entry = new EntryImpl<Contact, SecurityToken>(node, securityToken);
        StoreProcess task = new StoreProcess(this.context, entry, values);
        StoreFuture future = new StoreFuture(task);
        this.context.getDHTExecutorService().execute(future);
        return future;
    }

    private class StoreFuture
    extends DHTFutureTask<StoreResult> {
        public StoreFuture(DHTTask<StoreResult> task) {
            super(StoreManager.this.context, task);
        }
    }
}

