/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.friend.api.FileMetaData;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;

public class FileMetaDataImpl
implements FileMetaData {
    private static final Element[] MANDATORY_FIELDS = new Element[]{Element.index, Element.name, Element.size, Element.createTime, Element.urns};
    protected final Map<String, String> data = new HashMap<String, String>();

    public FileMetaDataImpl() {
    }

    public FileMetaDataImpl(FileMetaData metaData) {
        this.setCreateTime(metaData.getCreateTime());
        this.setDescription(metaData.getDescription());
        this.setId(metaData.getId());
        this.setIndex(metaData.getIndex());
        this.setName(metaData.getName());
        this.setSize(metaData.getSize());
        this.setURNs(metaData.getUrns());
        if (!this.isValid()) {
            throw new IllegalArgumentException("is missing mandatory fields: " + this);
        }
    }

    public FileMetaDataImpl(Map<Element, String> data) {
        for (Map.Entry<Element, String> entry : data.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        if (!this.isValid()) {
            throw new IllegalArgumentException("is missing mandatory fields: " + this);
        }
    }

    protected boolean isValid() {
        for (Element element : MANDATORY_FIELDS) {
            if (this.get(element) != null) continue;
            return false;
        }
        try {
            this.getSize();
            this.getIndex();
            this.getCreateTime();
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private void put(Element element, String value) {
        this.data.put(element.toString(), value);
    }

    private String get(Element element) {
        return this.data.get(element.toString());
    }

    @Override
    public String getId() {
        return this.get(Element.id);
    }

    public void setId(String id) {
        this.put(Element.id, id);
    }

    @Override
    public String getName() {
        return this.get(Element.name);
    }

    public void setName(String name) {
        this.put(Element.name, Objects.nonNull(name, "name"));
    }

    @Override
    public long getSize() {
        return Long.valueOf(this.get(Element.size));
    }

    public void setSize(long size) {
        this.put(Element.size, Long.toString(size));
    }

    @Override
    public String getDescription() {
        return this.get(Element.description);
    }

    public void setDescription(String description) {
        this.put(Element.description, description);
    }

    @Override
    public long getIndex() {
        return Long.valueOf(this.get(Element.index));
    }

    public void setIndex(long index) {
        this.put(Element.index, Long.toString(index));
    }

    @Override
    public Set<String> getUrns() {
        StringTokenizer st = new StringTokenizer(this.get(Element.urns), " ");
        HashSet<String> set = new HashSet<String>();
        while (st.hasMoreElements()) {
            set.add(st.nextToken());
        }
        return set;
    }

    public void setURNs(Set<String> urns) {
        this.put(Element.urns, StringUtils.explode(urns, " "));
    }

    @Override
    public Date getCreateTime() {
        return new Date(Long.valueOf(this.get(Element.createTime)));
    }

    public void setCreateTime(Date date) {
        this.put(Element.createTime, Long.toString(date.getTime()));
    }

    @Override
    public Map<String, String> getSerializableMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public String toString() {
        return StringUtils.toString(this, this.data);
    }

    public static enum Element {
        id,
        name,
        size,
        description,
        index,
        metadata,
        urns,
        createTime;

    }
}

