/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search;

import com.google.inject.Inject;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.ArrayList;
import java.util.Map;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.impl.util.FilePropertyKeyPopulator;
import org.limewire.util.NameValue;

public class AdvancedQueryStringBuilder {
    private final LimeXMLDocumentFactory xmlDocumentFactory;

    @Inject
    AdvancedQueryStringBuilder(LimeXMLDocumentFactory xmlDocumentFactory) {
        this.xmlDocumentFactory = xmlDocumentFactory;
    }

    public String createSimpleCompositeQuery(Map<FilePropertyKey, String> advancedSearch) {
        StringBuilder sb = new StringBuilder();
        for (String value : advancedSearch.values()) {
            if (value == null || value.trim().length() <= 0) continue;
            sb.append(value);
            sb.append(' ');
        }
        int len = sb.length();
        if (len > 0) {
            sb.deleteCharAt(len - 1);
        }
        return QueryUtils.createQueryString(sb.toString());
    }

    public String createXMLQueryString(Map<FilePropertyKey, String> advancedSearch, Category category) {
        ArrayList<NameValue<String>> nvs = new ArrayList<NameValue<String>>();
        for (Map.Entry<FilePropertyKey, String> entry : advancedSearch.entrySet()) {
            String xmlName = FilePropertyKeyPopulator.getLimeXmlName(category, entry.getKey());
            if (xmlName == null) continue;
            nvs.add(new NameValue<String>(xmlName, entry.getValue()));
        }
        if (nvs.isEmpty()) {
            return "";
        }
        return this.xmlDocumentFactory.createLimeXMLDocument(nvs, FilePropertyKeyPopulator.getLimeXmlSchemaUri(category)).getXMLString();
    }
}

