/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderReader;
import org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.io.ContentDescriptionReader;
import org.jaudiotagger.audio.asf.io.ExtContentDescReader;
import org.jaudiotagger.audio.asf.io.FileHeaderReader;
import org.jaudiotagger.audio.asf.io.FullRequestInputStream;
import org.jaudiotagger.audio.asf.io.StreamChunkReader;
import org.jaudiotagger.audio.asf.tag.AsfTag;
import org.jaudiotagger.audio.asf.util.TagConverter;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;

public class AsfFileReader
extends AudioFileReader {
    private static final AsfHeaderReader HEADER_READER;

    private boolean determineVariableBitrate(AsfHeader header) {
        List<ContentDescriptor> descriptors;
        assert (header != null);
        boolean result = false;
        ExtendedContentDescription extDesc = header.findExtendedContentDescription();
        if (extDesc != null && (descriptors = extDesc.getDescriptors("IsVBR")) != null && !descriptors.isEmpty()) {
            result = Boolean.TRUE.toString().equals(descriptors.get(0).getString());
        }
        return result;
    }

    private GenericAudioHeader getAudioHeader(AsfHeader header) throws CannotReadException {
        GenericAudioHeader info = new GenericAudioHeader();
        if (header.getFileHeader() == null) {
            throw new CannotReadException("Invalid ASF/WMA file. File header object not available.");
        }
        if (header.getAudioStreamChunk() == null) {
            throw new CannotReadException("Invalid ASF/WMA file. No audio stream contained.");
        }
        info.setBitrate(header.getAudioStreamChunk().getKbps());
        info.setChannelNumber((int)header.getAudioStreamChunk().getChannelCount());
        info.setEncodingType("ASF (audio): " + header.getAudioStreamChunk().getCodecDescription());
        info.setLossless(header.getAudioStreamChunk().getCompressionFormat() == 355L);
        info.setPreciseLength(header.getFileHeader().getPreciseDuration());
        info.setSamplingRate((int)header.getAudioStreamChunk().getSamplingRate());
        info.setVariableBitRate(this.determineVariableBitrate(header));
        return info;
    }

    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        raf.seek(0L);
        GenericAudioHeader info = null;
        try {
            AsfHeader header = AsfHeaderReader.readInfoHeader(raf);
            if (header == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            info = this.getAudioHeader(header);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof CannotReadException) {
                throw (CannotReadException)e;
            }
            throw new CannotReadException("Failed to read. Cause: " + e.getMessage(), e);
        }
        return info;
    }

    private AsfTag getTag(AsfHeader header) {
        return TagConverter.createTagOf(header);
    }

    @Override
    protected AsfTag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        AsfTag tag;
        raf.seek(0L);
        try {
            AsfHeader header = AsfHeaderReader.readTagHeader(raf);
            if (header == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            tag = TagConverter.createTagOf(header);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof CannotReadException) {
                throw (CannotReadException)e;
            }
            throw new CannotReadException("Failed to read. Cause: " + e.getMessage());
        }
        return tag;
    }

    @Override
    public AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        if (!f.canRead()) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_DO_NOT_HAVE_PERMISSION_TO_READ_FILE.getMsg(f.getAbsolutePath()));
        }
        InputStream stream = null;
        try {
            stream = new FullRequestInputStream(new BufferedInputStream(new FileInputStream(f)));
            AsfHeader header = (AsfHeader)HEADER_READER.read(Utils.readGUID(stream), stream, 0L);
            if (header == null) {
                throw new CannotReadException(ErrorMessage.ASF_HEADER_MISSING.getMsg(f.getAbsolutePath()));
            }
            if (header.getFileHeader() == null) {
                throw new CannotReadException(ErrorMessage.ASF_FILE_HEADER_MISSING.getMsg(f.getAbsolutePath()));
            }
            if (header.getFileHeader().getFileSize().longValue() != f.length()) {
                // empty if block
            }
            AudioFile audioFile = new AudioFile(f, (AudioHeader)this.getAudioHeader(header), (Tag)this.getTag(header));
            return audioFile;
        }
        catch (Exception e) {
            throw new CannotReadException("\"" + f + "\" :" + e, e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception ex) {
                System.err.println("\"" + f + "\" :" + ex);
            }
        }
    }

    static {
        ArrayList<Class<? extends ChunkReader>> readers = new ArrayList<Class<? extends ChunkReader>>();
        readers.add(ContentDescriptionReader.class);
        readers.add(ExtContentDescReader.class);
        AsfExtHeaderReader extReader = new AsfExtHeaderReader(readers, true);
        readers.add(FileHeaderReader.class);
        readers.add(StreamChunkReader.class);
        HEADER_READER = new AsfHeaderReader(readers, true);
        HEADER_READER.setExtendedHeaderReader(extReader);
    }
}

