/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.rtp;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.codec.video.jpeg.JpegRTPHeader;
import net.sf.fmj.utility.LoggerSingleton;

public class LookAheadPushBufferStream
implements PushBufferStream {
    private static final Logger logger = LoggerSingleton.logger;
    private final PushBufferStream s;
    private final ProducerConsumerQueue q = new ProducerConsumerQueue();
    private Format fullFormat;
    private BufferTransferHandler transferHandler;

    public LookAheadPushBufferStream(PushBufferStream s) {
        this.s = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookAheadAndFindFullFormat() throws InterruptedException {
        Object o;
        this.s.setTransferHandler(new MyBufferTransferHandler());
        ProducerConsumerQueue producerConsumerQueue = this.q;
        synchronized (producerConsumerQueue) {
            this.q.waitUntilNotEmpty();
            o = this.q.get();
            this.q.put(o);
        }
        if (o instanceof IOException) {
            this.fullFormat = this.s.getFormat();
            return;
        }
        Buffer input = (Buffer)o;
        Format f = this.s.getFormat();
        if (f.getEncoding().equals("jpeg/rtp") && f.getClass() == VideoFormat.class) {
            JpegRTPHeader jpegRtpHeader;
            VideoFormat vf = (VideoFormat)f;
            JpegRTPHeader jpegRTPHeader = jpegRtpHeader = input.getLength() >= 8 ? JpegRTPHeader.parse((byte[])input.getData(), input.getOffset()) : null;
            if (jpegRtpHeader == null) {
                logger.warning("Expected buffer to be large enough for JPEG RTP Header");
                this.fullFormat = f;
            }
            this.fullFormat = new VideoFormat(vf.getEncoding(), new Dimension(jpegRtpHeader.getWidthInPixels(), jpegRtpHeader.getHeightInPixels()), vf.getMaxDataLength(), vf.getDataType(), vf.getFrameRate());
        } else {
            this.fullFormat = f;
        }
        logger.info("Full format: " + this.fullFormat);
        if (this.transferHandler != null) {
            this.transferHandler.transferData(this);
        }
    }

    public boolean endOfStream() {
        return this.s.endOfStream();
    }

    public ContentDescriptor getContentDescriptor() {
        return this.s.getContentDescriptor();
    }

    public long getContentLength() {
        return this.s.getContentLength();
    }

    public Object getControl(String controlType) {
        return this.s.getControl(controlType);
    }

    public Object[] getControls() {
        return this.s.getControls();
    }

    public Format getFormat() {
        if (this.fullFormat != null) {
            return this.fullFormat;
        }
        return this.s.getFormat();
    }

    public void read(Buffer buffer) throws IOException {
        if (!this.q.isEmpty()) {
            try {
                Object o = this.q.get();
                if (o instanceof IOException) {
                    throw (IOException)o;
                }
                Buffer b = (Buffer)o;
                buffer.copy(b);
                return;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("" + e);
            }
        }
        this.s.read(buffer);
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandler = transferHandler;
        this.s.setTransferHandler(transferHandler);
    }

    private class MyBufferTransferHandler
    implements BufferTransferHandler {
        private MyBufferTransferHandler() {
        }

        public void transferData(PushBufferStream stream) {
            if (LookAheadPushBufferStream.this.fullFormat == null) {
                try {
                    Buffer b = new Buffer();
                    try {
                        LookAheadPushBufferStream.this.s.read(b);
                    }
                    catch (IOException e) {
                        LookAheadPushBufferStream.this.q.put(e);
                    }
                    LookAheadPushBufferStream.this.q.put(b);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (LookAheadPushBufferStream.this.transferHandler != null) {
                LookAheadPushBufferStream.this.transferHandler.transferData(LookAheadPushBufferStream.this);
            }
        }
    }
}

