/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.content.unknown;

import com.lti.utils.synchronization.CloseableThread;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Demultiplexer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.InternalErrorEvent;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.filtergraph.CodecNode;
import net.sf.fmj.filtergraph.FilterGraph;
import net.sf.fmj.filtergraph.FilterGraphBuilder;
import net.sf.fmj.filtergraph.MuxNode;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.RendererNode;
import net.sf.fmj.gui.controlpanelfactory.ControlPanelFactorySingleton;
import net.sf.fmj.media.AbstractProcessor;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
extends AbstractProcessor {
    protected static final int PLAYER = 1;
    protected static final int PROCESSOR = 2;
    private final int mode;
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private Time duration;
    private Component visualComponent;
    private TrackThread[] trackThreads;
    private static final boolean TRACE = true;
    private FilterGraph filterGraph;
    private Demultiplexer demux;
    private int numTracks;
    private Track[] tracks;
    private Multiplexer mux;
    private Format[] muxInputFormats;
    private int[] muxInputTrackNumbers;
    private Time demuxDuration = DURATION_UNKNOWN;
    private boolean demuxOpenedAndStarted;
    private boolean firstStart = true;
    private TrackControl[] trackControls;

    public Handler() {
        this(1);
    }

    public Handler(int mode) {
        this.mode = mode;
    }

    @Override
    public void setSource(DataSource source) throws IncompatibleSourceException {
        logger.fine("DataSource: " + source);
        this.demux = FilterGraphBuilder.getSourceCompatibleDemultiplexer(source);
        if (this.demux == null) {
            throw new IncompatibleSourceException("Unable to build filter graph for: " + source);
        }
        this.demuxDuration = this.demux.getDuration();
        super.setSource(source);
    }

    private boolean getDemuxTracks() {
        if (this.tracks != null) {
            return true;
        }
        try {
            if (!this.openAndStartDemux()) {
                return false;
            }
            this.tracks = this.demux.getTracks();
            this.numTracks = this.tracks.length;
        }
        catch (BadHeaderException e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        return true;
    }

    private boolean openAndStartDemux() {
        if (this.demuxOpenedAndStarted) {
            return true;
        }
        try {
            this.demux.open();
            this.demux.start();
            this.demuxOpenedAndStarted = true;
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            try {
                this.closeDemux();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "" + t, t);
            }
            return false;
        }
    }

    private void closeDemux() {
        if (this.demux != null) {
            this.demux.close();
        }
        this.demuxOpenedAndStarted = false;
    }

    @Override
    public void doPlayerClose() {
        try {
            if (null != this.filterGraph) {
                this.filterGraph.closeExcludeDemux();
            }
        }
        catch (ResourceUnavailableException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
        }
        this.closeDemux();
        logger.info("Handler.doPlayerClose");
    }

    @Override
    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        return true;
    }

    @Override
    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    private void addCodecChainControls(Node node) {
        for (int i = 0; i < node.getNumDestLinks(); ++i) {
            Multiplexer m;
            Object[] controls;
            Node dest = node.getDestLink(i).getDestNode();
            if (dest instanceof CodecNode) {
                Codec c = ((CodecNode)dest).getCodec();
                controls = c.getControls();
                if (controls != null) {
                    for (Object o : controls) {
                        this.addControl((Control)o);
                    }
                }
                if (null == dest) continue;
                this.addCodecChainControls(dest);
                continue;
            }
            if (!(dest instanceof MuxNode) || (controls = (m = ((MuxNode)dest).getMultiplexer()).getControls()) == null) continue;
            for (Object o : controls) {
                this.addControl((Control)o);
            }
        }
    }

    @Override
    public boolean doPlayerRealize() {
        Renderer renderer;
        RendererNode rendererNode;
        RendererNode rendererNode2;
        try {
            if (!this.openAndStartDemux()) {
                this.postControllerErrorEvent("Failed to openAndStartDemux");
                return false;
            }
            if (this.mode == 1) {
                this.filterGraph = FilterGraphBuilder.buildGraphToRenderer(new ContentDescriptor(this.getSource().getContentType()), this.demux);
            } else {
                this.buildMux();
                this.filterGraph = FilterGraphBuilder.buildGraphToMux(new ContentDescriptor(this.getSource().getContentType()), this.demux, this.mux, this.muxInputFormats, this.muxInputTrackNumbers);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            this.closeDemux();
            this.postControllerErrorEvent("" + e);
            return false;
        }
        if (this.filterGraph == null) {
            logger.fine("unable to find a filter graph to connect from demux to renderer/mux");
            this.closeDemux();
            this.postControllerErrorEvent("unable to find a filter graph to connect from demux to renderer/mux");
            return false;
        }
        logger.fine("Filter graph:");
        this.filterGraph.printToLog();
        int videoTrackIndex = this.filterGraph.getVideoTrackIndex();
        if (this.mode == 1 && videoTrackIndex >= 0 && (rendererNode2 = this.filterGraph.getRendererNode(videoTrackIndex)) != null) {
            VideoRenderer videoRenderer = (VideoRenderer)rendererNode2.getRenderer();
            VideoFormat videoRendererInputFormat = (VideoFormat)rendererNode2.getInputFormat();
            this.visualComponent = videoRenderer.getComponent();
            this.visualComponent.setSize(videoRendererInputFormat.getSize());
            videoRenderer.setBounds(new Rectangle(videoRendererInputFormat.getSize()));
        }
        int audioTrackIndex = this.filterGraph.getAudioTrackIndex();
        if (this.mode == 1 && audioTrackIndex >= 0 && (rendererNode = this.filterGraph.getRendererNode(audioTrackIndex)) != null && (renderer = rendererNode.getRenderer()) instanceof Clock) {
            Clock rendererAsClock = (Clock)((Object)renderer);
            try {
                TimeBase timeBase = rendererAsClock.getTimeBase();
                rendererAsClock.setTimeBase(timeBase);
            }
            catch (IncompatibleTimeBaseException e) {
                logger.log(Level.WARNING, "" + e, e);
                this.postControllerErrorEvent("" + e);
                return false;
            }
        }
        try {
            this.filterGraph.openExcludeDemux();
        }
        catch (ResourceUnavailableException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            return false;
        }
        Object[] controls = this.filterGraph.getRoot().getDemux().getControls();
        if (controls != null) {
            for (Object o : controls) {
                this.addControl((Control)o);
            }
        }
        this.addCodecChainControls(this.filterGraph.getRoot());
        if (this.mode == 1) {
            for (int trackIndex = 0; trackIndex < this.filterGraph.getNumTracks(); ++trackIndex) {
                Renderer renderer2;
                Object[] controls2;
                RendererNode rendererNode3 = this.filterGraph.getRendererNode(trackIndex);
                if (rendererNode3 == null || (controls2 = (renderer2 = rendererNode3.getRenderer()).getControls()) == null) continue;
                for (Object o : controls2) {
                    this.addControl((Control)o);
                    if (!(o instanceof GainControl)) continue;
                    this.setGainControl((GainControl)o);
                }
            }
        }
        logger.fine("Starting filter graph(s)");
        try {
            this.filterGraph.start();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            return false;
        }
        this.trackThreads = new TrackThread[this.filterGraph.getNumTracks()];
        for (int i = 0; i < this.filterGraph.getNumTracks(); ++i) {
            if (!this.filterGraph.isTrackEnabled(i)) continue;
            FilterGraph filterGraphCopy = this.filterGraph.duplicate();
            this.trackThreads[i] = new TrackThread(filterGraphCopy, i, videoTrackIndex == i ? FilterGraph.SUPPRESS_TRACK_READ : 0);
        }
        return true;
    }

    @Override
    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = ControlPanelFactorySingleton.getInstance().getControlPanelComponent(this);
            this.setControlPanelComponent(c);
        }
        return c;
    }

    private void checkAllTracksEOM() {
        for (int i = 0; i < this.trackThreads.length; ++i) {
            if (this.trackThreads[i] == null || this.trackThreads[i].isEOM()) continue;
            return;
        }
        try {
            this.endOfMedia();
        }
        catch (ClockStoppedException e) {
            this.postEvent(new InternalErrorEvent(this, "Controller not in Started state at EOM"));
        }
    }

    @Override
    public void doPlayerSetMediaTime(Time t) {
        logger.info("Handler.doPlayerSetMediaTime " + t.getSeconds());
        this.filterGraph.getRoot().getDemux().setPosition(t, 0);
    }

    @Override
    public float doPlayerSetRate(float rate) {
        logger.fine("Handler.doPlayerSetRate " + rate);
        if (rate == 0.0f) {
            return this.getRate();
        }
        if (rate < 0.0f) {
            return this.getRate();
        }
        return rate;
    }

    @Override
    public boolean doPlayerStop() {
        logger.info("Handler.doPlayerStop");
        if (this.trackThreads == null) {
            return true;
        }
        ArrayList<TrackThread> waitUntilClosed = new ArrayList<TrackThread>();
        for (int i = 0; i < this.trackThreads.length; ++i) {
            TrackThread t = this.trackThreads[i];
            if (t == null || !t.isAlive()) continue;
            t.close();
            waitUntilClosed.add(t);
        }
        for (TrackThread t : waitUntilClosed) {
            try {
                t.waitUntilClosed();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                return false;
            }
        }
        try {
            this.filterGraph.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            return false;
        }
        return true;
    }

    @Override
    public boolean doPlayerSyncStart(Time time) {
        int i;
        logger.info("Handler.doPlayerSyncStart " + time.getSeconds() + " " + this.getState());
        if (this.firstStart) {
            this.firstStart = false;
        } else {
            logger.fine("Starting filter graph(s)");
            try {
                this.filterGraph.start();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                this.postControllerErrorEvent("" + e);
                return false;
            }
            this.trackThreads = new TrackThread[this.filterGraph.getNumTracks()];
            for (i = 0; i < this.filterGraph.getNumTracks(); ++i) {
                if (!this.filterGraph.isTrackEnabled(i)) continue;
                FilterGraph filterGraphCopy = this.filterGraph.duplicate();
                this.trackThreads[i] = new TrackThread(filterGraphCopy, i, 0);
            }
        }
        for (i = 0; i < this.trackThreads.length; ++i) {
            TrackThread t = this.trackThreads[i];
            if (t == null) continue;
            t.start();
        }
        return true;
    }

    private static final String toString(Time d) {
        if (d == null) {
            return "null";
        }
        if (d.getNanoseconds() == Time.TIME_UNKNOWN.getNanoseconds()) {
            return "[Unknown]";
        }
        if (d.getNanoseconds() == Duration.DURATION_UNBOUNDED.getNanoseconds()) {
            return "[Unbounded]";
        }
        return "" + d.getNanoseconds();
    }

    @Override
    public Time getPlayerDuration() {
        if (this.getState() < 200 || this.filterGraph == null) {
            logger.fine("getPlayerDuration: returning demuxDuration");
            return this.demuxDuration;
        }
        Time duration = null;
        Track[] tracks = this.filterGraph.getTracks();
        for (int i = 0; i < tracks.length; ++i) {
            try {
                if (!tracks[i].isEnabled()) continue;
                Time d = tracks[i].getDuration();
                logger.fine("Track " + i + " has duration of " + Handler.toString(d));
                if (duration == null) {
                    duration = d;
                    continue;
                }
                if (d == DURATION_UNKNOWN) {
                    duration = d;
                    break;
                }
                if (duration == DURATION_UNBOUNDED || d != DURATION_UNBOUNDED && d.getNanoseconds() <= duration.getNanoseconds()) continue;
                duration = d;
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
        if (duration == null) {
            logger.fine("getPlayerDuration: returning DURATION_UNKNOWN (2)");
            return DURATION_UNKNOWN;
        }
        logger.fine("getPlayerDuration: returning " + Handler.toString(duration));
        return duration;
    }

    @Override
    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    @Override
    public Component getVisualComponent() {
        return this.visualComponent;
    }

    @Override
    public boolean doConfigure() {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    @Override
    public DataSource getDataOutput() throws NotRealizedError {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        if (this.getState() < 300) {
            throw new NotRealizedError("Cannot call getDataOutput on an unrealized Processor.");
        }
        return this.filterGraph.getDataOutput();
    }

    @Override
    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        if (this.getState() < 180) {
            throw new NotConfiguredError("Cannot call getTrackControls on an unconfigured Processor.");
        }
        if (this.trackControls == null) {
            try {
                if (!this.getDemuxTracks()) {
                    throw new RuntimeException("Unable to get demux tracks");
                }
                Track[] tracks = this.demux.getTracks();
                this.trackControls = new TrackControl[tracks.length];
                for (int trackNum = 0; trackNum < tracks.length; ++trackNum) {
                    this.trackControls[trackNum] = new MyTrackControl(trackNum);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (BadHeaderException e) {
                throw new RuntimeException(e);
            }
        }
        return this.trackControls;
    }

    @Override
    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        if (this.getState() < 180) {
            throw new NotConfiguredError("Cannot call getSupportedContentDescriptors on an unconfigured Processor.");
        }
        List<Multiplexer> muxs = FilterGraphBuilder.findMuxs();
        ArrayList<ContentDescriptor> result = new ArrayList<ContentDescriptor>();
        for (int i = 0; i < muxs.size(); ++i) {
            Multiplexer mux = muxs.get(i);
            ContentDescriptor[] f = mux.getSupportedOutputContentDescriptors(null);
            for (int j = 0; j < f.length; ++j) {
                result.add(f[j]);
            }
        }
        ContentDescriptor[] arrayResult = new ContentDescriptor[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            arrayResult[i] = (ContentDescriptor)result.get(i);
        }
        return arrayResult;
    }

    private void buildMux() {
        if (this.mux != null) {
            return;
        }
        if (!this.getDemuxTracks()) {
            throw new RuntimeException("Unable to get demux tracks");
        }
        this.mux = FilterGraphBuilder.findMux(this.outputContentDescriptor);
        if (this.mux == null) {
            throw new RuntimeException("Unable to find mux for " + this.outputContentDescriptor);
        }
        int numMuxInputTracks = this.mux.setNumTracks(this.numTracks);
        if (numMuxInputTracks != this.numTracks) {
            logger.warning("Multiplexer only supports " + numMuxInputTracks + " tracks, not " + this.numTracks);
        }
        this.mux.setContentDescriptor(this.outputContentDescriptor);
        this.muxInputFormats = new Format[numMuxInputTracks];
        this.muxInputTrackNumbers = new int[this.numTracks];
        int nextMuxInputTrackNumber = 0;
        for (int i = 0; i < this.numTracks; ++i) {
            int muxInputTrackNumber;
            this.muxInputTrackNumbers[i] = -1;
            if ((this.tracks[i].getFormat() instanceof VideoFormat && Handler.anyFormatInstanceOf(this.mux.getSupportedInputFormats(), VideoFormat.class) || this.tracks[i].getFormat() instanceof AudioFormat && Handler.anyFormatInstanceOf(this.mux.getSupportedInputFormats(), AudioFormat.class)) && nextMuxInputTrackNumber < numMuxInputTracks) {
                this.muxInputTrackNumbers[i] = nextMuxInputTrackNumber++;
            }
            if ((muxInputTrackNumber = this.muxInputTrackNumbers[i]) < 0) continue;
            this.muxInputFormats[muxInputTrackNumber] = this.mux.setInputFormat(this.tracks[i].getFormat(), muxInputTrackNumber);
            if (this.muxInputFormats[muxInputTrackNumber] != null) continue;
            logger.warning("Multiplexer " + this.mux + " did not accept input format " + this.tracks[i].getFormat());
            this.muxInputFormats[muxInputTrackNumber] = this.mux.setInputFormat(this.mux.getSupportedInputFormats()[0], this.muxInputTrackNumbers[i]);
        }
    }

    private static boolean anyFormatInstanceOf(Format[] formats, Class<? extends Format> target) {
        for (Format f : formats) {
            if (!target.isAssignableFrom(f.getClass())) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ void access$000(Handler x0) {
        x0.checkAllTracksEOM();
    }

    static /* synthetic */ void access$200(Handler x0, String x1) {
        x0.postControllerErrorEvent(x1);
    }

    private class MyTrackControl
    implements TrackControl {
        private final int trackNum;
        private boolean enabled = true;

        public MyTrackControl(int trackNum) {
            this.trackNum = trackNum;
        }

        public void setCodecChain(Codec[] codecs) throws UnsupportedPlugInException, NotConfiguredError {
            logger.warning("Not yet supported: setCodecChain");
        }

        public void setRenderer(Renderer renderer) throws UnsupportedPlugInException, NotConfiguredError {
            logger.warning("Not yet supported: setRenderer");
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            if (!Handler.this.getDemuxTracks()) {
                throw new RuntimeException("Unable to get demux tracks");
            }
            if (Handler.this.muxInputFormats == null) {
                return Handler.this.tracks[this.trackNum].getFormat();
            }
            return Handler.this.muxInputFormats[Handler.this.muxInputTrackNumbers[this.trackNum]];
        }

        public Format[] getSupportedFormats() {
            Handler.this.buildMux();
            return Handler.this.mux.getSupportedInputFormats();
        }

        public boolean isEnabled() {
            if (!Handler.this.getDemuxTracks()) {
                throw new RuntimeException("Unable to get demux tracks");
            }
            return Handler.this.tracks[this.trackNum].isEnabled();
        }

        public void setEnabled(boolean enabled) {
            if (!Handler.this.getDemuxTracks()) {
                throw new RuntimeException("Unable to get demux tracks");
            }
            Handler.this.tracks[this.trackNum].setEnabled(enabled);
        }

        public Format setFormat(Format format) {
            Handler.this.buildMux();
            if (Handler.this.tracks[this.trackNum].getFormat() instanceof VideoFormat && !(format instanceof VideoFormat)) {
                logger.fine("Rejecting MUX input format " + format + " because a filter graph will not be able to be built from " + Handler.this.tracks[this.trackNum].getFormat());
                return null;
            }
            if (Handler.this.tracks[this.trackNum].getFormat() instanceof AudioFormat && !(format instanceof AudioFormat)) {
                logger.fine("Rejecting MUX input format " + format + " because a filter graph will not be able to be built from " + Handler.this.tracks[this.trackNum].getFormat());
                return null;
            }
            if (Handler.this.muxInputTrackNumbers[this.trackNum] < 0) {
                logger.fine("Rejecting MUX input format " + format + " for track " + this.trackNum + " because there is no corresponding mux input track");
                return null;
            }
            Format result = Handler.this.mux.setInputFormat(format, Handler.this.muxInputTrackNumbers[this.trackNum]);
            if (result == null) {
                logger.fine("Multiplexer rejected input format for track " + this.trackNum + ": " + format);
                return null;
            }
            ((Handler)Handler.this).muxInputFormats[((Handler)Handler.this).muxInputTrackNumbers[this.trackNum]] = result;
            return Handler.this.muxInputFormats[Handler.this.muxInputTrackNumbers[this.trackNum]];
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class TrackThread
    extends CloseableThread {
        private final int trackNumber;
        private final FilterGraph filterGraph;
        private final int firstFlags;
        private long nanoseconds;
        private boolean eom = false;

        public TrackThread(FilterGraph filterGraph, int trackNumber, int firstFlags) {
            this.setName("TrackThread for track " + trackNumber);
            this.setDaemon(true);
            this.filterGraph = filterGraph;
            this.trackNumber = trackNumber;
            this.firstFlags = firstFlags;
        }

        private Buffer readAndProcessNextFrame(int flags) {
            int result = this.filterGraph.process(null, this.trackNumber, -1, flags);
            if ((result & 1) != 0) {
                throw new RuntimeException("BUFFER_PROCESSED_FAILED");
            }
            Buffer b = this.filterGraph.getRoot().getOutputBuffer(this.trackNumber);
            if (b == null) {
                throw new NullPointerException();
            }
            return b;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean isEOM() {
            return this.eom;
        }
    }
}

