/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.ResourceUnavailableException;
import net.sf.fmj.filtergraph.InputPin;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.OutputPin;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class Node {
    protected static final Logger logger = LoggerSingleton.logger;
    private List<Link> destLinks = new ArrayList<Link>();
    private final InputPin[] inputPins;
    private final OutputPin[] outputPins;
    private final PlugIn plugIn;

    public Node(PlugIn plugIn, int numInputPins, int numOutputPins) {
        this.plugIn = plugIn;
        this.inputPins = new InputPin[numInputPins];
        this.outputPins = new OutputPin[numOutputPins];
    }

    public Link getDestLink(InputPin pin) {
        for (Link link : this.destLinks) {
            if (link.getDestPin() != pin) continue;
            return link;
        }
        return null;
    }

    public Link getDestLink(OutputPin pin) {
        for (Link link : this.destLinks) {
            if (link.getSourcePin() != pin) continue;
            return link;
        }
        return null;
    }

    public boolean removeDestLink(Link link) {
        return this.destLinks.remove(link);
    }

    public InputPin getInputPin(int index) {
        if (this.inputPins[index].getOwnerNode() == null) {
            throw new NullPointerException();
        }
        return this.inputPins[index];
    }

    public InputPin getInputPinByTrack(int track) {
        for (InputPin p : this.inputPins) {
            if (p.getTrack() != track) continue;
            if (p.getOwnerNode() == null) {
                throw new NullPointerException();
            }
            return p;
        }
        throw new IllegalArgumentException("" + track);
    }

    public OutputPin getOutputPinByTrack(int track) {
        for (OutputPin p : this.outputPins) {
            if (p.getTrack() != track) continue;
            if (p.getOwnerNode() == null) {
                throw new NullPointerException();
            }
            return p;
        }
        throw new IllegalArgumentException("" + track);
    }

    public int getNumInputPins() {
        return this.inputPins.length;
    }

    public OutputPin getOutputPin(int index) {
        return this.outputPins[index];
    }

    public int getNumOutputPins() {
        return this.outputPins.length;
    }

    protected void setInputPin(int index, InputPin pin) {
        if (pin.getOwnerNode() == null) {
            throw new NullPointerException();
        }
        this.inputPins[index] = pin;
    }

    protected void setOutputPin(int index, OutputPin pin) {
        if (pin.getOwnerNode() == null) {
            throw new NullPointerException();
        }
        this.outputPins[index] = pin;
    }

    public int getNumDestLinks() {
        return this.destLinks.size();
    }

    public Link getDestLink(int i) {
        try {
            return this.destLinks.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
    }

    public Buffer getOutputBuffer(int i) {
        try {
            return this.outputPins[i].getBuffer();
        }
        catch (IndexOutOfBoundsException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
    }

    public void setOutputBuffer(int i, Buffer b) {
        this.outputPins[i].setBuffer(b);
    }

    public void addDestLink(Link n) {
        this.destLinks.add(n);
    }

    public abstract Node duplicate();

    public void open() throws ResourceUnavailableException {
        this.getPlugIn().open();
    }

    public final void close() {
        this.getPlugIn().close();
    }

    public abstract int process(Buffer var1, int var2, int var3, int var4);

    protected Node propagateDuplicate(Node result) {
        for (int i = 0; i < this.getNumDestLinks(); ++i) {
            Link link = this.getDestLink(i);
            if (link != null) {
                if (link.getDestNode() == null) {
                    throw new NullPointerException("link.getDestNode()");
                }
                if (link.getDestPin() == null) {
                    throw new NullPointerException("link.getDestPin(), link.getDestNode()=" + link.getDestNode());
                }
                result.addDestLink(new Link(result.getOutputPin(link.getSourcePin().getPinNumber()), link.getDestNode().duplicate().getInputPin(link.getDestPin().getPinNumber())));
                continue;
            }
            result.addDestLink(null);
        }
        return result;
    }

    public void print(Logger logger, String prefix) {
        String inputFormatStr = this.getInputFormat() == null ? "" : this.getInputFormat().getClass().getSimpleName() + " [" + this.getInputFormat() + "]";
        logger.info(prefix + inputFormatStr);
        logger.info(prefix + this.getPlugIn().getClass().getName());
    }

    public abstract Format getInputFormat();

    public final PlugIn getPlugIn() {
        return this.plugIn;
    }

    public void start() throws IOException {
    }

    public void stop() {
    }

    abstract Format setPlugInInputFormat(InputPin var1, Format var2);

    abstract Format setPlugInOutputFormat(OutputPin var1, Format var2);

    public abstract int getPlugInType();
}

