/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileDescChangeEvent;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLReplyCollectionFactory;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.XmlController;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;

@EagerSingleton
public class SchemaReplyCollectionMapper
implements XmlController {
    private final Map<String, LimeXMLReplyCollection> mapper;
    protected final Provider<LimeXMLReplyCollectionFactory> limeXMLReplyCollectionFactory;
    protected final Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository;

    @Inject
    SchemaReplyCollectionMapper(Provider<LimeXMLReplyCollectionFactory> limeXMLReplyCollectionFactory, Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository) {
        this.limeXMLReplyCollectionFactory = limeXMLReplyCollectionFactory;
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
        this.mapper = new ConcurrentHashMap<String, LimeXMLReplyCollection>();
    }

    public void add(String schemaURI, LimeXMLReplyCollection replyCollection) {
        this.mapper.put(schemaURI, replyCollection);
    }

    public LimeXMLReplyCollection getReplyCollection(String schemaURI) {
        return this.mapper.get(schemaURI);
    }

    public Collection<LimeXMLReplyCollection> getCollections() {
        return this.mapper.values();
    }

    @Inject
    void register(ServiceRegistry registry, final Library managedList, ListenerSupport<FileDescChangeEvent> fileDescSupport) {
        registry.register(new Service(){

            @Override
            public String getServiceName() {
                return I18nMarker.marktr("Metadata Loader");
            }

            @Override
            public void initialize() {
                SchemaReplyCollectionMapper.this.loadSchemas();
                managedList.addListener(new EventListener<FileViewChangeEvent>(){

                    @Override
                    public void handleEvent(FileViewChangeEvent event) {
                        switch (event.getType()) {
                            case FILE_REMOVED: {
                                SchemaReplyCollectionMapper.this.removeFileDesc(event.getFileDesc());
                                break;
                            }
                            case FILE_CHANGED: {
                                SchemaReplyCollectionMapper.this.removeFileDesc(event.getOldValue());
                                break;
                            }
                            case FILES_CLEARED: {
                                SchemaReplyCollectionMapper.this.loadSchemas();
                            }
                        }
                    }
                });
                managedList.addManagedListStatusListener(new EventListener<LibraryStatusEvent>(){

                    @Override
                    public void handleEvent(LibraryStatusEvent event) {
                        switch (event.getType()) {
                            case LOAD_FINISHING: {
                                SchemaReplyCollectionMapper.this.finishLoading();
                                break;
                            }
                            case SAVE: {
                                SchemaReplyCollectionMapper.this.save(event);
                            }
                        }
                    }
                });
            }

            @Override
            public void start() {
            }

            @Override
            public void stop() {
            }
        });
    }

    private void removeFileDesc(FileDesc fd) {
        List<LimeXMLDocument> xmlDocs = fd.getLimeXMLDocuments();
        LinkedList<String> schemas = new LinkedList<String>();
        for (LimeXMLDocument doc : xmlDocs) {
            schemas.add(doc.getSchemaURI());
        }
        for (String uri : schemas) {
            LimeXMLReplyCollection col = this.getReplyCollection(uri);
            if (col == null) continue;
            col.removeDoc(fd);
        }
    }

    private void finishLoading() {
        Collection<LimeXMLReplyCollection> replies = this.getCollections();
        for (LimeXMLReplyCollection col : replies) {
            col.loadFinished();
        }
    }

    private void save(LibraryStatusEvent event) {
        if (event.getLibrary().isLoadFinished()) {
            Collection<LimeXMLReplyCollection> replies = this.getCollections();
            for (LimeXMLReplyCollection col : replies) {
                col.writeMapToDisk();
            }
        }
    }

    @Override
    public boolean canConstructXml(FileDesc fd) {
        Collection<LimeXMLReplyCollection> replies = this.getCollections();
        for (LimeXMLReplyCollection col : replies) {
            if (!col.canCreateDocument(fd.getFile())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean loadCachedXml(FileDesc fd, Collection<? extends LimeXMLDocument> prebuilt) {
        Collection<LimeXMLReplyCollection> replies = this.getCollections();
        boolean loaded = false;
        for (LimeXMLReplyCollection col : replies) {
            LimeXMLDocument doc = col.initialize(fd, prebuilt);
            if (doc == null) continue;
            loaded = true;
        }
        return loaded;
    }

    @Override
    public boolean loadXml(FileDesc fd) {
        Collection<LimeXMLReplyCollection> replies = this.getCollections();
        boolean loaded = false;
        for (LimeXMLReplyCollection col : replies) {
            LimeXMLDocument doc = col.createIfNecessary(fd);
            if (doc == null) continue;
            loaded = true;
        }
        return loaded;
    }

    private void loadSchemas() {
        String[] schemas;
        for (String schema : schemas = this.limeXMLSchemaRepository.get().getAvailableSchemaURIs()) {
            this.add(schema, this.limeXMLReplyCollectionFactory.get().createLimeXMLReplyCollection(schema));
        }
    }
}

