/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.google.inject.Inject;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.auth.ContentCache;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.auth.IpPortContentAuthorityFactory;
import com.limegroup.gnutella.auth.SettingsBasedContentAuthority;
import com.limegroup.gnutella.messages.vendor.ContentRequest;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.core.settings.ContentSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.service.ErrorService;

@EagerSingleton
public class ContentManager
implements Service {
    private static final Log LOG = LogFactory.getLog(ContentManager.class);
    private final Map<URN, Collection<Responder>> OBSERVERS = Collections.synchronizedMap(new HashMap());
    private final List<Responder> RESPONDERS = new ArrayList<Responder>();
    private final Set<URN> REQUESTED = Collections.synchronizedSet(new HashSet());
    private final Set<URN> TIMEOUTS = Collections.synchronizedSet(new HashSet());
    private final ContentCache CACHE = new ContentCache();
    private volatile ContentAuthority authority = null;
    private volatile boolean shutdown = false;
    private final IpPortContentAuthorityFactory ipPortContentAuthorityFactory;

    @Inject
    public ContentManager(IpPortContentAuthorityFactory ipPortContentAuthorityFactory) {
        this.ipPortContentAuthorityFactory = ipPortContentAuthorityFactory;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Content Management");
    }

    @Override
    public void start() {
        this.CACHE.initialize();
        this.startProcessingThread();
    }

    @Override
    public void stop() {
        this.shutdown = true;
        this.CACHE.writeToDisk();
    }

    public int getCacheSize() {
        return this.CACHE.getSize();
    }

    public void setContentAuthority(ContentAuthority authority) {
        this.authority = authority;
    }

    public boolean isVerified(URN urn) {
        return !ContentSettings.isManagementActive() || this.CACHE.hasResponseFor(urn) || this.TIMEOUTS.contains(urn);
    }

    public void request(URN urn, ContentResponseObserver observer, long timeout) {
        ContentResponseData response = this.CACHE.getResponse(urn);
        if (response != null || !ContentSettings.isManagementActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Immediate response for URN: " + urn + ", response: " + response);
            }
            observer.handleResponse(urn, response);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling request for URN: " + urn);
            }
            this.scheduleRequest(urn, observer, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentResponseData request(URN urn, long timeout) {
        Validator validator;
        Validator validator2 = validator = new Validator();
        synchronized (validator2) {
            this.request(urn, validator, timeout);
            if (validator.hasResponse()) {
                return validator.getResponse();
            }
            try {
                validator.wait();
            }
            catch (InterruptedException ix) {
                LOG.warn("Interrupted while waiting for response", ix);
            }
            return validator.getResponse();
        }
    }

    public ContentResponseData getResponse(URN urn) {
        return this.CACHE.getResponse(urn);
    }

    protected void scheduleRequest(URN urn, ContentResponseObserver observer, long timeout) {
        long now = System.currentTimeMillis();
        this.addResponder(new Responder(now, timeout, observer, urn));
        if (this.REQUESTED.add(urn) && this.authority != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending request for URN: " + urn + " to authority: " + this.authority);
            }
            this.authority.send(new ContentRequest(urn));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not sending request.  No authority or already requested.");
        }
    }

    public void handleContentResponse(ContentResponse responseMsg) {
        URN urn = responseMsg.getURN();
        if (urn != null && this.REQUESTED.remove(urn)) {
            Collection<Responder> responders;
            ContentResponseData response = new ContentResponseData(responseMsg);
            this.CACHE.addResponse(urn, response);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding response (" + response + ") for URN: " + urn);
            }
            if ((responders = this.OBSERVERS.remove(urn)) != null) {
                this.removeResponders(responders);
                for (Responder next : responders) {
                    next.observer.handleResponse(next.urn, response);
                }
            }
        } else if (LOG.isWarnEnabled()) {
            if (urn == null) {
                LOG.debug("No URN in response: " + responseMsg);
            } else {
                LOG.debug("Didn't request URN: " + urn + ", msg: " + responseMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResponders(Collection<Responder> responders) {
        int size = responders.size();
        int removed = 0;
        List<Responder> list = this.RESPONDERS;
        synchronized (list) {
            for (int i = this.RESPONDERS.size() - 1; i >= 0; --i) {
                Responder next = this.RESPONDERS.get(i);
                if (responders.contains(next)) {
                    this.RESPONDERS.remove(i);
                    ++removed;
                }
                if (removed == size) break;
            }
        }
        if (removed != size) {
            LOG.warn("unable to remove all responders");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResponder(Responder responder) {
        Map<URN, Collection<Responder>> map = this.OBSERVERS;
        synchronized (map) {
            Collection<Responder> observers = this.OBSERVERS.get(responder.urn);
            if (observers == null) {
                observers = new HashSet<Responder>();
            }
            observers.add(responder);
            this.OBSERVERS.put(responder.urn, observers);
            if (responder.dead != 0L) {
                this.addForTimeout(responder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addForTimeout(Responder responder) {
        List<Responder> list = this.RESPONDERS;
        synchronized (list) {
            if (this.RESPONDERS.isEmpty()) {
                this.RESPONDERS.add(responder);
            } else if (responder.dead <= this.RESPONDERS.get(this.RESPONDERS.size() - 1).dead) {
                this.RESPONDERS.add(responder);
            } else {
                int insertion = Collections.binarySearch(this.RESPONDERS, responder);
                if (insertion < 0) {
                    insertion = (insertion + 1) * -1;
                }
                this.RESPONDERS.add(insertion, responder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeout(long now) {
        Responder next;
        ArrayList<Responder> responders = null;
        List<Responder> list = this.RESPONDERS;
        synchronized (list) {
            next = null;
            for (int i = this.RESPONDERS.size() - 1; i >= 0 && (next = this.RESPONDERS.get(i)).dead <= now; --i) {
                this.REQUESTED.remove(next.urn);
                this.TIMEOUTS.add(next.urn);
                if (responders == null) {
                    responders = new ArrayList<Responder>(2);
                }
                responders.add(next);
                this.RESPONDERS.remove(i);
                next = null;
            }
        }
        if (responders != null) {
            for (int i = 0; i < responders.size(); ++i) {
                next = (Responder)responders.get(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Timing out responder: " + next + " for URN: " + next.urn);
                }
                try {
                    next.observer.handleResponse(next.urn, null);
                    continue;
                }
                catch (Throwable t) {
                    ErrorService.error(t, "Content ContentResponseData Error");
                }
            }
        }
    }

    protected void startProcessingThread() {
        Thread timeouter = ThreadExecutor.newManagedThread(new Runnable(){

            @Override
            public void run() {
                if (ContentManager.this.authority == null) {
                    ContentManager.this.setDefaultContentAuthority();
                }
                while (!ContentManager.this.shutdown) {
                    try {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ix) {
                            // empty catch block
                        }
                        if (ContentManager.this.shutdown) continue;
                        ContentManager.this.timeout(System.currentTimeMillis());
                        continue;
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                        continue;
                    }
                    break;
                }
                return;
            }
        }, "ContentProcessor");
        timeouter.setDaemon(true);
        timeouter.start();
    }

    protected ContentAuthority getDefaultContentAuthority() {
        return new SettingsBasedContentAuthority(this.ipPortContentAuthorityFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultContentAuthority() {
        ContentAuthority auth = this.getDefaultContentAuthority();
        if (auth.initialize()) {
            HashSet<URN> alreadyReq = new HashSet<URN>();
            Set<URN> set = this.REQUESTED;
            synchronized (set) {
                alreadyReq.addAll(this.REQUESTED);
                this.setContentAuthority(auth);
            }
            for (URN urn : alreadyReq) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending delayed request for URN: " + urn + " to: " + auth);
                }
                auth.send(new ContentRequest(urn));
            }
        }
    }

    private static class Validator
    implements ContentResponseObserver {
        private boolean gotResponse = false;
        private ContentResponseData response = null;

        private Validator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(URN urn, ContentResponseData response) {
            Validator validator = this;
            synchronized (validator) {
                this.gotResponse = true;
                this.response = response;
                this.notify();
            }
        }

        public boolean hasResponse() {
            return this.gotResponse;
        }

        public ContentResponseData getResponse() {
            return this.response;
        }
    }

    private static class Responder
    implements Comparable<Responder> {
        private final long dead;
        private final ContentResponseObserver observer;
        private final URN urn;

        Responder(long now, long timeout, ContentResponseObserver observer, URN urn) {
            this.dead = timeout != 0L ? now + timeout : 0L;
            this.observer = observer;
            this.urn = urn;
        }

        @Override
        public int compareTo(Responder o) {
            return this.dead < o.dead ? 1 : (this.dead > o.dead ? -1 : 0);
        }
    }
}

