/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import java.net.InetSocketAddress;
import org.limewire.collection.FixedsizeForgetfulHashMap;

@Singleton
public class UDPReplyHandlerCacheImpl
implements UDPReplyHandlerCache {
    private final UDPReplyHandlerFactory udpReplyHandlerFactory;
    private final FixedsizeForgetfulHashMap<InetSocketAddress, UDPReplyHandler> udpReplyHandlerCache = new FixedsizeForgetfulHashMap(500);

    @Inject
    public UDPReplyHandlerCacheImpl(UDPReplyHandlerFactory udpReplyHandlerFactory) {
        this.udpReplyHandlerFactory = udpReplyHandlerFactory;
    }

    @Override
    public synchronized UDPReplyHandler getUDPReplyHandler(InetSocketAddress addr) {
        UDPReplyHandler handler = (UDPReplyHandler)this.udpReplyHandlerCache.get(addr);
        if (handler == null) {
            handler = this.udpReplyHandlerFactory.createUDPReplyHandler(addr);
            this.udpReplyHandlerCache.put(addr, handler);
        }
        return handler;
    }

    @Override
    public synchronized void clear() {
        this.udpReplyHandlerCache.clear();
    }
}

