/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.core.settings.PingPongSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;

@EagerSingleton
public final class Pinger
implements Runnable,
Service {
    public static final int PING_INTERVAL = 3000;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public Pinger(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ConnectionServices connectionServices, Provider<MessageRouter> messageRouter, PingRequestFactory pingRequestFactory) {
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.messageRouter = messageRouter;
        this.pingRequestFactory = pingRequestFactory;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Peer Listener");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
        this.backgroundExecutor.scheduleWithFixedDelay(this, 3000L, 3000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (this.connectionServices.isSupernode() && PingPongSettings.PINGS_ACTIVE.getValue()) {
            PingRequest ping = this.pingRequestFactory.createPingRequest((byte)3);
            this.messageRouter.get().broadcastPingRequest(ping);
        }
    }
}

